/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.converting;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ModuleSettings;
import com.intellij.conversion.ProjectConverter;
import com.intellij.conversion.RunManagerSettings;
import com.intellij.facet.FacetTypeId;
import com.intellij.javaee.converting.JavaeeConvertingContext;
import com.intellij.javaee.converting.JavaeeModuleConvertingUtil;
import com.intellij.javaee.converting.JavaeeRunConfigurationConvertingUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import org.jdom.Element;

public class JavaeeProjectConverter
extends ProjectConverter {
    private JavaeeConvertingContext myContext = new JavaeeConvertingContext();

    public ConversionProcessor<ModuleSettings> createModuleFileConverter() {
        return new MyModuleConverter();
    }

    public ConversionProcessor<RunManagerSettings> createRunConfigurationsConverter() {
        return new MyRunConfigurationsConverter();
    }

    private class MyRunConfigurationsConverter
    extends ConversionProcessor<RunManagerSettings> {
        private MyRunConfigurationsConverter() {
        }

        public boolean isConversionNeeded(RunManagerSettings settings) {
            for (Element element : settings.getRunConfigurations()) {
                if (!JavaeeRunConfigurationConvertingUtil.isConversionNeeded(element)) continue;
                return true;
            }
            return false;
        }

        public void process(RunManagerSettings settings) throws CannotConvertException {
            for (Element element : settings.getRunConfigurations()) {
                JavaeeRunConfigurationConvertingUtil.convertRunConfiguration(element, JavaeeProjectConverter.this.myContext);
            }
        }
    }

    private class MyModuleConverter
    extends ConversionProcessor<ModuleSettings> {
        private MyModuleConverter() {
        }

        public boolean isConversionNeeded(ModuleSettings moduleSettings) {
            return JavaeeModuleConvertingUtil.getFacetType(moduleSettings.getRootElement()) != null;
        }

        public void preProcess(ModuleSettings moduleSettings) {
            FacetTypeId<? extends JavaeeFacet> type = JavaeeModuleConvertingUtil.getFacetType(moduleSettings.getRootElement());
            if (type != null) {
                String moduleName = moduleSettings.getModuleName();
                JavaeeProjectConverter.this.myContext.registerModule(moduleName, type);
            }
        }

        public void process(ModuleSettings moduleSettings) {
            JavaeeModuleConvertingUtil.convertRootElement(moduleSettings.getRootElement(), moduleSettings.getModuleName(), JavaeeProjectConverter.this.myContext);
        }
    }
}

