/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server.async;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.javaee.oss.server.DeploymentStatusManager;
import com.intellij.javaee.oss.server.JavaeeServerExtension;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.oss.server.JavaeeServerInstanceImpl;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.localRun.ExecutableObject;
import com.intellij.javaee.serverInstances.DefaultServerInstance;
import com.intellij.javaee.serverInstances.J2EEServerEvent;
import com.intellij.javaee.serverInstances.J2EEServerStateListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public abstract class JavaeeAsyncInstanceBase
extends DefaultServerInstance
implements JavaeeServerInstance {
    private static final Logger LOG = Logger.getInstance(JavaeeAsyncInstanceBase.class);
    private final AtomicBoolean myPureIsConnectedQueued;
    private final DeploymentStatusManager myDeploymentStatusManager;
    private final JavaeeServerInstanceImpl myPureInstance;
    private Boolean myPureConnectResult;
    private boolean myPureConnectExceptionRisen;
    private final ExecutorService myTaskExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"JavaeeAsyncInstanceBase pool");
    private volatile boolean myShutdown;
    private boolean myConnected;

    protected JavaeeAsyncInstanceBase(JavaeeServerInstanceImpl pureInstance, DeploymentStatusManager deploymentStatusManager) {
        super(pureInstance.getCommonModel());
        this.myPureInstance = pureInstance;
        this.myDeploymentStatusManager = deploymentStatusManager;
        this.myPureIsConnectedQueued = new AtomicBoolean(false);
        this.myPureConnectResult = null;
        this.myPureConnectExceptionRisen = false;
        this.myConnected = true;
    }

    private JavaeeServerInstanceImpl getPureInstance() {
        return this.myPureInstance;
    }

    public void start(ProcessHandler processHandler) {
        this.getPureInstance().start(processHandler);
    }

    public boolean isStopped() {
        return this.getPureInstance().isStopped();
    }

    public boolean isStarting() {
        return false;
    }

    public boolean isConnected() {
        if (this.myPureConnectResult == null) {
            return true;
        }
        if (this.myPureConnectExceptionRisen) {
            return false;
        }
        if (this.myPureIsConnectedQueued.compareAndSet(false, true)) {
            this.myTaskExecutor.submit(() -> {
                if (this.myShutdown) {
                    return;
                }
                this.myConnected = this.getPureInstance().isConnected();
                this.myPureIsConnectedQueued.set(false);
            });
        }
        return this.myConnected;
    }

    public void shutdown() {
        this.myTaskExecutor.submit(() -> {
            this.getPureInstance().shutdown();
            this.myConnected = false;
            this.myShutdown = true;
        });
    }

    public boolean connect() {
        this.myDeploymentStatusManager.updateAllDeploymentStatus();
        this.myTaskExecutor.submit(() -> {
            if (this.myShutdown) {
                return;
            }
            try {
                this.myPureConnectResult = this.getPureInstance().connect();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                this.myPureConnectExceptionRisen = true;
                this.myPureConnectResult = false;
            }
            this.myConnected = this.myPureConnectResult;
            if (!this.myPureConnectResult.booleanValue()) {
                this.handleConnectFailed(this.myPureConnectExceptionRisen);
            }
        });
        return true;
    }

    public void registerServerError(Throwable e1) {
        this.getPureInstance().registerServerError(e1);
    }

    public void addServerListener(J2EEServerStateListener j2EEServerStateListener) {
        this.getPureInstance().addServerListener(j2EEServerStateListener);
    }

    public void removeServerListener(J2EEServerStateListener j2EEServerStateListener) {
        this.getPureInstance().removeServerListener(j2EEServerStateListener);
    }

    public AppServerIntegration getIntegration() {
        return this.getPureInstance().getIntegration();
    }

    public String getName() {
        return this.getPureInstance().getName();
    }

    public CommonModel getCommonModel() {
        return this.getPureInstance().getCommonModel();
    }

    @Override
    public void deploy(DeploymentModel model) {
        this.myTaskExecutor.submit(() -> {
            if (this.myShutdown) {
                return;
            }
            this.getPureInstance().deploy(model);
        });
    }

    @Override
    public void undeploy(DeploymentModel model) {
        this.myTaskExecutor.submit(() -> {
            if (this.myShutdown) {
                return;
            }
            this.getPureInstance().undeploy(model);
        });
    }

    @Override
    public void updateDeploymentStatus(DeploymentModel model) {
        if (this.myPureConnectResult == null) {
            this.getPureInstance().setDeploymentStatus(model, DeploymentStatus.DISCONNECTED);
            return;
        }
        this.getPureInstance().updateDeploymentStatus(model);
    }

    @Override
    public Project getProject() {
        return this.getPureInstance().getProject();
    }

    @Override
    public ProcessHandler getProcessHandler() {
        return this.getPureInstance().getProcessHandler();
    }

    @Override
    public void fireServerListeners(J2EEServerEvent event) {
        this.getPureInstance().fireServerListeners(event);
    }

    protected void handleConnectFailed(boolean exceptionRisen) {
        this.getPureInstance().getProcessHandler().notifyTextAvailable("Connection error", ProcessOutputTypes.STDERR);
    }

    public boolean isStartupScriptTerminatesAfterServerStartup(@NotNull ExecutableObject startupScript) {
        if (startupScript == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startupScript", "com/intellij/javaee/oss/server/async/JavaeeAsyncInstanceBase", "isStartupScriptTerminatesAfterServerStartup"));
        }
        return this.getPureInstance().isStartupScriptTerminatesAfterServerStartup(startupScript);
    }

    public void updateChangedFiles(Set<String> changedFilesPaths) {
        this.getPureInstance().updateChangedFiles(changedFilesPaths);
    }

    public void registerAdditionalContent(RunnerLayoutUi layoutUi) {
        this.getPureInstance().registerAdditionalContent(layoutUi);
    }

    public void prepare() throws ExecutionException {
        this.getPureInstance().prepare();
    }

    @Override
    public JavaeeServerExtension getExtension() {
        return this.getPureInstance().getExtension();
    }

    @Override
    public void cleanDeployments(List<DeploymentModel> deploymentModels) {
        this.getPureInstance().cleanDeployments(deploymentModels);
    }
}

