/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.javaee.model.common.persistence.mapping.RelationAttributeBase;
import com.intellij.jpa.FetchAndCascadeTypeComponent;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.model.PersistentEmbeddable;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.RelationshipType;
import com.intellij.persistence.model.manipulators.PersistentObjectManipulator;
import com.intellij.persistence.util.JavaContainerType;
import com.intellij.psi.PsiNameHelper;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nullable;

public class RelationshipEditorDialog
extends DialogWrapper {
    private JPanel myRoot;
    private JPanel myFirstGroup;
    private JRadioButton myFirstOwnerRadioButton;
    private JTextField myFirstAttributeTextField;
    private JComboBox myFirstMultiplicityComboBox;
    private JCheckBox myFirstOptionalCheckBox;
    private FetchAndCascadeTypeComponent myFirstParams;
    private JPanel mySecondGroup;
    private JRadioButton mySecondOwnerRadioButton;
    private JTextField mySecondAttributeTextField;
    private JComboBox mySecondMultiplicityComboBox;
    private JCheckBox mySecondOptionalCheckBox;
    private FetchAndCascadeTypeComponent mySecondParams;
    private final Project myProject;
    private final PsiNameHelper myNameHelper;
    private RoleHolder myFirst;
    private RoleHolder mySecond;
    private PersistentObject myFirstEntity;
    private PersistentObject mySecondEntity;
    private PersistentRelationshipAttribute myFirstAttribute;
    private PersistentRelationshipAttribute mySecondAttribute;

    public RelationshipEditorDialog(Project project, PersistentRelationshipAttribute attribute) {
        super(project, false);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myNameHelper = PsiNameHelper.getInstance((Project)this.myProject);
        this.init();
        this.setResizable(false);
        this.setTitle(JpaMessages.message((String)"dialog.relation.title.edit", (Object[])new Object[0]));
        this.init(attribute);
    }

    @Nullable
    protected String getHelpId() {
        return "reference.dialogs.datasource.edit.relationship";
    }

    public boolean isOkToShow() {
        return this.myFirst.myManipulator != null && this.mySecond.myManipulator != null;
    }

    public RelationshipEditorDialog(Project project, PersistentObject sourceEntity, PersistentObject targetEntity) {
        super(project, false);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myNameHelper = PsiNameHelper.getInstance((Project)this.myProject);
        this.init();
        this.setResizable(false);
        this.setTitle(JpaMessages.message((String)"dialog.relation.title.create", (Object[])new Object[0]));
        this.init(sourceEntity, targetEntity);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myRoot;
    }

    protected ValidationInfo doValidate() {
        String text = this.getDialogErrorMessage();
        if (text != null) {
            return new ValidationInfo(text);
        }
        return super.doValidate();
    }

    protected void doOKAction() {
        super.doOKAction();
        this.commit();
    }

    @Nullable
    public String getDialogErrorMessage() {
        String firstName = this.myFirst.myAttributeTextField.getText();
        String secondName = this.mySecond.myAttributeTextField.getText();
        boolean firstEmpty = StringUtil.isEmpty((String)firstName);
        boolean secondEmpty = StringUtil.isEmpty((String)secondName);
        if (firstEmpty && secondEmpty) {
            return JpaMessages.message((String)"dialog.relation.message.no.attributes", (Object[])new Object[0]);
        }
        if (!firstEmpty) {
            if (!JpaUtil.isAttributeName(this.myNameHelper, firstName)) {
                return JpaMessages.message((String)"dialog.relation.message.invalid.name", (Object[])new Object[]{firstName});
            }
            if (this.myFirst.myAttribute == null && this.myFirst.myExistingNames.contains(firstName)) {
                return JpaMessages.message((String)"dialog.relation.message.attribute.exists", (Object[])new Object[]{firstName});
            }
        }
        if (!secondEmpty) {
            if (!JpaUtil.isAttributeName(this.myNameHelper, secondName)) {
                return JpaMessages.message((String)"dialog.relation.message.invalid.name", (Object[])new Object[]{secondName});
            }
            if (this.myFirst.myAttribute == null && this.mySecond.myExistingNames.contains(secondName)) {
                return JpaMessages.message((String)"dialog.relation.message.attribute.exists", (Object[])new Object[]{secondName});
            }
        }
        return null;
    }

    private void init(PersistentRelationshipAttribute attribute) {
        this.myFirstEntity = attribute.getPersistentObject();
        this.myFirstAttribute = attribute;
        this.mySecondAttribute = (PersistentRelationshipAttribute)PersistenceHelper.getHelper().getSharedModelBrowser().queryTheOtherSideAttributes(attribute, false).findFirst();
        this.mySecondEntity = (PersistentObject)PersistenceHelper.getHelper().getSharedModelBrowser().queryTargetPersistentObjects(attribute).findFirst();
        this.initHolders();
    }

    private void init(PersistentObject firstEntity, PersistentObject secondEntity) {
        this.myFirstEntity = firstEntity;
        this.myFirstAttribute = null;
        this.mySecondEntity = secondEntity;
        this.mySecondAttribute = null;
        this.initHolders();
    }

    private void initHolders() {
        this.myFirst = new RoleHolder(this.myFirstEntity, this.myFirstAttribute, this.myFirstGroup, this.myFirstAttributeTextField, this.myFirstMultiplicityComboBox, this.myFirstOwnerRadioButton, this.myFirstOptionalCheckBox, this.myFirstParams);
        this.mySecond = new RoleHolder(this.mySecondEntity, this.mySecondAttribute, this.mySecondGroup, this.mySecondAttributeTextField, this.mySecondMultiplicityComboBox, this.mySecondOwnerRadioButton, this.mySecondOptionalCheckBox, this.mySecondParams);
        this.myFirst.myEnabled = this.mySecondEntity instanceof PersistentEntityBase;
        this.mySecond.myEnabled = this.myFirstEntity instanceof PersistentEntityBase;
        if (!this.isOkToShow()) {
            return;
        }
        this.reset();
        this.initAttributeUI(this.myFirst);
        this.initAttributeUI(this.mySecond);
    }

    private void updateOwnerButton() {
        boolean noSecond;
        boolean noFirst = !this.myFirst.myEnabled || StringUtil.isEmpty((String)this.myFirst.myAttributeTextField.getText());
        boolean bl = noSecond = !this.mySecond.myEnabled || StringUtil.isEmpty((String)this.mySecond.myAttributeTextField.getText());
        if (this.myFirst.isTargetMany() != this.mySecond.isTargetMany()) {
            boolean firstOwning;
            boolean bl2 = firstOwning = !this.myFirst.isTargetMany();
            if (firstOwning) {
                this.myFirst.myOwnerRadioButton.setSelected(true);
                this.myFirst.myOwnerRadioButton.setEnabled(true);
                this.mySecond.myOwnerRadioButton.setEnabled(false);
            } else {
                this.myFirst.myOwnerRadioButton.setEnabled(false);
                this.mySecond.myOwnerRadioButton.setEnabled(true);
                this.mySecond.myOwnerRadioButton.setSelected(true);
            }
        } else {
            this.myFirst.myOwnerRadioButton.setEnabled(true);
            this.mySecond.myOwnerRadioButton.setEnabled(true);
        }
        if (noFirst) {
            this.myFirst.myOwnerRadioButton.setEnabled(false);
        }
        if (noSecond) {
            this.mySecond.myOwnerRadioButton.setEnabled(false);
        }
    }

    private void initAttributeUI(final RoleHolder roleHolder) {
        roleHolder.myAttributeTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                roleHolder.attributeNameChanged();
                roleHolder.updateOptionalButton();
                RelationshipEditorDialog.this.updateOwnerButton();
            }
        });
        roleHolder.myMultiplicityComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                roleHolder.updateOptionalButton();
                RelationshipEditorDialog.this.updateOwnerButton();
            }
        });
    }

    public void commit() {
        ArrayList psiElements = new ArrayList();
        if (StringUtil.isNotEmpty((String)this.myFirst.myAttributeTextField.getText())) {
            this.myFirst.myManipulator.addAffectedElements(psiElements);
        }
        if (StringUtil.isNotEmpty((String)this.mySecond.myAttributeTextField.getText())) {
            this.mySecond.myManipulator.addAffectedElements(psiElements);
        }
        Ref indicatorRef = Ref.create(null);
        PersistenceHelper.getHelper().runCompositeWriteCommandAction(this.myProject, JpaMessages.message((String)"command.name.create.relationship", (Object[])new Object[0]), psiElements, indicatorRef, new Runnable[]{() -> {
            try {
                boolean createOnlyOne = this.myFirst.isSameAttribute(this.mySecond);
                this.createAttribute((PersistentObjectManipulator<PersistentObject>)this.myFirst.myManipulator, this.myFirst, this.mySecond);
                if (!createOnlyOne) {
                    this.createAttribute((PersistentObjectManipulator<PersistentObject>)this.mySecond.myManipulator, this.mySecond, this.myFirst);
                }
            }
            catch (IncorrectOperationException e) {
                throw new RuntimeException(e);
            }
        }});
    }

    private void createAttribute(PersistentObjectManipulator<PersistentObject> manipulator, RoleHolder source, RoleHolder target) throws IncorrectOperationException {
        RelationshipType relationshipType = RelationshipType.getRelationshipType((boolean)source.isTargetMany(), (boolean)target.isTargetMany());
        boolean sameAttr = source.isSameAttribute(target);
        String attributeName = source.myAttributeTextField.getText();
        String targetAttribute = target.myAttributeTextField.getText();
        if (StringUtil.isEmpty((String)attributeName)) {
            return;
        }
        boolean targetOptional = source.myOptionalCheckBox.isSelected() || sameAttr && target.myOptionalCheckBox.isSelected();
        boolean sourceOwner = source.myOwnerRadioButton.isSelected();
        manipulator.addRelationshipAttribute((PersistentEntityBase)target.myEntity, relationshipType, JavaContainerType.COLLECTION, attributeName, targetAttribute, !sourceOwner, targetOptional, source.myParams.getFetchType(), source.myParams.getCascadeTypes(), source.myEntity.getObjectModelHelper().getDefaultAccessMode());
    }

    public static void createEmbeddableAttribute(PersistentObject entity, String attributeName, PersistentEmbeddable embeddable) {
        PersistentObjectManipulator manipulator = (PersistentObjectManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)entity, PersistentObjectManipulator.class);
        if (manipulator == null) {
            return;
        }
        ArrayList affectedElements = new ArrayList();
        manipulator.addAffectedElements(affectedElements);
        Project project = entity.getPsiManager().getProject();
        Ref indicatorRef = Ref.create(null);
        PersistenceHelper.getHelper().runCompositeWriteCommandAction(project, JpaMessages.message((String)"command.name.create.embedded", (Object[])new Object[0]), affectedElements, indicatorRef, new Runnable[]{() -> {
            try {
                manipulator.addEmbeddedAttribute(embeddable, attributeName, entity.getObjectModelHelper().getDefaultAccessMode());
            }
            catch (IncorrectOperationException e) {
                throw new RuntimeException(e);
            }
        }});
    }

    public void reset() {
        this.myFirst.resetUI(false);
        this.mySecond.resetUI(this.myFirst.myAttribute != null && this.myFirst.myAttribute.getAttributeModelHelper().getRelationshipType().isMany(false));
        this.myFirst.updateOptionalButton();
        this.mySecond.updateOptionalButton();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        FetchAndCascadeTypeComponent fetchAndCascadeTypeComponent;
        JCheckBox jCheckBox;
        JRadioButton jRadioButton;
        JComboBox jComboBox;
        JTextField jTextField;
        JPanel jPanel;
        FetchAndCascadeTypeComponent fetchAndCascadeTypeComponent2;
        JCheckBox jCheckBox2;
        JRadioButton jRadioButton2;
        JComboBox jComboBox2;
        JTextField jTextField2;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myRoot = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new FormLayout("fill:d:grow,left:4dlu:noGrow,fill:max(d;4px):grow", "center:max(d;4px):noGrow"));
        this.myFirstGroup = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new FormLayout("fill:d:noGrow,left:8dlu:noGrow,fill:d:grow", "center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,fill:max(d;4px):grow"));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel2, new CellConstraints(1, 1, 1, 1, CellConstraints.FILL, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/JpaBundle").getString("dialog.relation.entity.label"), (int)0, (int)0, null, null));
        this.myFirstAttributeTextField = jTextField2 = new JTextField();
        jTextField2.setText("");
        jTextField2.setColumns(15);
        jPanel2.add((Component)jTextField2, new CellConstraints(3, 1, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 5)));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/JpaBundle").getString("dialog.relation.attribute.label"));
        jPanel2.add((Component)jLabel, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 5, 0, 0)));
        this.myFirstMultiplicityComboBox = jComboBox2 = new JComboBox();
        jPanel2.add(jComboBox2, new CellConstraints(3, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 5)));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/JpaBundle").getString("dialog.relation.multiplicity.label"));
        jPanel2.add((Component)jLabel2, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 5, 0, 0)));
        this.myFirstOwnerRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setHorizontalTextPosition(4);
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/JpaBundle").getString("dialog.relation.owner.label"));
        jRadioButton2.setSelected(true);
        jRadioButton2.setHorizontalAlignment(4);
        jPanel2.add((Component)jRadioButton2, new CellConstraints(3, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 5)));
        this.myFirstOptionalCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/JpaBundle").getString("dialog.relation.optional.label"));
        jPanel2.add((Component)jCheckBox2, new CellConstraints(1, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myFirstParams = fetchAndCascadeTypeComponent2 = new FetchAndCascadeTypeComponent();
        JComponent jComponent = fetchAndCascadeTypeComponent2.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new CellConstraints(1, 7, 3, 1, CellConstraints.FILL, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        this.mySecondGroup = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new FormLayout("fill:max(d;4px):noGrow,left:4dlu:noGrow,fill:d:grow", "center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):grow"));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel, new CellConstraints(3, 1, 1, 1, CellConstraints.FILL, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/JpaBundle").getString("dialog.relation.entity.label"), (int)0, (int)0, null, null));
        this.mySecondAttributeTextField = jTextField = new JTextField();
        jTextField.setText("");
        jTextField.setColumns(15);
        jPanel.add((Component)jTextField, new CellConstraints(3, 1, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 5)));
        this.mySecondMultiplicityComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new CellConstraints(3, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 5)));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/JpaBundle").getString("dialog.relation.attribute.label"));
        jPanel.add((Component)jLabel3, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 5, 0, 0)));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/JpaBundle").getString("dialog.relation.multiplicity.label"));
        jPanel.add((Component)jLabel4, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 5, 0, 0)));
        this.mySecondOwnerRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/JpaBundle").getString("dialog.relation.owner.label"));
        jRadioButton.setHorizontalAlignment(4);
        jPanel.add((Component)jRadioButton, new CellConstraints(3, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 5)));
        this.mySecondOptionalCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/JpaBundle").getString("dialog.relation.optional.label"));
        jPanel.add((Component)jCheckBox, new CellConstraints(1, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.mySecondParams = fetchAndCascadeTypeComponent = new FetchAndCascadeTypeComponent();
        JComponent jComponent2 = fetchAndCascadeTypeComponent.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent2, new CellConstraints(1, 7, 3, 1, CellConstraints.FILL, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        jLabel.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jComboBox2);
        jLabel3.setLabelFor(jTextField);
        jLabel4.setLabelFor(jComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class RoleHolder {
        private final PersistentObject myEntity;
        private final PersistentObjectManipulator<PersistentObject> myManipulator;
        private final PersistentRelationshipAttribute myAttribute;
        private final JPanel myGroup;
        private final JTextField myAttributeTextField;
        private final JComboBox myMultiplicityComboBox;
        private final JRadioButton myOwnerRadioButton;
        private final JCheckBox myOptionalCheckBox;
        private final FetchAndCascadeTypeComponent myParams;
        private final Set<String> myExistingNames;
        private boolean myEnabled;

        public RoleHolder(PersistentObject entity, PersistentRelationshipAttribute attribute, JPanel group, JTextField attributeTextField, JComboBox multiplicityComboBox, JRadioButton ownerRadioButton, JCheckBox optionalCheckBox, FetchAndCascadeTypeComponent params) {
            this.myEntity = entity;
            this.myAttribute = attribute;
            this.myGroup = group;
            this.myAttributeTextField = attributeTextField;
            this.myMultiplicityComboBox = multiplicityComboBox;
            this.myOwnerRadioButton = ownerRadioButton;
            this.myOptionalCheckBox = optionalCheckBox;
            this.myParams = params;
            this.myManipulator = (PersistentObjectManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)this.myEntity, PersistentObjectManipulator.class);
            this.myExistingNames = this.myEntity == null ? Collections.emptySet() : ContainerUtil.map2Set((Collection)PersistenceHelper.getHelper().getSharedModelBrowser().queryAttributes(this.myEntity).findAll(), (Function)((NullableFunction)attributeBase -> {
                if (attributeBase == this.myAttribute) {
                    return null;
                }
                return (String)attributeBase.getName().getValue();
            }));
        }

        String getOriginalEntityName() {
            return this.myEntity == null ? "Unknown" : StringUtil.notNullize((String)this.myEntity.getClazz().getStringValue(), (String)"Unknown");
        }

        String getOriginalAttributeName() {
            return this.myAttribute == null ? "" : StringUtil.notNullize((String)((String)this.myAttribute.getName().getValue()), (String)"");
        }

        boolean isOwner() {
            return this.myOwnerRadioButton.isSelected();
        }

        boolean isTargetMany() {
            return this.myMultiplicityComboBox.getSelectedIndex() != 0;
        }

        public void resetUI(boolean defaultMany) {
            ((TitledBorder)this.myGroup.getBorder()).setTitle(JpaMessages.message((String)"dialog.relation.entity.label", (Object[])new Object[]{PsiNameHelper.getShortClassName((String)this.getOriginalEntityName())}));
            this.myAttributeTextField.setText(this.getOriginalAttributeName());
            this.myMultiplicityComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{JpaMessages.message((String)"dialog.relation.multiplicity.one", (Object[])new Object[0]), JpaMessages.message((String)"dialog.relation.multiplicity.many", (Object[])new Object[0])}));
            boolean isCreate = this.myAttribute == null;
            boolean many = isCreate ? defaultMany : this.myAttribute.getAttributeModelHelper().getRelationshipType().isMany(false);
            this.myMultiplicityComboBox.setSelectedIndex(many ? 1 : 0);
            TreeSet<String> cascades = new TreeSet<String>();
            TreeSet<String> fetches = new TreeSet<String>();
            this.myManipulator.addCascadeVariants(cascades);
            this.myManipulator.addFetchVariants(fetches);
            this.myParams.initFetchTypes(fetches, isCreate ? null : this.myAttribute.getAttributeModelHelper().getFetchType());
            this.myParams.initCascadeTypes(cascades, isCreate ? Collections.emptyList() : this.myAttribute.getAttributeModelHelper().getCascadeTypes());
            if (!isCreate) {
                if (!this.myAttribute.getAttributeModelHelper().isInverseSide()) {
                    this.myOwnerRadioButton.setSelected(true);
                }
                if (this.myAttribute instanceof RelationAttributeBase.AnyToOneBase) {
                    this.myOptionalCheckBox.setSelected(Boolean.TRUE.equals(((RelationAttributeBase.AnyToOneBase)this.myAttribute).getOptional().getValue()));
                }
            }
            if (this.myEnabled) {
                this.myAttributeTextField.setEnabled(isCreate);
                this.myMultiplicityComboBox.setEnabled(isCreate);
                this.myMultiplicityComboBox.setEnabled(isCreate);
                if (isCreate) {
                    this.myOwnerRadioButton.setEnabled(isCreate);
                }
            } else {
                UIUtil.setEnabled((Component)this.myGroup, (boolean)false, (boolean)true);
            }
            this.attributeNameChanged();
        }

        private void enableAttributeOptions(boolean flag) {
            GuiUtils.enableChildren((Component)this.myParams.getComponent(), (boolean)flag, (JComponent[])new JComponent[0]);
        }

        void updateOptionalButton() {
            boolean enabled = this.myEnabled && !this.isTargetMany();
            this.myOptionalCheckBox.setEnabled(enabled);
            if (!enabled) {
                this.myOptionalCheckBox.setSelected(false);
            }
        }

        public void attributeNameChanged() {
            this.enableAttributeOptions(StringUtil.isNotEmpty((String)this.myAttributeTextField.getText()));
        }

        public boolean isSameAttribute(RoleHolder roleHolder) {
            return Comparing.equal((Object)this.myEntity, (Object)roleHolder.myEntity) && Comparing.equal((String)this.myAttributeTextField.getText(), (String)roleHolder.myAttributeTextField.getText());
        }
    }
}

