/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.ClientVersion;
import org.jetbrains.idea.perforce.ServerVersion;
import org.jetbrains.idea.perforce.application.ClientRootsCache;
import org.jetbrains.idea.perforce.application.PerforceBaseInfoWorker;
import org.jetbrains.idea.perforce.application.PerforceClient;
import org.jetbrains.idea.perforce.application.PerforceClientImpl;
import org.jetbrains.idea.perforce.application.PerforceClientRootsChecker;
import org.jetbrains.idea.perforce.application.PerforceShelf;
import org.jetbrains.idea.perforce.application.TracerProperties;
import org.jetbrains.idea.perforce.perforce.OutputMessageParser;
import org.jetbrains.idea.perforce.perforce.P4Command;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.View;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;
import org.jetbrains.idea.perforce.util.tracer.LongCallsParameters;
import org.jetbrains.idea.perforce.util.tracer.TracerManager;
import org.jetbrains.idea.perforce.util.tracer.TracerParameters;

public class PerforceManager {
    private final Project myProject;
    private final PerforceLoginManager myLoginManager;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.application.PerforceManager");
    private static final Logger LOG_RELATIVE_PATH = Logger.getInstance((String)"#Log_relative_path");
    private static final Logger TRACER_LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.application.PerforceManager_TRACER");
    private final Map<P4Connection, PerforceClient> myClientMap = new HashMap<P4Connection, PerforceClient>();
    private static final boolean ourTraceCalls = Boolean.TRUE.equals(Boolean.getBoolean("perforce.trace.calls"));
    private static final String ourTracerProperties = System.getProperty("perforce.trace.calls.properties");
    private TracerManager<P4Command> myTracer;
    private final ClientRootsCache myClientRootsCache;
    private final PerforceBaseInfoWorker myPerforceBaseInfoWorker;
    private final VirtualFileListener myListener;
    private volatile ClientVersion myClientVersion;
    private volatile boolean myActive;
    private final LocalFileSystem myLfs;
    private final PerforceShelf myShelf;

    public static PerforceManager getInstance(Project project) {
        return (PerforceManager)PeriodicalTasksCloser.getInstance().safeGetService(project, PerforceManager.class);
    }

    public PerforceManager(Project project, PerforceBaseInfoWorker perforceBaseInfoWorker, ClientRootsCache clientRootsCache, PerforceLoginManager loginManager) {
        this.myProject = project;
        this.myLoginManager = loginManager;
        this.myListener = new VirtualFileListener(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                boolean wasWritable;
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/perforce/application/PerforceManager$1", "propertyChanged"));
                }
                if (!event.isFromRefresh()) {
                    return;
                }
                if (event.getPropertyName().equals("writable") && (wasWritable = ((Boolean)event.getOldValue()).booleanValue())) {
                    event.getFile().putUserData(P4File.KEY, null);
                }
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/perforce/application/PerforceManager$1", "contentsChanged"));
                }
                if (!event.isFromRefresh()) {
                    return;
                }
                if (!event.getFile().isWritable()) {
                    event.getFile().putUserData(P4File.KEY, null);
                }
            }
        };
        this.myClientRootsCache = clientRootsCache;
        this.myPerforceBaseInfoWorker = perforceBaseInfoWorker;
        if (ourTraceCalls) {
            this.myTracer = PerforceManager.createTracer();
        }
        this.myLfs = LocalFileSystem.getInstance();
        this.myShelf = new PerforceShelf(project);
    }

    private static TracerManager<P4Command> createTracer() {
        if (ourTracerProperties != null) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(ourTracerProperties));
                boolean logAverageTimes = Boolean.TRUE.equals(Boolean.parseBoolean(properties.getProperty("perforce.tracer.average.gather")));
                TracerParameters averageParameters = logAverageTimes ? new TracerParameters(TracerProperties.averageTimesInterval.getValue(properties), (int)TracerProperties.averageTimesQueueSize.getValue(properties)) : null;
                boolean logConcurrentThreads = Boolean.TRUE.equals(Boolean.parseBoolean(properties.getProperty("perforce.tracer.number.concurrent.threads.gather")));
                TracerParameters concurrentThreadsParameters = logConcurrentThreads ? new TracerParameters(TracerProperties.numberConcurrentThreadsInterval.getValue(properties), (int)TracerProperties.numberConcurrentThreadsQueueSize.getValue(properties)) : null;
                boolean logLongCalls = Boolean.TRUE.equals(Boolean.parseBoolean(properties.getProperty("perforce.tracer.long.calls.gather")));
                LongCallsParameters longCallsParameters = logLongCalls ? new LongCallsParameters(TracerProperties.longCallsInterval.getValue(properties), (int)TracerProperties.longCallsQueueSize.getValue(properties), (int)TracerProperties.longCallsMaxKept.getValue(properties), TracerProperties.longCallsLowerBound.getValue(properties)) : null;
                return new TracerManager<P4Command>(averageParameters, concurrentThreadsParameters, longCallsParameters, TRACER_LOG, TracerProperties.outputInterval.getValue(properties));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new TracerManager<P4Command>(new TracerParameters(TracerProperties.averageTimesInterval.getDefault(), (int)TracerProperties.averageTimesQueueSize.getDefault()), new TracerParameters(TracerProperties.numberConcurrentThreadsInterval.getDefault(), (int)TracerProperties.numberConcurrentThreadsQueueSize.getDefault()), new LongCallsParameters(TracerProperties.longCallsInterval.getDefault(), (int)TracerProperties.longCallsQueueSize.getDefault(), (int)TracerProperties.longCallsMaxKept.getDefault(), TracerProperties.longCallsLowerBound.getDefault()), TRACER_LOG, TracerProperties.outputInterval.getDefault());
    }

    @Nullable
    public ClientVersion getClientVersion() {
        ClientVersion version = this.myClientVersion;
        if (version == null) {
            this.myClientVersion = version = PerforceRunner.getInstance(this.myProject).getClientVersion();
        }
        return version;
    }

    public void startListening() {
        this.myActive = true;
        VirtualFileManager.getInstance().addVirtualFileListener(this.myListener);
        this.myLoginManager.startListening();
        this.myPerforceBaseInfoWorker.start();
    }

    public void stopListening() {
        this.myActive = false;
        VirtualFileManager.getInstance().removeVirtualFileListener(this.myListener);
        this.myLoginManager.stopListening();
        this.myPerforceBaseInfoWorker.stop();
    }

    @NotNull
    protected Map<String, List<String>> getCachedInfo(P4Connection connection) throws VcsException {
        Map<String, List<String>> info = this.myPerforceBaseInfoWorker.getInfo(connection);
        if (info == null) {
            ProgressManager.checkCanceled();
            throw new VcsException("Info is not available");
        }
        Map<String, List<String>> map = info;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceManager", "getCachedInfo"));
        }
        return map;
    }

    @NotNull
    protected Map<String, List<String>> getCachedClients(@Nullable P4Connection connection) throws VcsException {
        Map<String, List<String>> client = this.myPerforceBaseInfoWorker.getClient(connection);
        if (client == null) {
            ProgressManager.checkCanceled();
            throw new VcsException("Info is not available");
        }
        Map<String, List<String>> map = client;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceManager", "getCachedClients"));
        }
        return map;
    }

    @Nullable
    protected Map<String, List<String>> getInfoOnlyCached(P4Connection connection) throws VcsException {
        return this.myPerforceBaseInfoWorker.getCachedInfo(connection);
    }

    @Nullable
    protected Map<String, List<String>> getClientOnlyCached(P4Connection connection) throws VcsException {
        return this.myPerforceBaseInfoWorker.getCachedClient(connection);
    }

    @Nullable
    public String getClientRoot(@Nullable P4Connection connection) throws VcsException {
        VirtualFile vf;
        File file;
        Map<String, List<String>> clientSpec = this.getCachedClients(connection);
        List<String> mainRootValues = clientSpec.get("Root:");
        List<String> altRootValues = clientSpec.get("AltRoots:");
        if (mainRootValues != null) {
            for (String mainRootValue : mainRootValues) {
                file = new File(mainRootValue);
                vf = this.myLfs.findFileByIoFile(file);
                if ((vf == null || !vf.isDirectory()) && !PerforceClientRootsChecker.isDirectory(file)) continue;
                return mainRootValue;
            }
        }
        if (altRootValues != null) {
            for (String altRootValue : altRootValues) {
                file = new File(altRootValue);
                vf = this.myLfs.findFileByIoFile(file);
                if ((vf == null || !vf.isDirectory()) && !PerforceClientRootsChecker.isDirectory(file)) continue;
                return altRootValue;
            }
        }
        return null;
    }

    public long getServerVersionYear(@Nullable P4Connection connection) throws VcsException {
        Map<String, List<String>> map = this.getCachedInfo(connection);
        List<String> serverVersions = map.get("Server version:");
        if (serverVersions == null || serverVersions.isEmpty()) {
            return -1L;
        }
        return OutputMessageParser.parseServerVersion((String)serverVersions.get(0)).getVersionYear();
    }

    public long getServerVersionYearCached(@Nullable P4Connection connection) throws VcsException {
        Map<String, List<String>> map = this.getInfoOnlyCached(connection);
        if (map == null) {
            return -1L;
        }
        List<String> serverVersions = map.get("Server version:");
        if (serverVersions == null || serverVersions.isEmpty()) {
            return -1L;
        }
        return OutputMessageParser.parseServerVersion((String)serverVersions.get(0)).getVersionYear();
    }

    @Nullable
    public ServerVersion getServerVersion(@Nullable P4Connection connection) throws VcsException {
        List<String> serverVersions = this.getCachedInfo(connection).get("Server version:");
        if (serverVersions == null || serverVersions.isEmpty()) {
            return null;
        }
        return OutputMessageParser.parseServerVersion((String)serverVersions.get(0));
    }

    public boolean isUnderPerforceRoot(@NotNull VirtualFile virtualFile) throws VcsException {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/idea/perforce/application/PerforceManager", "isUnderPerforceRoot"));
        }
        P4Connection connection = PerforceSettings.getSettings(this.myProject).getConnectionForFile(virtualFile);
        String path = this.getClientRoot(connection);
        if (path != null) {
            return this.isUnderClientRoot(virtualFile, path);
        }
        return false;
    }

    private boolean isUnderClientRoot(VirtualFile virtualFile, String path) {
        Application application = ApplicationManager.getApplication();
        return (Boolean)application.runReadAction(() -> {
            VirtualFile root = this.myLfs.findFileByIoFile(new File(path));
            if (root != null && (Comparing.equal((Object)root, (Object)virtualFile) || VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)virtualFile, (boolean)false))) {
                return true;
            }
            return false;
        });
    }

    @Nullable
    private static String getRelativePath(String filePath, PerforceClient client) throws VcsException {
        return View.getRelativePath((String)P4File.unescapeWildcards(filePath), (String)client.getName(), client.getViews());
    }

    @Nullable
    public static File getFileByDepotName(String depotPath, PerforceClient client) throws VcsException {
        int revNumStart = depotPath.indexOf("#");
        String clientRoot = client.getRoot();
        String relativePath = revNumStart >= 0 ? PerforceManager.getRelativePath(depotPath.substring(0, revNumStart), client) : PerforceManager.getRelativePath(depotPath, client);
        if (relativePath == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(PerforceManager.missingLocalFileDiagnostics(depotPath, client));
            }
            return null;
        }
        File result = clientRoot != null && clientRoot.length() > 0 ? new File(clientRoot, relativePath.trim()) : new File(FileUtil.toSystemDependentName((String)relativePath.trim()));
        Project project = client.getProject();
        boolean inProject = project == null || PerforceConnectionManager.getInstance(project).isUnderProjectConnections(result);
        LOG_RELATIVE_PATH.debug("depot: '" + depotPath + "' result: '" + result + "', inProject:" + inProject);
        return inProject ? result : null;
    }

    private static String missingLocalFileDiagnostics(String depotPath, PerforceClient client) throws VcsException {
        StringBuilder message = new StringBuilder();
        for (View view : client.getViews()) {
            message.append('\n');
            message.append("View ");
            message.append(view.toString());
        }
        message.append('\n');
        message.append("Cannot find local file for depot path: ").append(depotPath);
        return message.toString();
    }

    @NotNull
    public synchronized PerforceClient getClient(@NotNull P4Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/idea/perforce/application/PerforceManager", "getClient"));
        }
        PerforceClient client = this.myClientMap.get(connection);
        if (client == null) {
            client = new PerforceClientImpl(this.myProject, connection);
            this.myClientMap.put(connection, client);
        }
        PerforceClient perforceClient = client;
        if (perforceClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceManager", "getClient"));
        }
        return perforceClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationChanged() {
        PerforceManager perforceManager = this;
        synchronized (perforceManager) {
            this.myClientMap.clear();
        }
        if (!this.myActive) {
            return;
        }
        this.myLoginManager.clearAll();
        this.clearInfoClientCache();
        ApplicationManager.getApplication().invokeLater(() -> {
            P4File.invalidateFstat(this.myProject);
            VcsDirtyScopeManager.getInstance((Project)this.myProject).markEverythingDirty();
        }, this.myProject.getDisposed());
    }

    public void clearInfoClientCache() {
        this.myPerforceBaseInfoWorker.scheduleRefresh();
    }

    @Nullable
    public String getRawRoot(@Nullable String convertedRoot) {
        return this.myClientRootsCache.getRaw(convertedRoot);
    }

    public String convertP4ParsedPath(@Nullable String convertedClientRoot, @NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/idea/perforce/application/PerforceManager", "convertP4ParsedPath"));
        }
        String result = this.myClientRootsCache.convertPath(convertedClientRoot, s);
        LOG_RELATIVE_PATH.debug("convertion, s: '" + s + "' converted: '" + result + "' convertedRoot: '" + convertedClientRoot + "'");
        return result;
    }

    @Nullable
    public Object traceEnter(P4Command command, String commandPresentation) {
        if (this.myTracer != null) {
            return this.myTracer.start(command, commandPresentation);
        }
        return null;
    }

    public void traceExit(Object context, P4Command command, String commandPresentation) {
        if (this.myTracer != null) {
            this.myTracer.stop(context, command, commandPresentation);
        }
    }

    public boolean isTraceEnabled() {
        return ourTraceCalls;
    }

    public void resetClientVersion() {
        this.myClientVersion = null;
    }

    public boolean isActive() {
        return this.myActive;
    }

    public static void ensureValidClient(@NotNull Project project, @NotNull P4Connection connection) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/perforce/application/PerforceManager", "ensureValidClient"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/idea/perforce/application/PerforceManager", "ensureValidClient"));
        }
        PerforceClient client = PerforceManager.getInstance(project).getClient(connection);
        if (client.getName() == null) {
            throw new VcsException("Missing Perforce workspace");
        }
        if (client.getUserName() == null) {
            throw new VcsException("Missing Perforce user name");
        }
        if (client.getServerPort() == null) {
            throw new VcsException("Missing Perforce server/port");
        }
    }

    public PerforceShelf getShelf() {
        return this.myShelf;
    }
}

