/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.connections.P4ConfigHelper;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionParameters;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.connections.PerforceMultipleConnections;

public class PerforceP4ConfigVirtualFileListener
implements VirtualFileListener {
    private final PerforceConnectionManagerI myConnectionManager;
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.perforce.connections.PerforceP4ConfigVirtualFileListener");

    public PerforceP4ConfigVirtualFileListener(PerforceConnectionManagerI connectionManager, Project project) {
        this.myConnectionManager = connectionManager;
        this.myProject = project;
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/perforce/perforce/connections/PerforceP4ConfigVirtualFileListener", "propertyChanged"));
        }
        this.processFileEvent((VirtualFileEvent)event);
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/perforce/perforce/connections/PerforceP4ConfigVirtualFileListener", "contentsChanged"));
        }
        this.processFileEvent(event);
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/perforce/perforce/connections/PerforceP4ConfigVirtualFileListener", "fileCreated"));
        }
        this.processFileEvent(event);
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/perforce/perforce/connections/PerforceP4ConfigVirtualFileListener", "fileDeleted"));
        }
        this.processFileEvent(event);
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/perforce/perforce/connections/PerforceP4ConfigVirtualFileListener", "fileMoved"));
        }
        this.processFileEvent((VirtualFileEvent)event);
    }

    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/perforce/perforce/connections/PerforceP4ConfigVirtualFileListener", "beforePropertyChange"));
        }
        this.processFileEvent((VirtualFileEvent)event);
    }

    public void beforeContentsChange(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/perforce/perforce/connections/PerforceP4ConfigVirtualFileListener", "beforeContentsChange"));
        }
        this.processFileEvent(event);
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/perforce/perforce/connections/PerforceP4ConfigVirtualFileListener", "beforeFileDeletion"));
        }
        this.processFileEvent(event);
    }

    public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/perforce/perforce/connections/PerforceP4ConfigVirtualFileListener", "beforeFileMovement"));
        }
        this.processFileEvent((VirtualFileEvent)event);
    }

    private boolean isConfigFileName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/idea/perforce/perforce/connections/PerforceP4ConfigVirtualFileListener", "isConfigFileName"));
        }
        PerforceMultipleConnections multipleConnections = this.myConnectionManager.getMultipleConnectionObject();
        if (multipleConnections != null) {
            for (P4ConnectionParameters parameters : multipleConnections.getParametersMap().values()) {
                if (!Comparing.equal((String)parameters.getConfigFileName(), (String)fileName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isIgnoredFileName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/idea/perforce/perforce/connections/PerforceP4ConfigVirtualFileListener", "isIgnoredFileName"));
        }
        if (fileName.equals(P4ConfigHelper.getP4IgnoreFileName())) {
            return true;
        }
        PerforceMultipleConnections multipleConnections = this.myConnectionManager.getMultipleConnectionObject();
        if (multipleConnections != null) {
            for (P4ConnectionParameters parameters : multipleConnections.getParametersMap().values()) {
                if (!Comparing.equal((String)parameters.getIgnoreFileName(), (String)fileName)) continue;
                return true;
            }
        }
        return false;
    }

    private void processFileEvent(VirtualFileEvent event) {
        String fileName = event.getFileName();
        if (this.isIgnoredFileName(fileName)) {
            LOG.debug("received virtual file event on p4ignore file");
            PerforceVcs.getInstance(this.myProject).getOnlineChangeProvider().discardCache();
        }
        if (this.isConfigFileName(fileName)) {
            LOG.debug("received virtual file event on p4config file");
            this.myConnectionManager.updateConnections();
        }
    }
}

