/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.tfs.RootsCollection;

public class CheckoutAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/tfsIntegration/actions/CheckoutAction", "actionPerformed"));
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        RootsCollection.VirtualFileRootsCollection roots = new RootsCollection.VirtualFileRootsCollection(VcsUtil.getVirtualFiles((AnActionEvent)e));
        Ref error = Ref.create();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                TFSVcs.getInstance(project).getEditFileProvider().editFiles(VfsUtilCore.toVirtualFileArray((Collection)((Object)roots)));
            }
            catch (VcsException ex) {
                error.set((Object)ex);
            }
        }, "Checking out files for edit...", false, project);
        if (!error.isNull()) {
            AbstractVcsHelper.getInstance((Project)project).showErrors(Collections.singletonList(error.get()), "TFS");
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/tfsIntegration/actions/CheckoutAction", "update"));
        }
        Project project = e.getProject();
        VirtualFile[] files = VcsUtil.getVirtualFiles((AnActionEvent)e);
        e.getPresentation().setEnabled(project != null && files.length != 0 && CheckoutAction.areNotChangedOrHijacked(project, files));
    }

    private static boolean areNotChangedOrHijacked(@NotNull Project project, @NotNull VirtualFile[] files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/tfsIntegration/actions/CheckoutAction", "areNotChangedOrHijacked"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/tfsIntegration/actions/CheckoutAction", "areNotChangedOrHijacked"));
        }
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project);
        return Stream.of(files).map(arg_0 -> ((FileStatusManager)fileStatusManager).getStatus(arg_0)).allMatch(status -> status == FileStatus.NOT_CHANGED || status == FileStatus.HIJACKED);
    }
}

