/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.VcsCheckinHandlerFactory;
import com.intellij.util.PairConsumer;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.text.MessageFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.checkin.CheckinParameters;
import org.jetbrains.tfsIntegration.checkin.CheckinPoliciesManager;
import org.jetbrains.tfsIntegration.checkin.DuplicatePolicyIdException;
import org.jetbrains.tfsIntegration.core.TFSCheckinEnvironment;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.ui.OverridePolicyWarningsDialog;

public class TFSCheckinHandlerFactory
extends VcsCheckinHandlerFactory {
    public TFSCheckinHandlerFactory() {
        super(TFSVcs.getKey());
    }

    @NotNull
    protected CheckinHandler createVcsHandler(final CheckinProjectPanel panel) {
        CheckinHandler checkinHandler = new CheckinHandler(){

            public CheckinHandler.ReturnResult beforeCheckin(@Nullable CommitExecutor executor, PairConsumer<Object, Object> additionalDataConsumer) {
                if (executor != null) {
                    return CheckinHandler.ReturnResult.COMMIT;
                }
                if (!panel.vcsIsAffected("TFS")) {
                    return CheckinHandler.ReturnResult.COMMIT;
                }
                boolean reallyAffected = false;
                for (File file : panel.getFiles()) {
                    if (!TFSVcs.isUnderTFS(VcsUtil.getFilePath((File)file), panel.getProject())) continue;
                    reallyAffected = true;
                    break;
                }
                if (!reallyAffected) {
                    return CheckinHandler.ReturnResult.COMMIT;
                }
                TFSVcs vcs = TFSVcs.getInstance(panel.getProject());
                CheckinParameters parameters = vcs.getCheckinData().parameters;
                if (parameters == null) {
                    Messages.showErrorDialog((Project)panel.getProject(), (String)"Validation must be performed before checking in", (String)"Checkin");
                    return CheckinHandler.ReturnResult.CLOSE_WINDOW;
                }
                Pair<String, CheckinParameters.Severity> msg = parameters.getValidationMessage(CheckinParameters.Severity.ERROR);
                if (msg != null) {
                    Messages.showErrorDialog((Project)panel.getProject(), (String)((String)msg.first), (String)"Checkin: Validation Failed");
                    return CheckinHandler.ReturnResult.CANCEL;
                }
                try {
                    CheckinPoliciesManager.getInstalledPolicies();
                }
                catch (DuplicatePolicyIdException e) {
                    String message = MessageFormat.format("Found multiple checkin policies with the same id: ''{0}''.\nPlease review your extensions.", e.getDuplicateId());
                    Messages.showErrorDialog((Project)panel.getProject(), (String)message, (String)"Checkin Policies Evaluation");
                    vcs.getCheckinData().parameters = null;
                    return CheckinHandler.ReturnResult.CLOSE_WINDOW;
                }
                boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                    ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
                    pi.setIndeterminate(true);
                    parameters.evaluatePolicies(pi);
                }, "Evaluating Checkin Policies", true, panel.getProject());
                if (!completed) {
                    TFSCheckinEnvironment.updateMessage(vcs.getCheckinData());
                    return CheckinHandler.ReturnResult.CANCEL;
                }
                msg = parameters.getValidationMessage(CheckinParameters.Severity.WARNING);
                if (msg == null) {
                    return CheckinHandler.ReturnResult.COMMIT;
                }
                OverridePolicyWarningsDialog d = new OverridePolicyWarningsDialog(panel.getProject(), parameters.getAllFailures());
                if (d.showAndGet()) {
                    parameters.setOverrideReason(d.getReason());
                    return CheckinHandler.ReturnResult.COMMIT;
                }
                return CheckinHandler.ReturnResult.CANCEL;
            }
        };
        if (checkinHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/TFSCheckinHandlerFactory", "createVcsHandler"));
        }
        return checkinHandler;
    }
}

