/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.revision;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.revision.TFSContentStore;
import org.jetbrains.tfsIntegration.core.tfs.TfsFileUtil;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public class TFSTmpFileStore
implements TFSContentStore {
    @NonNls
    private static final String TMP_FILE_NAME = "idea_tfs";
    private static String myTfsTmpDir;
    private final File myTmpFile;

    @Nullable
    public static TFSContentStore find(String serverUri, int itemId, int revision) throws IOException {
        File tmpFile = new File(TFSTmpFileStore.createTmpFileName(serverUri, itemId, revision));
        if (tmpFile.exists()) {
            return new TFSTmpFileStore(tmpFile);
        }
        return null;
    }

    TFSTmpFileStore(String serverUri, int itemId, int revision) throws IOException {
        this.myTmpFile = new File(TFSTmpFileStore.createTmpFileName(serverUri, itemId, revision));
        this.myTmpFile.deleteOnExit();
    }

    private static String createTmpFileName(String serverUri, int itemId, int revision) throws IOException {
        return TFSTmpFileStore.getTfsTmpDir() + File.separator + serverUri.hashCode() + "_" + itemId + "." + revision;
    }

    TFSTmpFileStore(File tmpFile) {
        this.myTmpFile = tmpFile;
    }

    private static String getTfsTmpDir() throws IOException {
        if (myTfsTmpDir == null) {
            File tmpDir = FileUtil.createTempFile((String)TMP_FILE_NAME, (String)"");
            tmpDir.delete();
            tmpDir.mkdir();
            tmpDir.deleteOnExit();
            myTfsTmpDir = tmpDir.getAbsolutePath();
        }
        return myTfsTmpDir;
    }

    @Override
    public void saveContent(TfsFileUtil.ContentWriter contentWriter) throws TfsException, IOException {
        TfsFileUtil.setFileContent(this.myTmpFile, contentWriter);
    }

    @Override
    public byte[] loadContent() throws IOException {
        try (FileInputStream fileStream = null;){
            fileStream = new FileInputStream(this.myTmpFile);
            byte[] byArray = StreamUtil.loadFromStream((InputStream)fileStream);
            return byArray;
        }
    }
}

