/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui.checkoutwizard;

import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.CheckoutWizardModel;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.CheckoutWizardStep;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.ChooseWorkspaceStep;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.SummaryStep;
import org.jetbrains.tfsIntegration.ui.servertree.TfsTreeForm;

public class ChooseServerPathStep
extends CheckoutWizardStep {
    public static final Object ID = new Object();
    private final TfsTreeForm myForm = new TfsTreeForm();

    public ChooseServerPathStep(CheckoutWizardModel model) {
        super("Choose Source Path", model);
        Disposer.register((Disposable)this, (Disposable)this.myForm);
        this.myForm.addListener(new TfsTreeForm.SelectionListener(){

            @Override
            public void selectionChanged() {
                ChooseServerPathStep.this.validate();
                ChooseServerPathStep.this.fireStateChanged();
            }
        });
    }

    @NotNull
    public Object getStepId() {
        Object object = ID;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/checkoutwizard/ChooseServerPathStep", "getStepId"));
        }
        return object;
    }

    @Nullable
    public Object getNextStepId() {
        return SummaryStep.ID;
    }

    @Nullable
    public Object getPreviousStepId() {
        return ChooseWorkspaceStep.ID;
    }

    public boolean isComplete() {
        return this.isAcceptable(this.myForm.getSelectedPath());
    }

    public JComponent getComponent() {
        return this.myForm.getContentPane();
    }

    public void _init() {
        this.myForm.initialize(this.myModel.getServer(), this.myModel.getServerPath(), true, false, (Condition<String>)((Condition)path -> this.isAcceptable((String)path)));
        this.validate();
    }

    public void commit(AbstractWizardStepEx.CommitType commitType) throws CommitStepException {
        if (this.isAcceptable(this.myForm.getSelectedPath())) {
            this.myModel.setServerPath(this.myForm.getSelectedPath());
        }
    }

    private boolean isAcceptable(String serverPath) {
        if (StringUtil.isEmpty((String)serverPath)) {
            return false;
        }
        try {
            if (this.myModel.getWorkspace().findLocalPathByServerPath(serverPath, true, null) == null) {
                return false;
            }
        }
        catch (TfsException e) {
            return false;
        }
        return true;
    }

    private void validate() {
        String serverPath = this.myForm.getSelectedPath();
        if (StringUtil.isEmpty((String)serverPath)) {
            this.myForm.setMessage(TFSBundle.message("server.path.is.not.selected", new Object[0]), true);
        } else {
            try {
                FilePath localPath = this.myModel.getWorkspace().findLocalPathByServerPath(serverPath, true, null);
                if (localPath != null) {
                    this.myForm.setMessage(TFSBundle.message("server.path.0.is.mapped.to.1", serverPath, localPath.getPresentableUrl()), false);
                } else {
                    this.myForm.setMessage(TFSBundle.message("no.mapping.for.0", serverPath), true);
                }
            }
            catch (TfsException e) {
                this.myForm.setMessage(TFSBundle.message("failed.to.connect", e.getMessage()), true);
            }
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myForm.getPreferredFocusedComponent();
    }

    public String getHelpId() {
        return "reference.checkoutTFS.sourcepath";
    }
}

