/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.webservice;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.Stub;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthPolicy;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.BasicScheme;
import org.apache.commons.httpclient.auth.DigestScheme;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.params.HostParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.configuration.Credentials;
import org.jetbrains.tfsIntegration.exceptions.OperationFailedException;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.exceptions.TfsExceptionManager;
import org.jetbrains.tfsIntegration.webservice.HTTPProxyInfo;
import org.jetbrains.tfsIntegration.webservice.auth.NativeNTLM2Scheme;
import org.jetbrains.tfsIntegration.webservice.compatibility.CustomSOAP12Factory;
import org.jetbrains.tfsIntegration.webservice.compatibility.CustomSOAPBuilder;

public class WebServiceHelper {
    private static final Logger LOG = Logger.getInstance((String)WebServiceHelper.class.getName());
    @NonNls
    private static final String SOAP_BUILDER_KEY = "application/soap+xml";
    @NonNls
    private static final String CONTENT_TYPE_GZIP = "application/gzip";
    public static final String USE_NATIVE_CREDENTIALS = WebServiceHelper.class.getName() + ".overrideCredentials";
    private static final int SOCKET_TIMEOUT = Integer.getInteger("org.jetbrains.tfsIntegration.socketTimeout", 30000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void httpGet(URI serverUri, String downloadUrl, OutputStream outputStream, Credentials credentials, HttpClient httpClient) throws TfsException, IOException {
        block5: {
            TFSVcs.assertTrue(downloadUrl != null);
            WebServiceHelper.setupHttpClient(credentials, serverUri, httpClient);
            GetMethod method = new GetMethod(downloadUrl);
            try {
                int statusCode = httpClient.executeMethod((HttpMethod)method);
                if (statusCode == 200) {
                    StreamUtil.copyStreamContent((InputStream)WebServiceHelper.getInputStream((HttpMethod)method), (OutputStream)outputStream);
                    break block5;
                }
                if (statusCode == 500) {
                    throw new OperationFailedException(method.getResponseBodyAsString());
                }
                throw TfsExceptionManager.createHttpTransportErrorException(statusCode, null);
            }
            finally {
                method.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void httpPost(@NotNull String uploadUrl, @NotNull Part[] parts, @Nullable OutputStream outputStream, Credentials credentials, URI serverUri, HttpClient httpClient) throws IOException, TfsException {
        block8: {
            if (uploadUrl == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uploadUrl", "org/jetbrains/tfsIntegration/webservice/WebServiceHelper", "httpPost"));
            }
            if (parts == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parts", "org/jetbrains/tfsIntegration/webservice/WebServiceHelper", "httpPost"));
            }
            WebServiceHelper.setupHttpClient(credentials, serverUri, httpClient);
            PostMethod method = new PostMethod(uploadUrl);
            try {
                method.setRequestHeader("X-TFS-Version", "1.0.0.0");
                method.setRequestHeader("accept-language", "en-US");
                method.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, method.getParams()));
                int statusCode = httpClient.executeMethod((HttpMethod)method);
                if (statusCode == 200) {
                    if (outputStream != null) {
                        StreamUtil.copyStreamContent((InputStream)WebServiceHelper.getInputStream((HttpMethod)method), (OutputStream)outputStream);
                    }
                    break block8;
                }
                if (statusCode == 500) {
                    throw new OperationFailedException(method.getResponseBodyAsString());
                }
                throw TfsExceptionManager.createHttpTransportErrorException(statusCode, null);
            }
            finally {
                method.releaseConnection();
            }
        }
    }

    public static ConfigurationContext getStubConfigurationContext() {
        return (ConfigurationContext)ClassLoaderUtil.runWithClassLoader((ClassLoader)TFSVcs.class.getClassLoader(), () -> {
            try {
                ConfigurationContext configContext = ConfigurationContextFactory.createDefaultConfigurationContext();
                configContext.getAxisConfiguration().addMessageBuilder(SOAP_BUILDER_KEY, (Builder)new CustomSOAPBuilder());
                return configContext;
            }
            catch (Exception e) {
                LOG.error("Axis2 configuration error", (Throwable)e);
                return null;
            }
        });
    }

    private static void setProxy(HttpClient httpClient) {
        HTTPProxyInfo proxy = HTTPProxyInfo.getCurrent();
        if (proxy.host != null) {
            httpClient.getHostConfiguration().setProxy(proxy.host, proxy.port);
            if (proxy.user != null) {
                Pair<String, String> domainAndUser = WebServiceHelper.getDomainAndUser(proxy.user);
                NTCredentials creds = new NTCredentials((String)domainAndUser.second, proxy.password, proxy.host, (String)domainAndUser.first);
                httpClient.getState().setProxyCredentials(AuthScope.ANY, (org.apache.commons.httpclient.Credentials)creds);
            }
        } else {
            httpClient.getHostConfiguration().setProxyHost(null);
        }
    }

    private static void setupHttpClient(Credentials credentials, URI serverUri, HttpClient httpClient) {
        WebServiceHelper.setCredentials(httpClient, credentials, serverUri);
        WebServiceHelper.setProxy(httpClient);
        httpClient.getParams().setSoTimeout(SOCKET_TIMEOUT);
        if (Registry.is((String)"tfs.set.connection.timeout", (boolean)false)) {
            httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(SOCKET_TIMEOUT);
            httpClient.getHttpConnectionManager().getParams().setSoTimeout(SOCKET_TIMEOUT);
        }
    }

    public static void setupStub(@NotNull Stub stub, @NotNull Credentials credentials, @NotNull URI serverUri) {
        HttpTransportProperties.ProxyProperties proxyProperties;
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/tfsIntegration/webservice/WebServiceHelper", "setupStub"));
        }
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "org/jetbrains/tfsIntegration/webservice/WebServiceHelper", "setupStub"));
        }
        if (serverUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverUri", "org/jetbrains/tfsIntegration/webservice/WebServiceHelper", "setupStub"));
        }
        Options options = stub._getServiceClient().getOptions();
        options.setProperty("__CHUNKED__", (Object)"false");
        options.setProperty("transport.http.acceptGzip", (Object)Boolean.TRUE);
        options.setProperty("SO_TIMEOUT", (Object)SOCKET_TIMEOUT);
        if (Registry.is((String)"tfs.set.connection.timeout", (boolean)false)) {
            options.setProperty("CONNECTION_TIMEOUT", (Object)SOCKET_TIMEOUT);
        }
        if (credentials.getType() == Credentials.Type.Alternate) {
            String basicAuth = BasicScheme.authenticate((UsernamePasswordCredentials)new UsernamePasswordCredentials(credentials.getUserName(), credentials.getPassword()), (String)"UTF-8");
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", basicAuth);
            options.setProperty("HTTP_HEADERS", headers);
        } else {
            HttpTransportProperties.Authenticator auth = new HttpTransportProperties.Authenticator();
            auth.setUsername(credentials.getUserName());
            auth.setPassword(credentials.getPassword() != null ? credentials.getPassword() : "");
            auth.setDomain(credentials.getDomain());
            auth.setHost(serverUri.getHost());
            options.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)auth);
            HttpMethodParams params = new HttpMethodParams();
            params.setBooleanParameter(USE_NATIVE_CREDENTIALS, credentials.getType() == Credentials.Type.NtlmNative);
            options.setProperty("HTTP_METHOD_PARAMS", (Object)params);
        }
        HTTPProxyInfo proxy = HTTPProxyInfo.getCurrent();
        if (proxy.host != null) {
            proxyProperties = new HttpTransportProperties.ProxyProperties();
            Pair<String, String> domainAndUser = WebServiceHelper.getDomainAndUser(proxy.user);
            proxyProperties.setProxyName(proxy.host);
            proxyProperties.setProxyPort(proxy.port);
            proxyProperties.setDomain((String)domainAndUser.first);
            proxyProperties.setUserName((String)domainAndUser.second);
            proxyProperties.setPassWord(proxy.password);
        } else {
            proxyProperties = null;
        }
        options.setProperty("PROXY", (Object)proxyProperties);
    }

    private static void setCredentials(@NotNull HttpClient httpClient, @NotNull Credentials credentials, @NotNull URI serverUri) {
        if (httpClient == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "httpClient", "org/jetbrains/tfsIntegration/webservice/WebServiceHelper", "setCredentials"));
        }
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "org/jetbrains/tfsIntegration/webservice/WebServiceHelper", "setCredentials"));
        }
        if (serverUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverUri", "org/jetbrains/tfsIntegration/webservice/WebServiceHelper", "setCredentials"));
        }
        if (credentials.getType() == Credentials.Type.Alternate) {
            Header authHeader;
            HostParams parameters = httpClient.getHostConfiguration().getParams();
            ArrayList<Header> headers = (ArrayList<Header>)parameters.getParameter("http.default-headers");
            if (headers == null) {
                headers = new ArrayList<Header>();
                parameters.setParameter("http.default-headers", headers);
            }
            if ((authHeader = (Header)ContainerUtil.find((Iterable)headers, header -> header.getName().equals("Authorization"))) == null) {
                authHeader = new Header("Authorization", "");
                headers.add(authHeader);
            }
            authHeader.setValue(BasicScheme.authenticate((UsernamePasswordCredentials)new UsernamePasswordCredentials(credentials.getUserName(), credentials.getPassword()), (String)"UTF-8"));
        } else {
            NTCredentials ntCreds = new NTCredentials(credentials.getUserName(), credentials.getPassword(), serverUri.getHost(), credentials.getDomain());
            httpClient.getState().setCredentials(AuthScope.ANY, (org.apache.commons.httpclient.Credentials)ntCreds);
            httpClient.getParams().setBooleanParameter(USE_NATIVE_CREDENTIALS, credentials.getType() == Credentials.Type.NtlmNative);
        }
    }

    private static InputStream getInputStream(HttpMethod method) throws IOException {
        Header contentType = method.getResponseHeader("Content-Type");
        if (contentType != null && CONTENT_TYPE_GZIP.equalsIgnoreCase(contentType.getValue())) {
            return new GZIPInputStream(method.getResponseBodyAsStream());
        }
        return method.getResponseBodyAsStream();
    }

    private static void trace(long threadId, @NonNls String msg) {
        String dispatch = ApplicationManager.getApplication().isDispatchThread() ? " [d]" : "";
        String message = String.valueOf(System.currentTimeMillis()) + ", thread=" + String.valueOf(threadId) + ", cur thread=" + String.valueOf(Thread.currentThread().getId()) + dispatch + ": " + msg;
    }

    private static Pair<String, String> getDomainAndUser(@Nullable String s) {
        if (s == null) {
            return Pair.create(null, null);
        }
        int slashPos = s.indexOf(92);
        String domain = slashPos >= 0 ? s.substring(0, slashPos) : "";
        String user = slashPos >= 0 ? s.substring(slashPos + 1) : s;
        return Pair.create((Object)domain, (Object)user);
    }

    static {
        AuthPolicy.unregisterAuthScheme((String)"NTLM");
        AuthPolicy.unregisterAuthScheme((String)"Digest");
        AuthPolicy.unregisterAuthScheme((String)"Basic");
        AuthPolicy.registerAuthScheme((String)"NTLM", NativeNTLM2Scheme.class);
        AuthPolicy.registerAuthScheme((String)"Digest", DigestScheme.class);
        AuthPolicy.registerAuthScheme((String)"Basic", BasicScheme.class);
        System.setProperty("soap12.factory", CustomSOAP12Factory.class.getName());
    }

    public static interface Delegate<T> {
        @Nullable
        public T executeRequest() throws RemoteException;
    }
}

