/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.actions;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import org.jetbrains.annotations.NotNull;

public class CreateNewInfo {
    public final String fqn;
    private final PsiDirectory myDirectory;
    private final String myPackage;

    public CreateNewInfo(@NotNull String fqn, @NotNull PsiDirectory directory, @NotNull String aPackage) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "com/intellij/uml/java/actions/CreateNewInfo", "<init>"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/uml/java/actions/CreateNewInfo", "<init>"));
        }
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "com/intellij/uml/java/actions/CreateNewInfo", "<init>"));
        }
        this.fqn = fqn;
        this.myDirectory = directory;
        this.myPackage = aPackage;
    }

    @NotNull
    public PsiDirectory prepareDirectory() {
        String packagePath;
        String path = StringUtil.trimEnd((String)this.myDirectory.getVirtualFile().getPath().replace('\\', '/'), (char)'/');
        if (!path.endsWith(packagePath = StringUtil.trimEnd((String)StringUtil.trimStart((String)this.myPackage, (String)"."), (String)".").replace('.', '/'))) {
            PsiDirectory directory = this.myDirectory;
            for (String name : StringUtil.split((String)packagePath, (String)"/")) {
                PsiDirectory subDirectory = directory.findSubdirectory(name);
                if (subDirectory == null) {
                    subDirectory = directory.createSubdirectory(name);
                }
                directory = subDirectory;
            }
            PsiDirectory psiDirectory = directory;
            if (psiDirectory == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/java/actions/CreateNewInfo", "prepareDirectory"));
            }
            return psiDirectory;
        }
        PsiDirectory psiDirectory = this.myDirectory;
        if (psiDirectory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/java/actions/CreateNewInfo", "prepareDirectory"));
        }
        return psiDirectory;
    }
}

