/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.actions;

import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.uml.UmlFileEditorImpl;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class NewJavaDiagram
extends AnAction {
    protected NewJavaDiagram() {
        super("Java Class Diagram", null, AllIcons.FileTypes.Diagram);
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        final VirtualFile file = NewJavaDiagram.getFile(e);
        if (file != null) {
            FileEditor[] fileEditors;
            CommandProcessor.getInstance().executeCommand(project, () -> {
                DiagramState state = new DiagramState(DiagramProvider.findByID((String)"JAVA"));
                state.setOriginalFQN("");
                state.saveTo(file, project);
                BasicUndoableAction undo = new BasicUndoableAction(new VirtualFile[]{file}){

                    public void undo() throws UnexpectedUndoException {
                        int ok = Messages.showOkCancelDialog((Project)project, (String)("Undo creating Java Class Diagram " + file.getName() + "?"), (String)"Undo", (Icon)Messages.getQuestionIcon());
                        if (ok == 0) {
                            WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                                try {
                                    file.delete((Object)this);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            });
                        }
                    }

                    public void redo() throws UnexpectedUndoException {
                    }
                };
                UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)undo);
            }, "Create New Java Class Diagram", (Object)"Create New Java Class Diagram");
            for (FileEditor editor : fileEditors = FileEditorManager.getInstance((Project)project).openFile(file, true)) {
                if (!(editor instanceof UmlFileEditorImpl)) continue;
                ((UmlFileEditorImpl)editor).getBuilder().getDataModel().setShowDependencies(true);
                break;
            }
        }
    }

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        IdeView view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        if (project == null || view == null || view.getDirectories().length == 0) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        boolean isJavaModule = module != null && StdModuleTypes.JAVA.getId().equals(module.getModuleTypeName());
        e.getPresentation().setEnabledAndVisible(isJavaModule);
    }

    @Nullable
    public static VirtualFile getFile(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (file == null) {
            file = project.getBaseDir();
        }
        if (file != null && !file.isDirectory()) {
            file = file.getParent();
        }
        FileSaverDescriptor descriptor = new FileSaverDescriptor("Create Java Class Diagram", "Set diagram name", new String[]{"uml"});
        FileSaverDialog dialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, project);
        VirtualFileWrapper result = dialog.save(file, "");
        return result == null ? null : result.getVirtualFile(true);
    }
}

