/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.jigsaw;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.uml.jigsaw.JigsawUmlEdge;
import com.intellij.uml.jigsaw.JigsawUmlNode;
import com.intellij.uml.jigsaw.JigsawUmlProvider;
import com.intellij.uml.jigsaw.JigsawUmlRelationships;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JigsawUmlDataModel
extends DiagramDataModel<PsiJavaModule> {
    private static final Logger LOG = Logger.getInstance(JigsawUmlDataModel.class);
    private final Set<JigsawUmlNode> myNodes;
    private final Set<JigsawUmlEdge> myEdges;
    private final Map<String, SmartPsiElementPointer<PsiJavaModule>> myInitialElements;

    public JigsawUmlDataModel(@NotNull Project project, @Nullable PsiJavaModule element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/uml/jigsaw/JigsawUmlDataModel", "<init>"));
        }
        super(project, (DiagramProvider)JigsawUmlProvider.getInstance());
        this.myNodes = new THashSet();
        this.myEdges = new THashSet();
        this.myInitialElements = new THashMap();
        if (element != null) {
            this.myInitialElements.put(element.getName(), this.createPointer(element));
        }
    }

    @NotNull
    public synchronized Collection<? extends DiagramNode<PsiJavaModule>> getNodes() {
        Set<JigsawUmlNode> set = this.myNodes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/jigsaw/JigsawUmlDataModel", "getNodes"));
        }
        return set;
    }

    @NotNull
    public synchronized Collection<? extends DiagramEdge<PsiJavaModule>> getEdges() {
        Set<JigsawUmlEdge> set = this.myEdges;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/jigsaw/JigsawUmlDataModel", "getEdges"));
        }
        return set;
    }

    @NotNull
    public String getNodeName(DiagramNode<PsiJavaModule> n) {
        String string = ((PsiJavaModule)n.getIdentifyingElement()).getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/jigsaw/JigsawUmlDataModel", "getNodeName"));
        }
        return string;
    }

    @Nullable
    public synchronized DiagramNode<PsiJavaModule> addElement(PsiJavaModule element) {
        if (element == null) {
            return null;
        }
        this.myInitialElements.computeIfAbsent(element.getName(), unused -> this.createPointer(element));
        return new JigsawUmlNode(element, (JigsawUmlProvider)this.getBuilder().getProvider());
    }

    @NotNull
    private SmartPsiElementPointer<PsiJavaModule> createPointer(@NotNull PsiJavaModule element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/uml/jigsaw/JigsawUmlDataModel", "createPointer"));
        }
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)this.getProject()).createSmartPsiElementPointer((PsiElement)element);
        if (smartPsiElementPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/jigsaw/JigsawUmlDataModel", "createPointer"));
        }
        return smartPsiElementPointer;
    }

    public void refreshDataModel() {
        this.updateDataModel();
    }

    private synchronized void updateDataModel() {
        this.myNodes.clear();
        this.myEdges.clear();
        JigsawUmlProvider umlProvider = (JigsawUmlProvider)this.getBuilder().getProvider();
        THashSet pendingModulesQueue = new THashSet();
        for (SmartPsiElementPointer<PsiJavaModule> psiElementPointer : this.myInitialElements.values()) {
            ContainerUtil.addIfNotNull((Collection)pendingModulesQueue, (Object)psiElementPointer.getElement());
        }
        THashMap usedModules = new THashMap();
        while (!pendingModulesQueue.isEmpty()) {
            Iterator it = pendingModulesQueue.iterator();
            LOG.assertTrue(it.hasNext(), (Object)"next pending module");
            PsiJavaModule javaModule = (PsiJavaModule)it.next();
            it.remove();
            JigsawUmlNode toNode = usedModules.computeIfAbsent(javaModule, aModule -> new JigsawUmlNode((PsiJavaModule)aModule, umlProvider));
            Map<PsiJavaModule, DiagramRelationshipInfo> requiredModules = JigsawUmlDataModel.getRequiredModules(javaModule);
            for (Map.Entry<PsiJavaModule, DiagramRelationshipInfo> requiredModule : requiredModules.entrySet()) {
                JigsawUmlNode fromNode = usedModules.computeIfAbsent(requiredModule.getKey(), arg_0 -> JigsawUmlDataModel.lambda$updateDataModel$2((Set)pendingModulesQueue, umlProvider, arg_0));
                this.myEdges.add(new JigsawUmlEdge((DiagramNode<PsiJavaModule>)fromNode, (DiagramNode<PsiJavaModule>)toNode, requiredModule.getValue()));
            }
        }
        this.myNodes.addAll(usedModules.values());
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        PsiModificationTracker psiModificationTracker = PsiManager.getInstance((Project)this.getProject()).getModificationTracker();
        if (psiModificationTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/jigsaw/JigsawUmlDataModel", "getModificationTracker"));
        }
        return psiModificationTracker;
    }

    public void dispose() {
    }

    @NotNull
    private static Map<PsiJavaModule, DiagramRelationshipInfo> getRequiredModules(@NotNull PsiJavaModule javaModule) {
        if (javaModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaModule", "com/intellij/uml/jigsaw/JigsawUmlDataModel", "getRequiredModules"));
        }
        THashMap result = new THashMap();
        for (PsiRequiresStatement requiresStatement : javaModule.getRequires()) {
            PsiElement resolved;
            PsiPolyVariantReference reference;
            PsiJavaModuleReferenceElement referenceElement = requiresStatement.getReferenceElement();
            if (referenceElement == null || (reference = referenceElement.getReference()) == null || !((resolved = reference.resolve()) instanceof PsiJavaModule)) continue;
            DiagramRelationshipInfo relationship = JigsawUmlRelationships.getRelationship(requiresStatement.hasModifierProperty("transitive"), requiresStatement.hasModifierProperty("static"));
            result.put((PsiJavaModule)resolved, relationship);
        }
        THashMap tHashMap = result;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/jigsaw/JigsawUmlDataModel", "getRequiredModules"));
        }
        return tHashMap;
    }

    private static /* synthetic */ JigsawUmlNode lambda$updateDataModel$2(Set pendingModulesQueue, JigsawUmlProvider umlProvider, PsiJavaModule aModule) {
        pendingModulesQueue.add(aModule);
        return new JigsawUmlNode(aModule, umlProvider);
    }
}

