/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.jigsaw;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.index.JavaModuleNameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.SimpleColoredText;
import com.intellij.uml.utils.UmlBundle;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JigsawUmlElementManager
extends AbstractDiagramElementManager<PsiJavaModule> {
    @Nullable
    public PsiJavaModule findInDataContext(DataContext context) {
        Collection<PsiJavaModule> javaModules = JigsawUmlElementManager.findJavaModulesInDataContext(context, true);
        return (PsiJavaModule)ContainerUtil.getFirstItem(javaModules);
    }

    @NotNull
    public Collection<PsiJavaModule> findElementsInDataContext(DataContext context) {
        Collection<PsiJavaModule> collection = JigsawUmlElementManager.findJavaModulesInDataContext(context, false);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/jigsaw/JigsawUmlElementManager", "findElementsInDataContext"));
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiJavaModule> findJavaModulesInDataContext(DataContext context, boolean findFirst) {
        VirtualFile[] selectedFiles;
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            Set<PsiJavaModule> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/jigsaw/JigsawUmlElementManager", "findJavaModulesInDataContext"));
            }
            return set;
        }
        THashSet javaModules = new THashSet();
        Module[] selectedModules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(context);
        if (selectedModules != null) {
            for (Module module : selectedModules) {
                if (JigsawUmlElementManager.addJavaModuleDefinition(project, (Set<PsiJavaModule>)javaModules, module, findFirst)) {
                    THashSet tHashSet = javaModules;
                    if (tHashSet == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/jigsaw/JigsawUmlElementManager", "findJavaModulesInDataContext"));
                    }
                    return tHashSet;
                }
                OrderEnumerator enumerator = OrderEnumerator.orderEntries((Module)module).withoutSdk().withoutModuleSourceEntries();
                enumerator.forEachModule(arg_0 -> JigsawUmlElementManager.lambda$findJavaModulesInDataContext$0(project, (Set)javaModules, findFirst, arg_0));
                if (!findFirst || javaModules.isEmpty()) continue;
                THashSet tHashSet = javaModules;
                if (tHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/jigsaw/JigsawUmlElementManager", "findJavaModulesInDataContext"));
                }
                return tHashSet;
            }
        }
        if ((selectedFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context)) != null) {
            for (VirtualFile virtualFile : selectedFiles) {
                PsiJavaModule javaModule = JigsawUmlElementManager.findJavaModuleForVirtualFile(project, virtualFile);
                if (javaModule == null) continue;
                javaModules.add(javaModule);
                if (!findFirst) continue;
                THashSet tHashSet = javaModules;
                if (tHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/jigsaw/JigsawUmlElementManager", "findJavaModulesInDataContext"));
                }
                return tHashSet;
            }
        }
        if (javaModules.isEmpty() && (selectedModules != null || selectedFiles != null)) {
            GlobalSearchScope projectScope = ProjectScope.getProjectScope((Project)project);
            JavaModuleNameIndex index = JavaModuleNameIndex.getInstance();
            for (String name : index.getAllKeys(project)) {
                javaModules.addAll(index.get(name, project, projectScope));
                if (!findFirst || javaModules.isEmpty()) continue;
                THashSet tHashSet = javaModules;
                if (tHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/jigsaw/JigsawUmlElementManager", "findJavaModulesInDataContext"));
                }
                return tHashSet;
            }
        }
        THashSet tHashSet = javaModules;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/jigsaw/JigsawUmlElementManager", "findJavaModulesInDataContext"));
        }
        return tHashSet;
    }

    private static boolean addJavaModuleDefinition(@NotNull Project project, @NotNull Set<PsiJavaModule> javaModules, @NotNull Module module, boolean findFirst) {
        PsiJavaModule javaModule;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/uml/jigsaw/JigsawUmlElementManager", "addJavaModuleDefinition"));
        }
        if (javaModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaModules", "com/intellij/uml/jigsaw/JigsawUmlElementManager", "addJavaModuleDefinition"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/uml/jigsaw/JigsawUmlElementManager", "addJavaModuleDefinition"));
        }
        VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(false);
        if (sourceRoots.length != 0 && (javaModule = JigsawUmlElementManager.findJavaModuleForVirtualFile(project, sourceRoots[0])) != null) {
            javaModules.add(javaModule);
            if (findFirst) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiJavaModule findJavaModuleForVirtualFile(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/uml/jigsaw/JigsawUmlElementManager", "findJavaModuleForVirtualFile"));
        }
        if (virtualFile == null) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiDirectory psiElement = virtualFile.isDirectory() ? psiManager.findDirectory(virtualFile) : psiManager.findFile(virtualFile);
        return JavaModuleGraphUtil.findDescriptorByElement((PsiElement)psiElement);
    }

    public boolean isAcceptableAsNode(Object element) {
        return element instanceof PsiJavaModule || element instanceof PsiElement && JavaModuleGraphUtil.findDescriptorByElement((PsiElement)((PsiElement)element)) != null;
    }

    @Nullable
    public String getElementTitle(PsiJavaModule element) {
        return element.getName();
    }

    @Nullable
    public SimpleColoredText getItemName(Object element, DiagramState presentation) {
        if (element instanceof PsiJavaModule) {
            return new SimpleColoredText(((PsiJavaModule)element).getName(), DEFAULT_TITLE_ATTR);
        }
        return null;
    }

    public String getNodeTooltip(PsiJavaModule element) {
        return element.getName();
    }

    public String getEditorTitle(PsiJavaModule element, DiagramState presentation, Collection<PsiJavaModule> additionalElements) {
        return UmlBundle.message("uml.jigsaw.presentable.name", new Object[0]);
    }

    public int getTitleAttributes(PsiJavaModule element) {
        if (PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)element)) {
            return 4;
        }
        return super.getTitleAttributes((Object)element);
    }

    private static /* synthetic */ boolean lambda$findJavaModulesInDataContext$0(Project project, Set javaModules, boolean findFirst, Module subModule) {
        return !JigsawUmlElementManager.addJavaModuleDefinition(project, javaModules, subModule, findFirst);
    }
}

