/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;
import org.osmorc.facet.OsmorcFacetType;
import org.osmorc.impl.AdditionalJARContentsWatcherManager;

public class OsmorcPostStartupActivity
implements StartupActivity {
    private static void handleFacetChange(@NotNull Facet facet, @NotNull Project project) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/osmorc/OsmorcPostStartupActivity", "handleFacetChange"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/osmorc/OsmorcPostStartupActivity", "handleFacetChange"));
        }
        if (facet.getTypeId() != OsmorcFacetType.ID) {
            return;
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AdditionalJARContentsWatcherManager.getInstance(module).updateWatcherSetup();
        }
    }

    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/osmorc/OsmorcPostStartupActivity", "runActivity"));
        }
        if (project.isDefault()) {
            return;
        }
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerAdapter(){

            public void facetAdded(@NotNull Facet facet) {
                if (facet == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/osmorc/OsmorcPostStartupActivity$1", "facetAdded"));
                }
                OsmorcPostStartupActivity.handleFacetChange(facet, project);
            }

            public void facetConfigurationChanged(@NotNull Facet facet) {
                if (facet == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/osmorc/OsmorcPostStartupActivity$1", "facetConfigurationChanged"));
                }
                OsmorcPostStartupActivity.handleFacetChange(facet, project);
            }
        });
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosing(Project project) {
                for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                    AdditionalJARContentsWatcherManager.getInstance(module).cleanup();
                }
            }
        });
    }
}

