/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.manifest.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

class HeaderParametersProvider
extends CompletionProvider<CompletionParameters> {
    private static final InsertHandler<LookupElement> ATTRIBUTE_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(InsertionContext context, LookupElement item) {
            context.setAddCompletionChar(false);
            EditorModificationUtil.insertStringAtCaret((Editor)context.getEditor(), (String)"=");
            context.commitDocument();
        }
    };
    private static final InsertHandler<LookupElement> DIRECTIVE_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(InsertionContext context, LookupElement item) {
            context.setAddCompletionChar(false);
            EditorModificationUtil.insertStringAtCaret((Editor)context.getEditor(), (String)":=");
            context.commitDocument();
        }
    };
    private final String[] myNames;

    public HeaderParametersProvider(String ... names) {
        this.myNames = names;
    }

    public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/osmorc/manifest/completion/HeaderParametersProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/osmorc/manifest/completion/HeaderParametersProvider", "addCompletions"));
        }
        for (String name : this.myNames) {
            boolean directive = StringUtil.endsWithChar((CharSequence)name, (char)':');
            if (directive) {
                name = name.substring(0, name.length() - 1);
            }
            result.addElement((LookupElement)LookupElementBuilder.create((String)name).withCaseSensitivity(false).withInsertHandler(directive ? DIRECTIVE_HANDLER : ATTRIBUTE_HANDLER));
        }
    }
}

