/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.highlighting;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.spring.el.SpringELLanguage;
import com.intellij.spring.security.model.xml.converters.InterceptUrlAccessWrappingConverter;
import com.intellij.util.ProcessingContext;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringSecuritySpElAccessInjector
implements MultiHostInjector {
    public static final XmlAttributeValuePattern ACCESS_ATTR_PATTERN = (XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withLocalName(new String[]{"access"}).withSuperParent(2, (ElementPattern)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withLocalName(new String[]{"intercept-url", "intercept-message", "authorize"})).withNamespace(new String[]{"http://www.springframework.org/schema/security", "http://www.springframework.org/security/tags"}));
    private static final XmlAttributeValuePattern TAGLIB_AUTHORIZE_ACCESS_PATTERN = (XmlAttributeValuePattern)((XmlAttributeValuePattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withLocalName(new String[]{"access"}).withSuperParent(2, (ElementPattern)XmlPatterns.xmlTag().withLocalName("authorize"))).inVirtualFile(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.virtualFile().ofType((FileType)StdFileTypes.JSP), PlatformPatterns.virtualFile().ofType((FileType)StdFileTypes.JSPX)}))).withSuperParent(2, (ElementPattern)XmlPatterns.xmlTag().withNamespace("http://www.springframework.org/security/tags"));

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/security/highlighting/SpringSecuritySpElAccessInjector", "getLanguagesToInject"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/spring/security/highlighting/SpringSecuritySpElAccessInjector", "getLanguagesToInject"));
        }
        if (host.getTextLength() < 3) {
            return;
        }
        PsiFile containingFile = host.getContainingFile();
        if (JamCommonUtil.isPlainXmlFile((PsiElement)containingFile)) {
            ProcessingContext context = new ProcessingContext();
            if (ACCESS_ATTR_PATTERN.accepts((Object)host, context)) {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)host);
                if (!InterceptUrlAccessWrappingConverter.useRoleConverter(((XmlAttributeValue)host).getValue(), module)) {
                    registrar.startInjecting((Language)SpringELLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)host, TextRange.from((int)1, (int)(host.getTextLength() - 2))).doneInjecting();
                }
            }
        } else if (TAGLIB_AUTHORIZE_ACCESS_PATTERN.accepts((Object)host)) {
            registrar.startInjecting((Language)SpringELLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)host, TextRange.from((int)1, (int)(host.getTextLength() - 2))).doneInjecting();
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<XmlAttributeValue>> list = Collections.singletonList(XmlAttributeValue.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/highlighting/SpringSecuritySpElAccessInjector", "elementsToInjectIn"));
        }
        return list;
    }
}

