/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.security.model.xml.converters.roles.SpringSecurityRolesFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class SpringSecurityRolePsiReference
extends PsiReferenceBase<PsiElement> {
    private final String myRoleName;
    private final Module myModule;
    private final boolean myIncludePredefinedRoles;

    public SpringSecurityRolePsiReference(@NotNull PsiElement element, @NotNull String roleName, @NotNull Module module, boolean includePredefinedRoles) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/security/references/SpringSecurityRolePsiReference", "<init>"));
        }
        if (roleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roleName", "com/intellij/spring/security/references/SpringSecurityRolePsiReference", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/security/references/SpringSecurityRolePsiReference", "<init>"));
        }
        super(element, SpringSecurityRolePsiReference.getTextRange(element, roleName));
        this.myRoleName = roleName;
        this.myModule = module;
        this.myIncludePredefinedRoles = includePredefinedRoles;
    }

    private static TextRange getTextRange(PsiElement element, String roleName) {
        if (roleName.isEmpty()) {
            return TextRange.EMPTY_RANGE;
        }
        int offset = element.getText().indexOf(roleName);
        if (offset == -1) {
            return TextRange.EMPTY_RANGE;
        }
        return TextRange.from((int)offset, (int)roleName.length());
    }

    public PsiElement resolve() {
        if (StringUtil.isEmptyOrSpaces((String)this.myRoleName)) {
            return null;
        }
        return SpringSecurityRolesFactory.getInstance(this.myModule).getOrCreateRole(this.myRoleName, this.getElement().getContainingFile());
    }

    public boolean isSoft() {
        return true;
    }

    @NotNull
    public Object[] getVariants() {
        HashSet variants = new HashSet();
        SpringSecurityRolesFactory securityRolesFactory = SpringSecurityRolesFactory.getInstance(this.myModule);
        ContainerUtil.addAll(variants, (Object[])securityRolesFactory.getRolesVariants());
        if (this.myIncludePredefinedRoles) {
            ContainerUtil.addAll(variants, (Object[])securityRolesFactory.getPredefinedRolesVariants());
        }
        Object[] objectArray = ArrayUtil.toObjectArray(variants);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/references/SpringSecurityRolePsiReference", "getVariants"));
        }
        return objectArray;
    }
}

