/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud;

import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.openshift.cloud.OSDeploymentConfiguration;
import com.intellij.javaee.openshift.cloud.OSDeploymentNameEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.DeploymentNameConfiguration;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class OSDeploymentEditor
extends SettingsEditor<OSDeploymentConfiguration> {
    private OSDeploymentNameEditor myDeploymentNameEditor;
    private JPanel myMainPanel;
    private JTextField myDebugPortField;
    private JPanel myDeploymentNamePanel;

    public OSDeploymentEditor() {
        this.$$$setupUI$$$();
        Disposer.register((Disposable)this, (Disposable)this.getDeploymentNameEditor());
    }

    protected void resetEditorFrom(@NotNull OSDeploymentConfiguration s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/javaee/openshift/cloud/OSDeploymentEditor", "resetEditorFrom"));
        }
        this.myDeploymentNameEditor.resetEditorFrom((DeploymentNameConfiguration)s);
        Integer port = s.getDebugPort();
        String debugPort = port != null ? String.valueOf(port) : "";
        this.myDebugPortField.setText(debugPort);
    }

    protected void applyEditorTo(@NotNull OSDeploymentConfiguration s) throws ConfigurationException {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/javaee/openshift/cloud/OSDeploymentEditor", "applyEditorTo"));
        }
        this.myDeploymentNameEditor.applyEditorTo((DeploymentNameConfiguration)s);
        s.setDebugPort(this.parsePort());
    }

    private void createUIComponents() {
        this.myDeploymentNamePanel = (JPanel)this.getDeploymentNameEditor().getComponent();
    }

    private OSDeploymentNameEditor getDeploymentNameEditor() {
        if (this.myDeploymentNameEditor == null) {
            this.myDeploymentNameEditor = new OSDeploymentNameEditor();
        }
        return this.myDeploymentNameEditor;
    }

    private Integer parsePort() throws RuntimeConfigurationException {
        String debugPort = this.myDebugPortField.getText();
        if (StringUtil.isEmpty((String)debugPort)) {
            return null;
        }
        try {
            return Integer.parseInt(debugPort);
        }
        catch (NumberFormatException e) {
            throw new RuntimeConfigurationException("Invalid port number");
        }
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/openshift/cloud/OSDeploymentEditor", "createEditor"));
        }
        return jPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = this.myDeploymentNamePanel;
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Debug Port: ");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myDebugPortField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

