/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.server;

import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.oss.descriptor.JavaeeDescriptor;
import com.intellij.javaee.oss.descriptor.JavaeeDescriptorsManager;
import com.intellij.javaee.oss.jetty.JettyBundle;
import com.intellij.javaee.oss.jetty.JettyUtil;
import com.intellij.javaee.oss.jetty.model.JettyConfigSetElement;
import com.intellij.javaee.oss.jetty.model.JettyWebRootElement;
import com.intellij.javaee.oss.jetty.server.JettyConfigFileWriter;
import com.intellij.javaee.oss.jetty.server.JettyDeployTarget;
import com.intellij.javaee.oss.jetty.server.JettyDeploymentMethod;
import com.intellij.javaee.oss.jetty.server.JettyDeploymentModel;
import com.intellij.javaee.oss.jetty.server.JettyIntegration;
import com.intellij.javaee.oss.jetty.server.JettyLocalModel;
import com.intellij.javaee.oss.jetty.server.JettyRemoteModel;
import com.intellij.javaee.oss.jetty.server.JettyServerModel;
import com.intellij.javaee.oss.jetty.version.JettyVersionHandler;
import com.intellij.javaee.ui.packaging.JavaeeFacetResourcesElementType;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Processor;
import com.intellij.util.descriptors.ConfigFile;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JettyContextDeploymentMethod
extends JettyDeploymentMethod {
    @NonNls
    private static String WAR_ATTR_NAME = "war";
    @NonNls
    private static String RESOURCE_BASE_ATTR_NAME = "resourceBase";
    private final Map<String, File> mySourcePath2ContextFile = new HashMap<String, File>();

    public JettyContextDeploymentMethod() {
        super(JettyBundle.getText("JettyContextDeploymentMethod.name", new Object[0]));
    }

    @Override
    public boolean deploy(final DeploymentModel deploymentModel, final File source, JettyServerModel serverModel) throws IOException, RuntimeConfigurationException {
        String sourcePath = source.getAbsolutePath();
        if (serverModel instanceof JettyRemoteModel) {
            sourcePath = ((JettyRemoteModel)serverModel).prepareDeployment(sourcePath);
        }
        final String finalSourcePath = sourcePath;
        File contextDir = FileUtil.createTempDirectory((String)source.getName(), (String)"context");
        contextDir.deleteOnExit();
        Project project = deploymentModel.getCommonModel().getProject();
        Ref descriptorFileRef = new Ref();
        final Artifact artifact = deploymentModel.getArtifact();
        if (artifact != null) {
            final PackagingElementResolvingContext resolvingContext = ArtifactManager.getInstance((Project)project).getResolvingContext();
            JavaeeDescriptorsManager descriptorsManager = JettyIntegration.getInstance().getDescriptorsManager();
            JavaeeDescriptor jettyDescriptor = descriptorsManager.getItem(JettyWebRootElement.class);
            final Processor webFacetProcessor = javaeeFacetResourcesPackagingElement -> {
                JavaeeFacet javaeeFacet = javaeeFacetResourcesPackagingElement.findFacet(resolvingContext);
                if (javaeeFacet instanceof WebFacet) {
                    WebFacet webFacet = (WebFacet)javaeeFacet;
                    ConfigFile configFile = webFacet.getDescriptorsContainer().getConfigFile(jettyDescriptor.getMetaData());
                    if (configFile != null) {
                        descriptorFileRef.set((Object)configFile.getXmlFile());
                    }
                    return false;
                }
                return true;
            };
            new ReadAction(){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javaee/oss/jetty/server/JettyContextDeploymentMethod$1", "run"));
                    }
                    ArtifactUtil.processPackagingElements((Artifact)artifact, (PackagingElementType)JavaeeFacetResourcesElementType.getInstance(), (Processor)webFacetProcessor, (PackagingElementResolvingContext)resolvingContext, (boolean)true);
                }
            }.execute();
        }
        JettyVersionHandler versionHandler = serverModel.getVersionHandler();
        File contextFile = new JettyConfigFileWriter(){

            @Override
            protected void createContent(JettyWebRootElement rootElement) {
                JettyConfigSetElement contextPathElement = JettyUtil.getOrCreateContextRoot(rootElement);
                JettyDeploymentModel jettyDeploymentModel = (JettyDeploymentModel)deploymentModel;
                contextPathElement.setValue(jettyDeploymentModel.getFinalContextRoot(source));
                String sourceElementName = deploymentModel.getDeploymentSource().isArchive() ? WAR_ATTR_NAME : RESOURCE_BASE_ATTR_NAME;
                JettyConfigSetElement sourceElement = null;
                for (JettyConfigSetElement setElement : rootElement.getSets()) {
                    if (!sourceElementName.equals(setElement.getName().getValue())) continue;
                    sourceElement = setElement;
                    break;
                }
                if (sourceElement == null) {
                    sourceElement = rootElement.addSet();
                    sourceElement.getName().setValue((Object)sourceElementName);
                }
                sourceElement.setValue(finalSourcePath);
            }
        }.writeConfigFile(project, versionHandler, FileUtil.getNameWithoutExtension((File)source) + ".xml", versionHandler.getWebAppClassName() + ".WebAppContext", contextDir, (XmlFile)descriptorFileRef.get());
        this.mySourcePath2ContextFile.put(source.getAbsolutePath(), contextFile);
        return new HomeOrTemporalProcessor(){

            @Override
            protected boolean processInHome(JettyServerModel serverModel, File contextFile) {
                return serverModel.transferFile(contextFile, JettyDeployTarget.TARGET_CONTEXT);
            }

            @Override
            protected boolean processInTemporal(File contextFile, File sessionTemporalContextsFolder) {
                return JettyLocalModel.transferFile(contextFile, sessionTemporalContextsFolder);
            }
        }.process(serverModel, contextFile);
    }

    @Override
    public boolean undeploy(DeploymentModel deploymentModel, File source, JettyServerModel serverModel) {
        File contextFile = this.mySourcePath2ContextFile.get(source.getAbsolutePath());
        if (contextFile == null) {
            return false;
        }
        return new HomeOrTemporalProcessor(){

            @Override
            protected boolean processInHome(JettyServerModel serverModel, File contextFile) {
                return serverModel.deleteFile(contextFile, JettyDeployTarget.TARGET_CONTEXT);
            }

            @Override
            protected boolean processInTemporal(File contextFile, File sessionTemporalContextsFolder) {
                return JettyLocalModel.deleteFile(contextFile, sessionTemporalContextsFolder);
            }
        }.process(serverModel, contextFile);
    }

    @Override
    public Collection<String> getRequiredRemoteTargetNames() {
        return Arrays.asList("CONTEXT", "STAGING");
    }

    private static abstract class HomeOrTemporalProcessor {
        private HomeOrTemporalProcessor() {
        }

        public boolean process(JettyServerModel serverModel, File contextFile) {
            if (serverModel instanceof JettyLocalModel) {
                JettyLocalModel localModel = (JettyLocalModel)serverModel;
                return this.processInTemporal(contextFile, localModel.getSessionTemporalContextsFolder());
            }
            return this.processInHome(serverModel, contextFile);
        }

        protected abstract boolean processInHome(JettyServerModel var1, File var2);

        protected abstract boolean processInTemporal(File var1, File var2);
    }
}

