/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.server;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.javaee.oss.jetty.JettyBundle;
import com.intellij.javaee.oss.jetty.JettyUtil;
import com.intellij.javaee.oss.jetty.server.JettyConfigFile;
import com.intellij.javaee.oss.jetty.server.JettyConfigFilesCollector;
import com.intellij.javaee.oss.jetty.server.JettyConfigFilesEditor;
import com.intellij.javaee.oss.jetty.server.JettyIniProcessor;
import com.intellij.javaee.oss.jetty.server.JettyIniProducer;
import com.intellij.javaee.oss.jetty.server.JettyIntegration;
import com.intellij.javaee.oss.jetty.server.JettyPersistentData;
import com.intellij.javaee.oss.jetty.server.JettyServerModel;
import com.intellij.javaee.oss.jetty.version.JettyVersionHandler;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.oss.server.JavaeePersistentDataWithBase;
import com.intellij.javaee.oss.server.JavaeePersistentDataWithBaseEditor;
import com.intellij.javaee.oss.util.Version;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class JettyPersistentDataEditor
extends JavaeePersistentDataWithBaseEditor<JettyPersistentData> {
    private static final Logger LOG = Logger.getInstance(JettyPersistentDataEditor.class);
    private JPanel myMainPanel;
    private JPanel myConfigFilesPanel;
    private JBLabel myWarningLabel;
    private JettyConfigFilesEditor myConfigFilesEditor;
    private boolean myInResetEditor = false;

    public JettyPersistentDataEditor() {
        super(JettyIntegration.getInstance());
        this.$$$setupUI$$$();
        this.getCustomPanelPlaceHolder().add(this.myMainPanel);
        this.myWarningLabel.setIcon(AllIcons.RunConfigurations.ConfigurationWarning);
        this.myWarningLabel.setText(JettyBundle.getText("JettyPersistentDataEditor.error.ini", new Object[0]));
    }

    protected boolean isBaseDirSupported() {
        return JettyUtil.isBaseDirSupported(this.getVersion());
    }

    protected void doValidateBaseDir(String baseDir) throws IOException {
        JavaeeIntegration.checkDir((File)new File(baseDir));
        if (new Version(this.getVersion()).compare(9, 2, 4) < 0) {
            JavaeeIntegration.checkFile((String)baseDir, (String)FileUtil.toSystemDependentName((String)"start.d/http.ini"));
        }
        JavaeeIntegration.checkFile((String)baseDir, (String)"start.ini");
        JavaeeIntegration.checkDir((File)new File(baseDir, "webapps"));
    }

    protected void onBaseChanged() {
        super.onBaseChanged();
        this.updateConfigFilesEditor();
    }

    protected void onHomeChanged() {
        super.onHomeChanged();
        this.updateConfigFilesEditor();
    }

    private void updateConfigFilesEditor() {
        if (!this.myInResetEditor && this.isValidHomeSelected()) {
            this.doUpdateConfigFilesEditor(Collections.emptyList());
        }
    }

    private void doUpdateConfigFilesEditor(List<String> additionalPaths) {
        JettyVersionHandler versionHandler;
        JettyConfigFilesEditor configFilesEditor = this.getConfigFilesEditor();
        boolean validHomeSelected = this.isValidHomeSelected();
        if (validHomeSelected && (versionHandler = this.getVersionHandler()).hasIniFile()) {
            String workDir = this.getWorkDir();
            boolean editorEnabled = new JettyIniProcessor(workDir).getIniFile().canWrite();
            configFilesEditor.setEnabled(editorEnabled);
            this.toggleWarning(!editorEnabled);
            JettyConfigFilesCollector collector = versionHandler.getConfigFilesCollector(this.getHome(), workDir, null);
            collector.scanIni();
            collector.scanDir();
            collector.addPaths(additionalPaths);
            collector.updateEditor(configFilesEditor);
            return;
        }
        configFilesEditor.setFiles(Collections.emptyList());
        configFilesEditor.setEnabled(false);
        this.toggleWarning(false);
    }

    protected void applyEditorTo(@NotNull JettyPersistentData settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/javaee/oss/jetty/server/JettyPersistentDataEditor", "applyEditorTo"));
        }
        super.applyEditorTo((JavaeePersistentDataWithBase)settings);
        ArrayList<String> configFilePaths = new ArrayList<String>();
        for (JettyConfigFile configFile : this.getConfigFilesEditor().getFiles()) {
            configFilePaths.add(configFile.getPath());
        }
        settings.setConfigFilePaths(configFilePaths);
    }

    protected void resetEditorFrom(@NotNull JettyPersistentData settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/javaee/oss/jetty/server/JettyPersistentDataEditor", "resetEditorFrom"));
        }
        this.myInResetEditor = true;
        try {
            super.resetEditorFrom((JavaeePersistentDataWithBase)settings);
        }
        finally {
            this.myInResetEditor = false;
        }
        this.doUpdateConfigFilesEditor(settings.getConfigFilePaths());
    }

    private JettyConfigFilesEditor getConfigFilesEditor() {
        if (this.myConfigFilesEditor == null) {
            this.myConfigFilesEditor = new JettyConfigFilesEditor(){

                @Override
                protected void activeFilesSetChanged() {
                    JettyPersistentDataEditor.this.saveIni();
                }

                @Override
                protected AnActionButtonRunnable createAddAction() {
                    return new AnActionButtonRunnable(){

                        public void run(AnActionButton button) {
                            DefaultActionGroup addGroup = new DefaultActionGroup(null, true);
                            addGroup.add(new AnAction(JettyBundle.getText("JettyPersistentDataEditor.add.file.action", new Object[0]), null, AllIcons.FileTypes.Any_type){

                                public void actionPerformed(AnActionEvent e) {
                                    this.addFile(false);
                                }
                            });
                            addGroup.add(new AnAction(JettyBundle.getText("JettyPersistentDataEditor.add.folder.action", new Object[0]), null, AllIcons.Nodes.Folder){

                                public void actionPerformed(AnActionEvent e) {
                                    this.addFile(true);
                                }
                            });
                            ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)addGroup, DataManager.getInstance().getDataContext((Component)button.getContextComponent()), JBPopupFactory.ActionSelectionAid.MNEMONICS, false);
                            listPopup.show(button.getPreferredPopupPoint());
                        }
                    };
                }
            };
        }
        this.myConfigFilesEditor.setConfigFileTypeDescriptor(this.getVersionHandler().getConfigFileTypeDescriptor());
        return this.myConfigFilesEditor;
    }

    private void saveIni() {
        Set<String> activePaths = JettyConfigFile.getActivePaths(this.getConfigFilesEditor().getFiles());
        JettyIniProducer iniProcessor = this.getVersionHandler().getIniProducer(this.getWorkDir(), activePaths);
        Collection<String> iniLines = iniProcessor.getProducedIniLines();
        try {
            FileUtil.writeToFile((File)iniProcessor.getIniFile(), (byte[])StringUtil.join((String[])ArrayUtil.toStringArray(iniLines), (String)"\n").getBytes());
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
    }

    private JettyVersionHandler getVersionHandler() {
        return JettyServerModel.getVersionHandler(this.getVersion());
    }

    private void toggleWarning(boolean enable) {
        this.myWarningLabel.setVisible(enable);
    }

    private void createUIComponents() {
        this.myConfigFilesPanel = this.getConfigFilesEditor().getMainPanel();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = this.myConfigFilesPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myWarningLabel = jBLabel = new JBLabel();
        jBLabel.setText("---");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

