/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.initializr.dependencies;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.spring.initializr.SpringInitializrOptions;
import com.intellij.spring.initializr.Version;
import com.intellij.spring.initializr.VersionRange;
import com.intellij.spring.initializr.dependencies.DependenciesTable;
import com.intellij.spring.initializr.dependencies.SelectedDependenciesPanel;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.jetbrains.annotations.NotNull;

class DependenciesStepPanel
extends JBSplitter {
    private final SpringInitializrOptions myOptions;
    private Version myCurrentSpringBootVersion;
    private final SearchDependenciesFilter mySearchDependenciesFilter = new SearchDependenciesFilter();
    private JBList<SpringInitializrOptions.MultiSelectGroup> myCategoriesList;
    private DependenciesTable myDependenciesTable;
    private SelectedDependenciesPanel mySelectedDependenciesPanel;

    DependenciesStepPanel(SpringInitializrOptions options) {
        super(false, 0.7f);
        this.myOptions = options;
        JPanel dependenciesPanel = new JPanel(new BorderLayout());
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        toolbarPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)4, (int)4, (int)0));
        toolbarPanel.add((Component)((Object)this.mySearchDependenciesFilter), "West");
        DefaultActionGroup group = new DefaultActionGroup();
        group.addAction((AnAction)new ChangeSpringBootVersionAction());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("SpringDependenciesStep", (ActionGroup)group, true);
        toolbar.updateActionsImmediately();
        toolbarPanel.add((Component)toolbar.getComponent(), "East");
        AnAction activateSearchAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)DependenciesStepPanel.this.mySearchDependenciesFilter.getTextEditor(), true));
            }
        };
        activateSearchAction.registerCustomShortcutSet(CommonShortcuts.getFind(), (JComponent)((Object)this));
        this.mySearchDependenciesFilter.getTextEditor().setToolTipText(KeymapUtil.createTooltipText((String)"Search in dependencies", (AnAction)activateSearchAction));
        dependenciesPanel.add((Component)toolbarPanel, "North");
        this.myDependenciesTable = new DependenciesTable();
        OnePixelSplitter depsSplitter = new OnePixelSplitter(false, 0.5f, 0.2f, 0.5f);
        this.myCategoriesList = new JBList(options.dependencies);
        this.myCategoriesList.setFixedCellHeight(JBUI.scale((int)22));
        ColoredListCellRenderer<SpringInitializrOptions.MultiSelectGroup> categoryRenderer = new ColoredListCellRenderer<SpringInitializrOptions.MultiSelectGroup>(){

            protected void customizeCellRenderer(@NotNull JList<? extends SpringInitializrOptions.MultiSelectGroup> list, SpringInitializrOptions.MultiSelectGroup value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/spring/initializr/dependencies/DependenciesStepPanel$2", "customizeCellRenderer"));
                }
                this.append(value.name);
                SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)DependenciesStepPanel.this.myCategoriesList, (SimpleColoredComponent)this, (boolean)true, (boolean)selected);
            }
        };
        this.myCategoriesList.setCellRenderer((ListCellRenderer)categoryRenderer);
        new ListSpeedSearch(this.myCategoriesList, entry -> ((SpringInitializrOptions.MultiSelectGroup)entry).name);
        this.myCategoriesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                SpringInitializrOptions.MultiSelectGroup selectedValue = (SpringInitializrOptions.MultiSelectGroup)DependenciesStepPanel.this.myCategoriesList.getSelectedValue();
                if (selectedValue == null) {
                    return;
                }
                DependenciesStepPanel.this.myDependenciesTable.setDependencies(DependenciesStepPanel.this.myCurrentSpringBootVersion, selectedValue.options, ((DependenciesStepPanel)DependenciesStepPanel.this).myOptions.selectedDependenciesIds);
                DependenciesStepPanel.this.myDependenciesTable.getModel().addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent e) {
                        DependenciesStepPanel.this.updateSelectedDependenciesPanel();
                    }
                });
            }
        });
        depsSplitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane(this.myCategoriesList, (boolean)true));
        OnePixelSplitter depsAndDescriptionSplitter = new OnePixelSplitter(true, 0.7f, 0.5f, 0.8f);
        depsAndDescriptionSplitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myDependenciesTable), (boolean)true));
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.setBackground(UIUtil.getListBackground());
        descriptionPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.setBackground(UIUtil.getListBackground());
        final JBLabel descriptionHeader = new JBLabel();
        descriptionHeader.setFont(UIUtil.getLabelFont().deriveFont(1));
        descriptionHeader.setBorder((Border)JBUI.Borders.empty((int)4, (int)0));
        MultiLineLabel descriptionVersion = new MultiLineLabel();
        descriptionVersion.setIcon(AllIcons.General.BalloonWarning);
        descriptionVersion.setBorder((Border)JBUI.Borders.empty((int)4, (int)0, (int)8, (int)0));
        descriptionVersion.setVisible(false);
        headerPanel.add((Component)descriptionHeader, "North");
        headerPanel.add((Component)descriptionVersion, "Center");
        descriptionPanel.add((Component)headerPanel, "North");
        JTextArea descriptionText = new JTextArea();
        descriptionText.setFocusable(false);
        descriptionText.setBackground(UIUtil.getListBackground());
        descriptionText.setLineWrap(true);
        descriptionText.setWrapStyleWord(true);
        descriptionText.setEditable(false);
        descriptionText.setFont((Font)JBUI.Fonts.smallFont());
        descriptionPanel.add((Component)descriptionText, "Center");
        JPanel linksPanel = new JPanel((LayoutManager)new VerticalLayout(JBUI.scale((int)4)));
        linksPanel.setBackground(UIUtil.getListBackground());
        linksPanel.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        descriptionPanel.add((Component)linksPanel, "South");
        this.myDependenciesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener((JLabel)descriptionVersion, descriptionText, linksPanel){
            final /* synthetic */ JLabel val$descriptionVersion;
            final /* synthetic */ JTextArea val$descriptionText;
            final /* synthetic */ JPanel val$linksPanel;
            {
                this.val$descriptionVersion = jLabel;
                this.val$descriptionText = jTextArea;
                this.val$linksPanel = jPanel;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                SpringInitializrOptions.Option value = DependenciesStepPanel.this.myDependenciesTable.getSelectedValue();
                if (value == null) {
                    descriptionHeader.setText("");
                    this.val$descriptionVersion.setVisible(false);
                    this.val$descriptionText.setText("");
                    this.val$linksPanel.removeAll();
                    return;
                }
                descriptionHeader.setText(value.display);
                this.val$descriptionVersion.setVisible(false);
                VersionRange range = (VersionRange)value.getUserData(SpringInitializrOptions.Option.VERSION_RANGE);
                if (range != null && !range.match(DependenciesStepPanel.this.myCurrentSpringBootVersion)) {
                    this.val$descriptionVersion.setText("Requires Spring Boot Version\n" + range.displayText());
                    this.val$descriptionVersion.setVisible(true);
                }
                this.val$descriptionText.setText(value.description);
                this.val$descriptionText.setCaretPosition(0);
                this.val$linksPanel.removeAll();
                Map links = (Map)value.getUserData(SpringInitializrOptions.Option.LINKS);
                if (links != null) {
                    links.forEach((linkKey, linkValues) -> {
                        String defaultTitle;
                        Icon icon;
                        if ("guide".equals(linkKey)) {
                            icon = AllIcons.Nodes.HomeFolder;
                            defaultTitle = "Guide";
                        } else if ("reference".equals(linkKey)) {
                            icon = AllIcons.Graph.PrintPreview;
                            defaultTitle = "Reference doc";
                        } else {
                            icon = AllIcons.Actions.Help;
                            defaultTitle = "Link";
                        }
                        for (Couple couple : linkValues) {
                            HyperlinkLabel linkLabel = new HyperlinkLabel(StringUtil.notNullize((String)((String)couple.second), (String)defaultTitle));
                            linkLabel.setIcon(icon);
                            linkLabel.setFont((Font)JBUI.Fonts.smallFont());
                            String parsedUrl = StringUtil.replace((String)((String)couple.first), (String)"{bootVersion}", (String)DependenciesStepPanel.this.myCurrentSpringBootVersion.displayText());
                            if (StringUtil.containsChar((String)parsedUrl, (char)'{')) continue;
                            linkLabel.setHyperlinkTarget(parsedUrl);
                            linkLabel.setToolTipText(parsedUrl);
                            this.val$linksPanel.add((Component)linkLabel);
                        }
                    });
                }
            }
        });
        depsAndDescriptionSplitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)descriptionPanel, (boolean)true));
        depsSplitter.setSecondComponent((JComponent)depsAndDescriptionSplitter);
        JPanel depsSplitterPanel = new JPanel(new BorderLayout());
        depsSplitterPanel.setBorder(JBUI.Borders.merge((Border)JBUI.Borders.customLine((Color)JBColor.border()), (Border)JBUI.Borders.empty((int)0, (int)4), (boolean)true));
        depsSplitterPanel.add((Component)depsSplitter, "Center");
        dependenciesPanel.add((Component)depsSplitterPanel, "Center");
        this.mySelectedDependenciesPanel = new SelectedDependenciesPanel(options.dependencies, new SelectedDependenciesPanel.MyActionListener(){

            @Override
            public void onDependencyDeleted(String dependencyId) {
                ((DependenciesStepPanel)DependenciesStepPanel.this).myOptions.selectedDependenciesIds.remove(dependencyId);
                DependenciesStepPanel.this.updateDependenciesTable();
                DependenciesStepPanel.this.updateSelectedDependenciesPanel();
            }

            @Override
            public void navigateCategory(String categoryName) {
                for (int i = 0; i < DependenciesStepPanel.this.myCategoriesList.getItemsCount(); ++i) {
                    if (!((SpringInitializrOptions.MultiSelectGroup)((DependenciesStepPanel)DependenciesStepPanel.this).myCategoriesList.getModel().getElementAt((int)i)).name.equals(categoryName)) continue;
                    DependenciesStepPanel.this.myCategoriesList.setSelectedIndex(i);
                    break;
                }
            }
        });
        this.setShowDividerIcon(false);
        this.setShowDividerControls(false);
        this.setDividerWidth(JBUI.scale((int)36));
        this.setFirstComponent(dependenciesPanel);
        this.setSecondComponent(this.mySelectedDependenciesPanel);
        dependenciesPanel.setMinimumSize(dependenciesPanel.getPreferredSize());
        this.onSpringBootVersionChanged((SpringInitializrOptions.Option)((Object)options.bootVersion.getSelected()));
        this.myCategoriesList.setSelectedIndex(0);
    }

    private void onSpringBootVersionChanged(SpringInitializrOptions.Option option) {
        this.myOptions.bootVersion.setSelectedItem((Object)option);
        this.myCurrentSpringBootVersion = Version.parse(option.id);
        int index = this.myCategoriesList.getSelectedIndex();
        this.myCategoriesList.clearSelection();
        this.myCategoriesList.setSelectedIndex(index);
        this.updateSelectedDependenciesPanel();
    }

    private void updateDependenciesTable() {
        this.myDependenciesTable.updateSelection(this.myOptions.selectedDependenciesIds);
    }

    private void updateSelectedDependenciesPanel() {
        this.mySelectedDependenciesPanel.updateSelection(this.myCurrentSpringBootVersion, this.myOptions.selectedDependenciesIds);
    }

    JComponent getPreferredFocusedComponent() {
        return this.myCategoriesList;
    }

    private class SearchDependenciesFilter
    extends SearchTextField {
        private final SimpleTextAttributes DESCRIPTION_TEXT_ATTRIBUTES;
        private final SimpleTextAttributes DESCRIPTION_TEXT_DISABLED_ATTRIBUTES;
        private final JBList<SpringInitializrOptions.Option> myList;
        private JBPopup mySearchResultsPopup;

        private SearchDependenciesFilter() {
            super(false);
            this.DESCRIPTION_TEXT_ATTRIBUTES = new SimpleTextAttributes(128, null);
            this.DESCRIPTION_TEXT_DISABLED_ATTRIBUTES = SimpleTextAttributes.merge((SimpleTextAttributes)this.DESCRIPTION_TEXT_ATTRIBUTES, (SimpleTextAttributes)SimpleTextAttributes.GRAYED_ATTRIBUTES);
            this.myList = new JBList();
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    SearchDependenciesFilter.this.filter();
                }
            });
            JLabel label = new JLabel("Dependencies");
            label.setFont(UIUtil.getLabelFont().deriveFont(1));
            label.setBorder((Border)JBUI.Borders.emptyRight((int)10));
            this.add(label, "West");
            ScrollingUtil.installActions(this.myList, (JComponent)this.getTextEditor());
            new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    SearchDependenciesFilter.this.mySearchResultsPopup.closeOk(e.getInputEvent());
                    SearchDependenciesFilter.this.handleSelection();
                }
            }.registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)this.getTextEditor());
        }

        protected void showPopup() {
        }

        private void filter() {
            String filterText = this.getText();
            if (filterText.trim().length() <= 1) {
                this.hideSearchResults();
                return;
            }
            MultiMap<Integer, SpringInitializrOptions.Option> matchingDegreeResultsMap = new MultiMap<Integer, SpringInitializrOptions.Option>(){

                @NotNull
                protected Map<Integer, Collection<SpringInitializrOptions.Option>> createMap() {
                    TreeMap<Integer, Collection<SpringInitializrOptions.Option>> treeMap = new TreeMap<Integer, Collection<SpringInitializrOptions.Option>>(Comparator.reverseOrder());
                    if (treeMap == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/initializr/dependencies/DependenciesStepPanel$SearchDependenciesFilter$3", "createMap"));
                    }
                    return treeMap;
                }
            };
            final MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + filterText)).build();
            for (SpringInitializrOptions.MultiSelectGroup dependency : ((DependenciesStepPanel)DependenciesStepPanel.this).myOptions.dependencies) {
                for (SpringInitializrOptions.Option option : dependency.options) {
                    if (!matcher.matches(option.display) && !matcher.matches(option.description)) continue;
                    matchingDegreeResultsMap.putValue((Object)(matcher.matchingDegree(option.display) * 2 + matcher.matchingDegree(option.description)), (Object)option);
                }
            }
            this.myList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<SpringInitializrOptions.Option>(){

                protected void customizeCellRenderer(@NotNull JList<? extends SpringInitializrOptions.Option> list, SpringInitializrOptions.Option value, int index, boolean selected, boolean hasFocus) {
                    if (list == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/spring/initializr/dependencies/DependenciesStepPanel$SearchDependenciesFilter$4", "customizeCellRenderer"));
                    }
                    boolean alreadySelectedDependency = ((DependenciesStepPanel)DependenciesStepPanel.this).myOptions.selectedDependenciesIds.contains(value.id);
                    boolean available = SearchDependenciesFilter.this.isDependencyAvailable(value);
                    SpeedSearchUtil.appendColoredFragmentForMatcher((String)(value.display + "   "), (SimpleColoredComponent)this, (SimpleTextAttributes)(alreadySelectedDependency ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : (available ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES)), (Matcher)matcher, (Color)UIUtil.getListBackground((boolean)selected), (boolean)true);
                    String shortenedDescription = StringUtil.shortenTextWithEllipsis((String)value.description, (int)100, (int)0);
                    SpeedSearchUtil.appendColoredFragmentForMatcher((String)shortenedDescription, (SimpleColoredComponent)this, (SimpleTextAttributes)(available ? SearchDependenciesFilter.this.DESCRIPTION_TEXT_ATTRIBUTES : SearchDependenciesFilter.this.DESCRIPTION_TEXT_DISABLED_ATTRIBUTES), (Matcher)matcher, (Color)UIUtil.getListBackground((boolean)selected), (boolean)true);
                }
            });
            ArrayList matches = new ArrayList(matchingDegreeResultsMap.values());
            this.myList.setModel((ListModel)new CollectionListModel(matches));
            this.myList.setSelectedIndex(0);
            if (this.mySearchResultsPopup == null || this.mySearchResultsPopup.isDisposed()) {
                this.mySearchResultsPopup = JBPopupFactory.getInstance().createListPopupBuilder(this.myList).setItemChoosenCallback(() -> this.handleSelection()).setAdText("<html>Click/" + KeymapUtil.getKeystrokeText((KeyStroke)KeymapUtil.getKeyStroke((ShortcutSet)CommonShortcuts.ENTER)) + " to select &ndash; <b>already selected dependencies</b></html>").setRequestFocus(false).createPopup();
            }
            this.mySearchResultsPopup.pack(true, true);
            if (!this.mySearchResultsPopup.isVisible()) {
                this.mySearchResultsPopup.showUnderneathOf((Component)this.getTextEditor());
            }
        }

        private void handleSelection() {
            SpringInitializrOptions.Option selectedValue = (SpringInitializrOptions.Option)((Object)this.myList.getSelectedValue());
            if (selectedValue == null) {
                return;
            }
            if (this.isDependencyAvailable(selectedValue)) {
                ((DependenciesStepPanel)DependenciesStepPanel.this).myOptions.selectedDependenciesIds.add(selectedValue.id);
                DependenciesStepPanel.this.updateDependenciesTable();
                DependenciesStepPanel.this.updateSelectedDependenciesPanel();
                this.setText("");
            } else {
                this.showNotAvailableNotification(selectedValue);
            }
        }

        private void showNotAvailableNotification(SpringInitializrOptions.Option selectedValue) {
            for (SpringInitializrOptions.MultiSelectGroup dependency : ((DependenciesStepPanel)DependenciesStepPanel.this).myOptions.dependencies) {
                for (SpringInitializrOptions.Option option : dependency.options) {
                    if (!option.id.equals(selectedValue.id)) continue;
                    JComponent message = HintUtil.createErrorLabel((String)("Dependency " + selectedValue.display + " [" + dependency.name + "] is not available"));
                    BalloonBuilder builder = JBPopupFactory.getInstance().createBalloonBuilder(message);
                    builder.setRequestFocus(false).setFadeoutTime(3000L).setFillColor(HintUtil.getErrorColor()).createBalloon().showInCenterOf((JComponent)this.getTextEditor());
                    return;
                }
            }
        }

        private void hideSearchResults() {
            if (this.mySearchResultsPopup != null) {
                this.mySearchResultsPopup.cancel();
            }
        }

        private boolean isDependencyAvailable(@NotNull SpringInitializrOptions.Option value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/spring/initializr/dependencies/DependenciesStepPanel$SearchDependenciesFilter", "isDependencyAvailable"));
            }
            VersionRange versionRange = (VersionRange)value.getUserData(SpringInitializrOptions.Option.VERSION_RANGE);
            return versionRange == null || versionRange.match(DependenciesStepPanel.this.myCurrentSpringBootVersion);
        }
    }

    private class ChangeSpringBootVersionAction
    extends ComboBoxAction
    implements DumbAware {
        private ChangeSpringBootVersionAction() {
        }

        public JComponent createCustomComponent(Presentation presentation) {
            JComponent component = super.createCustomComponent(presentation);
            JPanel panel = new JPanel(new BorderLayout());
            panel.setOpaque(false);
            panel.add((Component)component, "Center");
            panel.add((Component)new JLabel("Spring Boot"), "West");
            return panel;
        }

        public void update(AnActionEvent e) {
            SpringInitializrOptions.Option selectedVersion = (SpringInitializrOptions.Option)((Object)((DependenciesStepPanel)DependenciesStepPanel.this).myOptions.bootVersion.getSelected());
            if (selectedVersion == null) {
                return;
            }
            Presentation presentation = e.getPresentation();
            presentation.setText(selectedVersion.display);
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            DefaultActionGroup versionGroup = new DefaultActionGroup();
            final SpringInitializrOptions.Option selected = (SpringInitializrOptions.Option)((Object)((DependenciesStepPanel)DependenciesStepPanel.this).myOptions.bootVersion.getSelected());
            for (final SpringInitializrOptions.Option option : ((DependenciesStepPanel)DependenciesStepPanel.this).myOptions.bootVersion.getItems()) {
                versionGroup.add((AnAction)new ToggleAction(option.display){

                    public boolean isDumbAware() {
                        return true;
                    }

                    public boolean isSelected(AnActionEvent e) {
                        return ((Object)((Object)option)).equals((Object)selected);
                    }

                    public void setSelected(AnActionEvent e, boolean state) {
                        DependenciesStepPanel.this.onSpringBootVersionChanged(option);
                    }
                });
            }
            DefaultActionGroup defaultActionGroup = versionGroup;
            if (defaultActionGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/initializr/dependencies/DependenciesStepPanel$ChangeSpringBootVersionAction", "createPopupActionGroup"));
            }
            return defaultActionGroup;
        }
    }
}

