/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.annotators;

import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class DomElementListCellRenderer<T extends DomElement>
extends PsiElementListCellRenderer<XmlTag> {
    private final String unknownElementText;

    protected DomElementListCellRenderer(@Nls String unknownElementText) {
        this.unknownElementText = unknownElementText;
    }

    @NotNull
    @NonNls
    public abstract String getAdditionalLocation(T var1);

    public String getElementText(XmlTag element) {
        T domElement = this.getDomElement(element);
        if (domElement == null) {
            return element.getName();
        }
        String elementName = domElement.getPresentation().getElementName();
        return elementName == null ? this.unknownElementText : elementName;
    }

    protected String getContainerText(XmlTag element, String name) {
        String containingFile = " (" + element.getContainingFile().getName() + ')';
        T domElement = this.getDomElement(element);
        if (domElement == null) {
            return containingFile;
        }
        return this.getAdditionalLocation(domElement) + containingFile;
    }

    protected int getIconFlags() {
        return 0;
    }

    protected Icon getIcon(PsiElement element) {
        Icon icon;
        T domElement = this.getDomElement((XmlTag)element);
        if (domElement != null && (icon = domElement.getPresentation().getIcon()) != null) {
            return icon;
        }
        return super.getIcon(element);
    }

    @Nullable
    private T getDomElement(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/struts2/annotators/DomElementListCellRenderer", "getDomElement"));
        }
        return (T)DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
    }
}

