/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.jsp.inspection;

import com.intellij.codeInsight.completion.ExtendedTagInsertHandler;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts2.StrutsBundle;
import com.intellij.struts2.facet.StrutsFacet;
import com.intellij.struts2.model.constant.StrutsConstantHelper;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlNamespaceHelper;
import java.net.URL;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HardcodedActionUrlInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/struts2/jsp/inspection/HardcodedActionUrlInspection", "buildVisitor"));
        }
        final boolean isJspFileWithStrutsSupport = JspPsiUtil.getJspFile((PsiElement)holder.getFile()) != null && StrutsFacet.getInstance((PsiElement)holder.getFile()) != null;
        final String actionExtension = isJspFileWithStrutsSupport ? (String)ContainerUtil.getFirstItem(StrutsConstantHelper.getActionExtensions((PsiElement)holder.getFile())) : null;
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlAttributeValue(XmlAttributeValue value) {
                if (!isJspFileWithStrutsSupport || actionExtension == null) {
                    return;
                }
                XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)value, XmlTag.class);
                if (tag == null) {
                    return;
                }
                URL parsedURL = HardcodedActionUrlInspection.parseURL(value, actionExtension);
                if (parsedURL == null) {
                    return;
                }
                if (HardcodedActionUrlInspection.buildTag("", parsedURL, "", false, actionExtension) == null) {
                    return;
                }
                TextRange range = ElementManipulators.getValueTextRange((PsiElement)value);
                holder.registerProblem((PsiElement)value, range, "Use Struts <url> tag instead of hardcoded URL", new LocalQuickFix[]{new WrapWithSUrl(actionExtension)});
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/jsp/inspection/HardcodedActionUrlInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }

    @NotNull
    public String[] getGroupPath() {
        String[] stringArray = new String[]{StrutsBundle.message("inspections.group.path.name", new Object[0]), this.getGroupDisplayName()};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/jsp/inspection/HardcodedActionUrlInspection", "getGroupPath"));
        }
        return stringArray;
    }

    private static Pair<String, String> buildTag(String prefix, URL url, String indent, boolean inline, String actionExtension) {
        String query;
        String var;
        String path = url.getPath();
        int slash = path.lastIndexOf(47);
        String namespace = slash > 0 ? path.substring(0, slash) : null;
        String action = slash != -1 ? path.substring(slash + 1) : path;
        action = StringUtil.trimEnd((String)action, (String)actionExtension);
        int exclamationIdx = action.indexOf(33);
        String method = null;
        if (exclamationIdx > 0) {
            method = action.substring(exclamationIdx + 1);
            action = action.substring(0, exclamationIdx);
        }
        StringBuilder sb = new StringBuilder();
        sb.append('<').append(prefix).append(":url");
        if (inline) {
            var = null;
        } else {
            var = action + "_url";
            sb.append(" var=\"").append(var).append("\"");
        }
        if (namespace != null) {
            sb.append(" namespace=\"").append(namespace).append("\"");
        }
        sb.append(" action=\"").append(action).append("\"");
        if (method != null) {
            sb.append(" method=\"").append(method).append("\"");
        }
        if (StringUtil.isEmpty((String)(query = url.getQuery()))) {
            sb.append("/>");
        } else {
            sb.append(">");
            for (String escapedArg : StringUtil.split((String)query, (String)"&amp;")) {
                for (String arg : StringUtil.split((String)escapedArg, (String)"&")) {
                    String value;
                    int eq = arg.indexOf(61);
                    String name = eq > 0 ? arg.substring(0, eq) : arg;
                    String string = value = eq > 0 ? arg.substring(eq + 1) : "";
                    if (name.contains("[") || name.contains("$")) {
                        return null;
                    }
                    sb.append("\n").append(indent).append("  <").append(prefix).append(":param name=\"").append(name).append("\">").append(value).append("</").append(prefix).append(":param>");
                }
            }
            sb.append('\n').append(indent);
            sb.append("</").append(prefix).append(":url>");
        }
        return Pair.create((Object)sb.toString(), (Object)var);
    }

    @Nullable
    private static URL parseURL(XmlAttributeValue value, String actionExtension) {
        URL parsedURL;
        String rawUrl = value.getValue();
        if (rawUrl.startsWith("http://") || rawUrl.startsWith("https://")) {
            return null;
        }
        try {
            parsedURL = new URL("http://" + rawUrl);
        }
        catch (Exception e) {
            return null;
        }
        String host = parsedURL.getHost();
        if (!(StringUtil.isEmpty((String)host) || host.startsWith("${") && host.endsWith("}"))) {
            return null;
        }
        String path = parsedURL.getPath();
        if (!path.endsWith(actionExtension)) {
            return null;
        }
        if (path.contains("${")) {
            return null;
        }
        return parsedURL;
    }

    private static class WrapWithSUrl
    implements LocalQuickFix {
        private final String myActionExtension;

        private WrapWithSUrl(String actionExtension) {
            this.myActionExtension = actionExtension;
        }

        @NotNull
        public String getFamilyName() {
            if ("Wrap with Struts <url> tag" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/jsp/inspection/HardcodedActionUrlInspection$WrapWithSUrl", "getFamilyName"));
            }
            return "Wrap with Struts <url> tag";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/struts2/jsp/inspection/HardcodedActionUrlInspection$WrapWithSUrl", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/struts2/jsp/inspection/HardcodedActionUrlInspection$WrapWithSUrl", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof XmlAttributeValue) {
                final XmlAttributeValue value = (XmlAttributeValue)element;
                XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)value, XmlTag.class, (boolean)false);
                final boolean inline = tag instanceof HtmlTag;
                final URL url = HardcodedActionUrlInspection.parseURL(value, this.myActionExtension);
                if (url == null) {
                    return;
                }
                JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)value);
                assert (jspFile != null);
                XmlTag rootTag = jspFile.getRootTag();
                String prefix = rootTag.getPrefixByNamespace("/struts-tags");
                if (StringUtil.isEmpty((String)prefix)) {
                    XmlNamespaceHelper extension = XmlNamespaceHelper.getHelper((PsiFile)jspFile);
                    prefix = ExtendedTagInsertHandler.suggestPrefix((XmlFile)jspFile, (String)"/struts-tags");
                    XmlNamespaceHelper.Runner<String, IncorrectOperationException> after = new XmlNamespaceHelper.Runner<String, IncorrectOperationException>(){

                        public void run(String param) throws IncorrectOperationException {
                            this.wrapValue(param, value, url, inline);
                        }
                    };
                    extension.insertNamespaceDeclaration((XmlFile)jspFile, null, Collections.singleton("/struts-tags"), prefix, (XmlNamespaceHelper.Runner)after);
                } else {
                    this.wrapValue(prefix, value, url, inline);
                }
            }
        }

        private void wrapValue(String prefix, XmlAttributeValue value, URL url, boolean inline) {
            int formattingEnd;
            int formattingStart;
            JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)value);
            assert (jspFile != null);
            Project project = jspFile.getProject();
            TextRange range = value.getValueTextRange();
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)jspFile);
            assert (document != null);
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
            int start = range.getStartOffset();
            int lineStart = document.getLineStartOffset(document.getLineNumber(start));
            String linePrefix = document.getCharsSequence().subSequence(lineStart, start).toString();
            String indent = linePrefix = linePrefix.substring(0, linePrefix.length() - linePrefix.trim().length());
            while (indent.length() < start - lineStart) {
                indent = indent + " ";
            }
            Pair tag_var = HardcodedActionUrlInspection.buildTag(prefix, url, indent, inline, this.myActionExtension);
            String tag = (String)tag_var.getFirst();
            String var = (String)tag_var.getSecond();
            int end = range.getEndOffset();
            if (inline) {
                document.replaceString(start, end, (CharSequence)tag);
                formattingStart = start;
                formattingEnd = start + tag.length();
            } else {
                document.replaceString(start, end, (CharSequence)("${" + var + "}"));
                XmlTag containingTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)value, XmlTag.class, (boolean)false);
                assert (containingTag != null);
                int startOffset = containingTag.getTextRange().getStartOffset();
                document.insertString(startOffset, (CharSequence)"\n");
                document.insertString(startOffset, (CharSequence)tag);
                formattingStart = startOffset;
                formattingEnd = startOffset + tag.length() + 2;
            }
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            CodeStyleManager.getInstance((Project)project).reformatText((PsiFile)jspFile, formattingStart, formattingEnd);
        }
    }
}

