/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.structure;

import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts2.structure.BaseStructureViewBuilderProvider;
import com.intellij.struts2.structure.StrutsTreeDescriptionLocation;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomElementsNavigationManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import com.intellij.util.xml.structure.DomStructureTreeElement;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StructureViewTreeElement
extends DomStructureTreeElement
implements ColoredItemPresentation {
    StructureViewTreeElement(@NotNull DomElement domElement) {
        if (domElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "com/intellij/struts2/structure/StructureViewTreeElement", "<init>"));
        }
        super(domElement, BaseStructureViewBuilderProvider.ALWAYS_SHOW, DomElementsNavigationManager.getManager((Project)DomUtil.getFile((DomElement)domElement).getProject()).getDomElementsNavigateProvider(DomElementsNavigationManager.DEFAULT_PROVIDER_NAME));
    }

    @Nullable
    public TextAttributesKey getTextAttributesKey() {
        DomElement element = this.getElement();
        if (!element.isValid()) {
            return null;
        }
        XmlTag tag = element.getXmlTag();
        if (tag == null) {
            return null;
        }
        DomElementsProblemsHolder holder = DomElementAnnotationsManager.getInstance((Project)tag.getProject()).getCachedProblemHolder(element);
        List problems = holder.getProblems(element, true, HighlightSeverity.ERROR);
        if (!problems.isEmpty()) {
            return CodeInsightColors.ERRORS_ATTRIBUTES;
        }
        return null;
    }

    @NotNull
    public TreeElement[] getChildren() {
        DomElement element = this.getElement();
        if (!element.isValid()) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/structure/StructureViewTreeElement", "getChildren"));
            }
            return EMPTY_ARRAY;
        }
        SmartList result = new SmartList();
        DomUtil.acceptAvailableChildren((DomElement)element, (DomElementVisitor)new DomElementVisitor((List)result){
            final /* synthetic */ List val$result;
            {
                this.val$result = list;
            }

            public void visitDomElement(DomElement domElement) {
                this.val$result.add(new StructureViewTreeElement(domElement));
            }
        });
        TreeElement[] treeElementArray = (TreeElement[])ArrayUtil.toObjectArray((Collection)result, TreeElement.class);
        if (treeElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/structure/StructureViewTreeElement", "getChildren"));
        }
        return treeElementArray;
    }

    @Nullable
    public String getLocationString() {
        XmlElement xmlElement = this.getElement().getXmlElement();
        assert (xmlElement != null) : this.getElement();
        return ElementDescriptionUtil.getElementDescription((PsiElement)xmlElement, (ElementDescriptionLocation)StrutsTreeDescriptionLocation.INSTANCE);
    }
}

