/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.steps;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.oro.text.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.BDDFrameworkType;
import org.jetbrains.plugins.cucumber.CucumberJvmExtensionPoint;
import org.jetbrains.plugins.cucumber.OptionalStepDefinitionExtensionPoint;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;

public class CucumberStepsIndex {
    private static final Logger LOG = Logger.getInstance((String)CucumberStepsIndex.class.getName());
    private final Map<BDDFrameworkType, CucumberJvmExtensionPoint> myExtensionMap = new HashMap();
    private final Map<CucumberJvmExtensionPoint, Object> myExtensionData = new HashMap();
    private Project myProject;

    public static CucumberStepsIndex getInstance(Project project) {
        CucumberStepsIndex result = (CucumberStepsIndex)ServiceManager.getService((Project)project, CucumberStepsIndex.class);
        result.myProject = project;
        return result;
    }

    public CucumberStepsIndex(Project project) {
        for (CucumberJvmExtensionPoint e : (CucumberJvmExtensionPoint[])Extensions.getExtensions(CucumberJvmExtensionPoint.EP_NAME)) {
            this.myExtensionMap.put(e.getStepFileType(), e);
            this.myExtensionData.put(e, e.getDataObject(project));
        }
    }

    public Object getExtensionDataObject(CucumberJvmExtensionPoint e) {
        return this.myExtensionData.get(e);
    }

    public PsiFile createStepDefinitionFile(@NotNull PsiDirectory dir, @NotNull String fileNameWithoutExtension, @NotNull BDDFrameworkType frameworkType) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/plugins/cucumber/steps/CucumberStepsIndex", "createStepDefinitionFile"));
        }
        if (fileNameWithoutExtension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNameWithoutExtension", "org/jetbrains/plugins/cucumber/steps/CucumberStepsIndex", "createStepDefinitionFile"));
        }
        if (frameworkType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameworkType", "org/jetbrains/plugins/cucumber/steps/CucumberStepsIndex", "createStepDefinitionFile"));
        }
        CucumberJvmExtensionPoint ep = this.myExtensionMap.get(frameworkType);
        if (ep == null) {
            LOG.error(String.format("Unsupported step definition file type %s", frameworkType.toString()));
            return null;
        }
        return ep.getStepDefinitionCreator().createStepDefinitionContainer(dir, fileNameWithoutExtension);
    }

    public boolean validateNewStepDefinitionFileName(@NotNull PsiDirectory directory, @NotNull String fileName, @NotNull BDDFrameworkType frameworkType) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/plugins/cucumber/steps/CucumberStepsIndex", "validateNewStepDefinitionFileName"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/plugins/cucumber/steps/CucumberStepsIndex", "validateNewStepDefinitionFileName"));
        }
        if (frameworkType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameworkType", "org/jetbrains/plugins/cucumber/steps/CucumberStepsIndex", "validateNewStepDefinitionFileName"));
        }
        CucumberJvmExtensionPoint ep = this.myExtensionMap.get(frameworkType);
        assert (ep != null);
        return ep.getStepDefinitionCreator().validateNewStepDefinitionFileName(directory.getProject(), fileName);
    }

    @Nullable
    public AbstractStepDefinition findStepDefinition(@NotNull PsiFile featureFile, @NotNull GherkinStep step) {
        if (featureFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "featureFile", "org/jetbrains/plugins/cucumber/steps/CucumberStepsIndex", "findStepDefinition"));
        }
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "org/jetbrains/plugins/cucumber/steps/CucumberStepsIndex", "findStepDefinition"));
        }
        Collection<AbstractStepDefinition> definitions = this.findStepDefinitions(featureFile, step);
        return definitions.isEmpty() ? null : definitions.iterator().next();
    }

    @NotNull
    public Collection<AbstractStepDefinition> findStepDefinitions(@NotNull PsiFile featureFile, @NotNull GherkinStep step) {
        if (featureFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "featureFile", "org/jetbrains/plugins/cucumber/steps/CucumberStepsIndex", "findStepDefinitions"));
        }
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "org/jetbrains/plugins/cucumber/steps/CucumberStepsIndex", "findStepDefinitions"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)featureFile);
        if (module == null) {
            List<AbstractStepDefinition> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/steps/CucumberStepsIndex", "findStepDefinitions"));
            }
            return list;
        }
        java.util.HashMap definitionsByClass = new java.util.HashMap();
        List<AbstractStepDefinition> allSteps = this.loadStepsFor(featureFile, module);
        for (AbstractStepDefinition stepDefinition : allSteps) {
            int newPatternLength;
            if (!stepDefinition.matches(step.getSubstitutedName()) || !stepDefinition.supportsStep(step)) continue;
            Pattern currentLongestPattern = CucumberStepsIndex.getPatternByDefinition((AbstractStepDefinition)definitionsByClass.get(stepDefinition.getClass()));
            Pattern newPattern = CucumberStepsIndex.getPatternByDefinition(stepDefinition);
            int n = newPatternLength = newPattern != null ? newPattern.getPattern().length() : -1;
            if (currentLongestPattern != null && currentLongestPattern.getPattern().length() >= newPatternLength) continue;
            definitionsByClass.put(stepDefinition.getClass(), stepDefinition);
        }
        Collection<AbstractStepDefinition> collection = definitionsByClass.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/steps/CucumberStepsIndex", "findStepDefinitions"));
        }
        return collection;
    }

    @Nullable
    private static Pattern getPatternByDefinition(@Nullable AbstractStepDefinition definition) {
        if (definition == null) {
            return null;
        }
        return definition.getPattern();
    }

    public List<AbstractStepDefinition> findStepDefinitionsByPattern(@NotNull String pattern, @NotNull Module module) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "org/jetbrains/plugins/cucumber/steps/CucumberStepsIndex", "findStepDefinitionsByPattern"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/cucumber/steps/CucumberStepsIndex", "findStepDefinitionsByPattern"));
        }
        List<AbstractStepDefinition> allSteps = this.loadStepsFor(null, module);
        ArrayList<AbstractStepDefinition> result = new ArrayList<AbstractStepDefinition>();
        for (AbstractStepDefinition stepDefinition : allSteps) {
            String elementText = stepDefinition.getCucumberRegex();
            if (elementText == null || !elementText.equals(pattern)) continue;
            result.add(stepDefinition);
        }
        return result;
    }

    public List<AbstractStepDefinition> getAllStepDefinitions(@NotNull PsiFile featureFile) {
        if (featureFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "featureFile", "org/jetbrains/plugins/cucumber/steps/CucumberStepsIndex", "getAllStepDefinitions"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)featureFile);
        if (module == null) {
            return Collections.emptyList();
        }
        return this.loadStepsFor(featureFile, module);
    }

    @NotNull
    public List<PsiFile> gatherStepDefinitionsFilesFromDirectory(@NotNull PsiDirectory dir, boolean writableOnly) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/plugins/cucumber/steps/CucumberStepsIndex", "gatherStepDefinitionsFilesFromDirectory"));
        }
        ArrayList<PsiFile> result = new ArrayList<PsiFile>();
        for (PsiFile psiFile : dir.getFiles()) {
            boolean isStepFile;
            VirtualFile virtualFile = psiFile.getVirtualFile();
            boolean bl = isStepFile = writableOnly ? this.isWritableStepLikeFile((PsiElement)psiFile, (PsiElement)psiFile.getParent()) : this.isStepLikeFile((PsiElement)psiFile, (PsiElement)psiFile.getParent());
            if (!isStepFile || virtualFile == null) continue;
            result.add(psiFile);
        }
        for (PsiFile psiFile : dir.getSubdirectories()) {
            result.addAll(this.gatherStepDefinitionsFilesFromDirectory((PsiDirectory)psiFile, writableOnly));
        }
        ArrayList<PsiFile> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/steps/CucumberStepsIndex", "gatherStepDefinitionsFilesFromDirectory"));
        }
        return arrayList;
    }

    private List<AbstractStepDefinition> loadStepsFor(@Nullable PsiFile featureFile, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/cucumber/steps/CucumberStepsIndex", "loadStepsFor"));
        }
        ArrayList<AbstractStepDefinition> result = new ArrayList<AbstractStepDefinition>();
        for (CucumberJvmExtensionPoint extension : this.myExtensionMap.values()) {
            result.addAll(extension.loadStepsFor(featureFile, module));
        }
        return result;
    }

    public Set<Pair<PsiFile, BDDFrameworkType>> getStepDefinitionContainers(@NotNull GherkinFile featureFile) {
        if (featureFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "featureFile", "org/jetbrains/plugins/cucumber/steps/CucumberStepsIndex", "getStepDefinitionContainers"));
        }
        HashSet<Pair<PsiFile, BDDFrameworkType>> result = new HashSet<Pair<PsiFile, BDDFrameworkType>>();
        for (CucumberJvmExtensionPoint ep : this.myExtensionMap.values()) {
            if (ep instanceof OptionalStepDefinitionExtensionPoint && !((OptionalStepDefinitionExtensionPoint)ep).participateInStepDefinitionCreation((PsiElement)featureFile)) continue;
            Collection<? extends PsiFile> psiFiles = ep.getStepDefinitionContainers(featureFile);
            BDDFrameworkType frameworkType = ep.getStepFileType();
            for (PsiFile psiFile : psiFiles) {
                result.add((Pair<PsiFile, BDDFrameworkType>)Pair.create((Object)psiFile, (Object)frameworkType));
            }
        }
        return result;
    }

    public void reset() {
        for (CucumberJvmExtensionPoint e : this.myExtensionMap.values()) {
            e.reset(this.myProject);
        }
    }

    public void flush() {
        for (CucumberJvmExtensionPoint e : this.myExtensionMap.values()) {
            e.flush(this.myProject);
        }
    }

    public Map<BDDFrameworkType, CucumberJvmExtensionPoint> getExtensionMap() {
        return this.myExtensionMap;
    }

    public int getExtensionCount() {
        return this.myExtensionMap.size();
    }

    private boolean isStepLikeFile(PsiElement child, PsiElement parent) {
        if (child instanceof PsiFile) {
            PsiFile file = (PsiFile)child;
            CucumberJvmExtensionPoint ep = this.myExtensionMap.get(new BDDFrameworkType(file.getFileType()));
            return ep != null && ep.isStepLikeFile((PsiElement)file, parent);
        }
        return false;
    }

    private boolean isWritableStepLikeFile(PsiElement child, PsiElement parent) {
        if (child instanceof PsiFile) {
            PsiFile file = (PsiFile)child;
            CucumberJvmExtensionPoint ep = this.myExtensionMap.get(new BDDFrameworkType(file.getFileType()));
            return ep != null && ep.isWritableStepLikeFile((PsiElement)file, parent);
        }
        return false;
    }
}

