/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MetaConfigKeyReference
extends PsiReferenceBase.Poly<PsiElement> {
    private final NotNullLazyValue<List<SpringBootApplicationMetaConfigKey>> myKeys;

    protected MetaConfigKeyReference(PsiElement element, final String keyText) {
        super(element);
        this.myKeys = new AtomicNotNullLazyValue<List<SpringBootApplicationMetaConfigKey>>(){

            @NotNull
            protected List<SpringBootApplicationMetaConfigKey> compute() {
                List<SpringBootApplicationMetaConfigKey> list = MetaConfigKeyReference.this.getAllKeys(keyText);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/MetaConfigKeyReference$1", "compute"));
                }
                return list;
            }
        };
    }

    @NotNull
    protected List<SpringBootApplicationMetaConfigKey> getAllKeys(String keyText) {
        List<SpringBootApplicationMetaConfigKey> list = SpringBootApplicationMetaConfigKeyManager.getInstance().findAllApplicationMetaConfigKeys(this.getElement(), keyText);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/MetaConfigKeyReference", "getAllKeys"));
        }
        return list;
    }

    public FakePsiElement createNavigationElement() {
        return new MyNavigationFakeElement(this);
    }

    @Nullable
    public static SpringBootApplicationMetaConfigKey getResolvedMetaConfigKey(@NotNull PsiElement keyElement) {
        if (keyElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyElement", "com/intellij/spring/boot/application/metadata/MetaConfigKeyReference", "getResolvedMetaConfigKey"));
        }
        for (PsiReference reference : keyElement.getReferences()) {
            if (!(reference instanceof MetaConfigKeyReference)) continue;
            return ((MetaConfigKeyReference)reference).getResolvedKey();
        }
        return null;
    }

    @NotNull
    public abstract String getReferenceDisplayText();

    @Nullable
    protected SpringBootApplicationMetaConfigKey getResolvedKey() {
        return (SpringBootApplicationMetaConfigKey)ContainerUtil.getFirstItem((List)((List)this.myKeys.getValue()));
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)ContainerUtil.map((Collection)((Collection)this.myKeys.getValue()), SpringBootApplicationMetaConfigKey::getDeclaration));
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/MetaConfigKeyReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this.getElement();
    }

    private static class MyNavigationFakeElement
    extends FakePsiElement {
        private final PsiElement myElement;
        private final MetaConfigKeyReference myReference;

        private MyNavigationFakeElement(MetaConfigKeyReference reference) {
            this.myReference = reference;
            this.myElement = reference.getElement();
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = this.myElement;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/MetaConfigKeyReference$MyNavigationFakeElement", "getNavigationElement"));
            }
            return psiElement;
        }

        @Nullable
        public Icon getIcon(boolean open) {
            return MyNavigationFakeElement.getListItemIcon(this.myElement);
        }

        @NotNull
        public ItemPresentation getPresentation() {
            PresentationData presentationData = new PresentationData(this.myReference.getReferenceDisplayText(), "(" + SymbolPresentationUtil.getFilePathPresentation((PsiFile)this.myElement.getContainingFile()) + ")", MyNavigationFakeElement.getListItemIcon(this.myElement), null);
            if (presentationData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/MetaConfigKeyReference$MyNavigationFakeElement", "getPresentation"));
            }
            return presentationData;
        }

        public PsiElement getParent() {
            return this.myElement;
        }

        private static Icon getListItemIcon(PsiElement navigationItem) {
            return navigationItem.getContainingFile().getIcon(0);
        }
    }
}

