/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.jam;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.boot.model.autoconfigure.jam.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.jam.ConditionalOnProperty;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/spring/boot/model/autoconfigure/jam/ConditionalOnPropertyEvaluator;", "", "myConditionalOnProperty", "Lcom/intellij/spring/boot/model/autoconfigure/jam/ConditionalOnProperty;", "myContext", "Lcom/intellij/spring/boot/model/autoconfigure/jam/ConditionalOnEvaluationContext;", "(Lcom/intellij/spring/boot/model/autoconfigure/jam/ConditionalOnProperty;Lcom/intellij/spring/boot/model/autoconfigure/jam/ConditionalOnEvaluationContext;)V", "matches", "", "valueMatches", "configurationValue", "", "spring-boot-api"})
public final class ConditionalOnPropertyEvaluator {
    private final ConditionalOnProperty myConditionalOnProperty;
    private final ConditionalOnEvaluationContext myContext;

    public final boolean matches() {
        Module module = this.myContext.getModule();
        List<SpringBootApplicationMetaConfigKey> keys = this.myConditionalOnProperty.getResolvedMetaConfigKeys(module);
        if (keys.isEmpty()) {
            return false;
        }
        int keysCount = keys.size();
        boolean isMatchIfMissing = this.myConditionalOnProperty.isMatchIfMissing();
        boolean isRelaxedNames = this.myConditionalOnProperty.isRelaxedNames();
        Set<String> activeProfiles = this.myContext.getActiveProfiles();
        boolean hasChosenProfiles = !UtilKt.isNullOrEmpty((Collection)activeProfiles);
        int foundKeys = 0;
        int foundKeysWithMatchingValue = 0;
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        SpringBootModelConfigFileContributor[] springBootModelConfigFileContributorArray = (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions();
        block0: for (int i = 0; i < springBootModelConfigFileContributorArray.length; ++i) {
            SpringBootModelConfigFileContributor contributor = springBootModelConfigFileContributorArray[i];
            for (VirtualFile file : contributor.getUserConfigurationFiles(module, false)) {
                if (psiManager.findFile(file) == null) {
                    continue;
                }
                for (SpringBootApplicationMetaConfigKey key : keys) {
                    PsiFile configFile;
                    SpringBootModelConfigFileContributor.ConfigurationValueResult configurationValue = contributor.findConfigurationValue(configFile, key, isRelaxedNames, activeProfiles);
                    if (configurationValue == null) continue;
                    ++foundKeys;
                    if (!this.valueMatches(configurationValue.valueText)) continue;
                    if (keysCount == 1) {
                        return true;
                    }
                    ++foundKeysWithMatchingValue;
                }
                if (hasChosenProfiles) continue;
                break block0;
            }
        }
        if (isMatchIfMissing) {
            return foundKeys == 0;
        }
        return keysCount == foundKeysWithMatchingValue;
    }

    private final boolean valueMatches(String configurationValue) {
        String string = this.myConditionalOnProperty.getHavingValue();
        if (string == null) {
            return !StringsKt.equals((String)"false", (String)configurationValue, (boolean)true);
        }
        String havingValue = string;
        return StringsKt.equals((String)havingValue, (String)configurationValue, (boolean)true);
    }

    public ConditionalOnPropertyEvaluator(@NotNull ConditionalOnProperty myConditionalOnProperty, @NotNull ConditionalOnEvaluationContext myContext) {
        Intrinsics.checkParameterIsNotNull((Object)myConditionalOnProperty, (String)"myConditionalOnProperty");
        Intrinsics.checkParameterIsNotNull((Object)myContext, (String)"myContext");
        this.myConditionalOnProperty = myConditionalOnProperty;
        this.myContext = myContext;
    }
}

