/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.webdav.observation;

import hidden.org.apache.jackrabbit.webdav.DavConstants;
import hidden.org.apache.jackrabbit.webdav.observation.ObservationConstants;
import hidden.org.apache.jackrabbit.webdav.observation.Subscription;
import hidden.org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import hidden.org.apache.jackrabbit.webdav.xml.DomUtil;
import hidden.org.apache.jackrabbit.webdav.xml.ElementIterator;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SubscriptionDiscovery
extends AbstractDavProperty {
    private final Subscription[] subscriptions;

    public SubscriptionDiscovery(Subscription[] subscriptions) {
        super(ObservationConstants.SUBSCRIPTIONDISCOVERY, true);
        this.subscriptions = subscriptions != null ? subscriptions : new Subscription[0];
    }

    public SubscriptionDiscovery(Subscription subscription) {
        super(ObservationConstants.SUBSCRIPTIONDISCOVERY, true);
        this.subscriptions = subscription != null ? new Subscription[]{subscription} : new Subscription[0];
    }

    public Object getValue() {
        return this.subscriptions;
    }

    public Element toXml(Document document) {
        Element elem = this.getName().toXml(document);
        for (int i = 0; i < this.subscriptions.length; ++i) {
            elem.appendChild(this.subscriptions[i].toXml(document));
        }
        return elem;
    }

    public static SubscriptionDiscovery createFromXml(Element sDiscoveryElement) {
        if (!DomUtil.matches(sDiscoveryElement, ObservationConstants.SUBSCRIPTIONDISCOVERY.getName(), ObservationConstants.SUBSCRIPTIONDISCOVERY.getNamespace())) {
            throw new IllegalArgumentException("'subscriptiondiscovery' element expected.");
        }
        ArrayList<1> subscriptions = new ArrayList<1>();
        ElementIterator it = DomUtil.getChildren(sDiscoveryElement, "subscription", ObservationConstants.NAMESPACE);
        while (it.hasNext()) {
            final Element sb = it.nextElement();
            Subscription s = new Subscription(){

                public String getSubscriptionId() {
                    Element ltEl = DomUtil.getChildElement(sb, "subscriptionid", ObservationConstants.NAMESPACE);
                    if (ltEl != null) {
                        return DomUtil.getChildText(sb, "href", DavConstants.NAMESPACE);
                    }
                    return null;
                }

                public Element toXml(Document document) {
                    return (Element)document.importNode(sb, true);
                }
            };
            subscriptions.add(s);
        }
        return new SubscriptionDiscovery(subscriptions.toArray(new Subscription[subscriptions.size()]));
    }
}

