/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.psi.impl;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.plugins.drools.lang.psi.DroolsIdentifier;
import com.intellij.plugins.drools.lang.psi.DroolsParExpr;
import com.intellij.plugins.drools.lang.psi.DroolsReference;
import com.intellij.plugins.drools.lang.psi.impl.DroolsPsiCompositeElementImpl;
import com.intellij.plugins.drools.lang.psi.util.DroolsElementsFactory;
import com.intellij.plugins.drools.lang.psi.util.DroolsResolveUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.impl.light.LightClass;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class DroolsReferenceImpl
extends DroolsPsiCompositeElementImpl
implements DroolsIdentifier,
DroolsReference {
    public DroolsReferenceImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/plugins/drools/lang/psi/impl/DroolsReferenceImpl", "<init>"));
        }
        super(node);
    }

    public PsiElement getElement() {
        return this;
    }

    public PsiReference getReference() {
        return this;
    }

    public TextRange getRangeInElement() {
        TextRange textRange = this.getTextRange();
        return new TextRange(0, textRange.getEndOffset() - textRange.getStartOffset());
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsReferenceImpl", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        String getterName;
        DroolsReferenceImpl element = this;
        String newName = newElementName;
        PsiElement resolve = this.resolve();
        if (resolve instanceof BeanPropertyElement) {
            String propertyName = PropertyUtil.getPropertyName((String)newElementName);
            if (propertyName != null) {
                newName = propertyName;
            }
        } else if (resolve instanceof PsiMethod && PropertyUtil.isSimplePropertyGetter((PsiMethod)((PsiMethod)resolve)) && (getterName = PropertyUtil.suggestGetterName((String)newElementName, null)) != null) {
            newName = getterName;
        }
        DroolsIdentifier identifier = DroolsElementsFactory.createDroolsIdentifier(newName, this.getProject());
        if (identifier != null) {
            return element.replace((PsiElement)identifier);
        }
        return element;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/plugins/drools/lang/psi/impl/DroolsReferenceImpl", "bindToElement"));
        }
        if (element instanceof PsiClass) {
            return this.handleElementRename(((PsiClass)element).getName());
        }
        return element;
    }

    public boolean isReferenceTo(PsiElement element) {
        PsiElement resolve = this.resolve();
        if (resolve instanceof BeanPropertyElement) {
            if (element instanceof BeanPropertyElement) {
                return ((BeanPropertyElement)element).getMethod().equals(((BeanPropertyElement)resolve).getMethod());
            }
            if (element instanceof PsiMethod) {
                return element.equals(((BeanPropertyElement)resolve).getMethod());
            }
        } else if (resolve instanceof LightClass) {
            return ((LightClass)resolve).getDelegate().equals(element);
        }
        return element.equals(resolve);
    }

    @NotNull
    public Object[] getVariants() {
        CommonProcessors.CollectProcessor<PsiElement> processor = new CommonProcessors.CollectProcessor<PsiElement>((Collection)new HashSet()){

            protected boolean accept(PsiElement psiElement) {
                if (psiElement instanceof PsiPackage) {
                    return !StringUtil.isEmptyOrSpaces((String)((PsiPackage)psiElement).getName());
                }
                if (psiElement instanceof PsiMethod) {
                    PsiMethod psiMethod = (PsiMethod)psiElement;
                    if (psiMethod.isConstructor()) {
                        return false;
                    }
                    PsiClass containingClass = psiMethod.getContainingClass();
                    if (containingClass != null && "java.lang.Object".equals(containingClass.getQualifiedName())) {
                        return false;
                    }
                    return psiMethod.getModifierList().hasModifierProperty("public");
                }
                return super.accept((Object)psiElement);
            }

            public boolean process(PsiElement psiElement) {
                BeanProperty property;
                if (psiElement instanceof PsiMethod && PropertyUtil.isSimplePropertyGetter((PsiMethod)((PsiMethod)psiElement)) && (property = BeanProperty.createBeanProperty((PsiMethod)((PsiMethod)psiElement))) != null) {
                    this.getResults().add(property.getPsiElement());
                }
                return super.process((Object)psiElement);
            }
        };
        DroolsResolveUtil.processVariables(processor, this, false);
        if (this.isProcessQualifiers()) {
            DroolsResolveUtil.processQualifiedIdentifier(processor, this);
        }
        Object[] objectArray = ContainerUtil.map2Array((Collection)processor.getResults(), Object.class, psiElement -> {
            if (psiElement instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)psiElement;
                return LookupElementBuilder.create((String)variable.getName()).withIcon(PlatformIcons.VARIABLE_ICON).withTypeText(variable.getType().getCanonicalText());
            }
            if (psiElement instanceof PsiMethod) {
                PsiMethod psiMethod = (PsiMethod)psiElement;
                PsiType type = psiMethod.getReturnType();
                return LookupElementBuilder.create((String)psiMethod.getName()).withIcon(PlatformIcons.METHOD_ICON).withTypeText(type == null ? "" : type.getCanonicalText()).withInsertHandler((InsertHandler)ParenthesesInsertHandler.WITH_PARAMETERS);
            }
            return psiElement;
        });
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsReferenceImpl", "getVariants"));
        }
        return objectArray;
    }

    private boolean isProcessQualifiers() {
        return PsiTreeUtil.getParentOfType((PsiElement)this, DroolsParExpr.class) == null;
    }

    public boolean isSoft() {
        return false;
    }

    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(true);
        return resolveResults.length == 0 ? null : DroolsResolveUtil.chooseDroolsTypeResult(resolveResults);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = (ResolveResult[])ContainerUtil.map2Array(DroolsResolveUtil.resolve(this, false), ResolveResult.class, (Function)((NotNullFunction)psiElement -> new CandidateInfo(psiElement, PsiSubstitutor.EMPTY)));
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsReferenceImpl", "multiResolve"));
        }
        return resolveResultArray;
    }
}

