/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.console;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.play.console.PlayConfiguration;
import com.intellij.play.utils.PlayBundle;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PlayConfigurable
extends BaseConfigurable
implements SearchableConfigurable {
    private static final String TITLE = PlayBundle.message("play.home.configuration", new Object[0]);
    private JPanel myPanel;
    private TextFieldWithBrowseButton myField;
    private JLabel myHomePathLabel;
    private HyperlinkLabel myDownloadLink;
    private JBCheckBox myShowOnStartup;
    private TextFieldWithBrowseButton myPathField;
    private final Project myProject;

    protected PlayConfigurable(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
    }

    @Nls
    public String getDisplayName() {
        return TITLE;
    }

    public String getHelpTopic() {
        return "play.paths.configuration";
    }

    public JComponent createComponent() {
        this.myField.addBrowseFolderListener(TITLE, PlayBundle.message("play.installation.folder.choose.message", new Object[0]), this.myProject, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                PlayConfigurable.this.setModified(!PlayConfigurable.this.myField.getText().equals(PlayConfiguration.getConfiguration().myPlayHome));
            }
        });
        this.myPathField.addBrowseFolderListener(TITLE, PlayBundle.message("play.working.directory.choose.message", new Object[0]), this.myProject, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myPathField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                PlayConfigurable.this.setModified(!PlayConfigurable.this.myPathField.getText().equals(PlayConfiguration.getConfiguration().myPath));
            }
        });
        this.myShowOnStartup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean showOnRun = PlayConfiguration.getConfiguration().myShowOnRun;
                PlayConfigurable.this.setModified(showOnRun == null || PlayConfigurable.this.myShowOnStartup.isSelected() != showOnRun.booleanValue());
            }
        });
        this.myHomePathLabel.setLabelFor(this.myField.getTextField());
        this.myDownloadLink.setHyperlinkTarget(PlayBundle.message("play.download.page", new Object[0]));
        this.myDownloadLink.setHyperlinkText(PlayBundle.message("play.download.title", new Object[0]));
        return this.myPanel;
    }

    public void apply() throws ConfigurationException {
        PlayConfiguration configuration = PlayConfiguration.getConfiguration();
        configuration.myPlayHome = this.myField.getText();
        configuration.myPath = this.myPathField.getText();
        configuration.myShowOnRun = this.myShowOnStartup.isSelected();
    }

    public void reset() {
        PlayConfiguration configuration = PlayConfiguration.getConfiguration();
        this.myField.setText(configuration.myPlayHome);
        this.myPathField.setText(configuration.myPath);
        Boolean show = configuration.myShowOnRun;
        this.myShowOnStartup.setSelected(show == null || show != false);
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/console/PlayConfigurable", "getId"));
        }
        return string;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBCheckBox jBCheckBox;
        HyperlinkLabel hyperlinkLabel;
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 1, 1, 3, 0, 1, 6, 0, null, new Dimension(300, -1), null));
        this.myHomePathLabel = jLabel = new JLabel();
        jLabel.setHorizontalAlignment(4);
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("resources/messages/PlayBundle").getString("play.home"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDownloadLink = hyperlinkLabel = new HyperlinkLabel();
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(0, 3, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myShowOnStartup = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(true);
        jBCheckBox.setEnabled(true);
        jBCheckBox.setText("Show on console run ");
        jPanel.add((Component)jBCheckBox, new GridConstraints(3, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Working directory:");
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 3, 0, 1, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

