/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.converters;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.webflow.model.converters.ParentStateFlowReference;
import com.intellij.spring.webflow.model.converters.ParentStateReference;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NotNull;

public class ParentStateConverter
implements CustomReferenceConverter<String> {
    private static final char DELIMITER = '#';

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> value, PsiElement element, ConvertContext context) {
        TextRange valueTextRange = ElementManipulators.getValueTextRange((PsiElement)element);
        int startOffset = valueTextRange.getStartOffset();
        int length = valueTextRange.getLength();
        String text = ElementManipulators.getValueText((PsiElement)element);
        if (StringUtil.startsWithChar((CharSequence)text, (char)'#')) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new ParentStateReference(element, TextRange.from((int)(startOffset + 1), (int)(length - 1)), value, null)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/ParentStateConverter", "createReferences"));
            }
            return psiReferenceArray;
        }
        int hashIdx = text.indexOf(35);
        TextRange flowReferenceRange = TextRange.from((int)startOffset, (int)(hashIdx != -1 ? hashIdx : length));
        ParentStateFlowReference parentStateFlowReference = new ParentStateFlowReference(element, flowReferenceRange, value);
        if (hashIdx == -1) {
            PsiReference[] psiReferenceArray = new PsiReference[]{parentStateFlowReference};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/ParentStateConverter", "createReferences"));
            }
            return psiReferenceArray;
        }
        int offset = hashIdx + 1;
        TextRange stateReferenceRange = TextRange.from((int)(startOffset + offset), (int)(length - offset));
        ParentStateReference parentStateReference = new ParentStateReference(element, stateReferenceRange, value, parentStateFlowReference);
        PsiReference[] psiReferenceArray = new PsiReference[]{parentStateFlowReference, parentStateReference};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/ParentStateConverter", "createReferences"));
        }
        return psiReferenceArray;
    }
}

