/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.navigation;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.spring.webflow.model.xml.ViewState;
import com.intellij.spring.webflow.resources.WebflowBundle;
import com.intellij.spring.webflow.util.WebflowUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebflowJavaLineMarkerProvider
implements LineMarkerProvider {
    private static final String VALIDATE_METHOD_PREFIX = "validate";
    private static final String VALIDATOR_CLASS_SUFFIX = "Validator";

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/webflow/navigation/WebflowJavaLineMarkerProvider", "getLineMarkerInfo"));
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/spring/webflow/navigation/WebflowJavaLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/webflow/navigation/WebflowJavaLineMarkerProvider", "collectSlowLineMarkers"));
        }
        PsiElement firstItem = (PsiElement)ContainerUtil.getFirstItem(elements);
        if (firstItem == null) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)firstItem);
        if (!WebflowUtil.isWebFlowAvailable(module)) {
            return;
        }
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            PsiElement element = elements.get(i);
            WebflowJavaLineMarkerProvider.annotate(module, element, result);
        }
    }

    private static void annotate(@NotNull Module module, @NotNull PsiElement element, @NotNull Collection<LineMarkerInfo> holder) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/webflow/navigation/WebflowJavaLineMarkerProvider", "annotate"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/webflow/navigation/WebflowJavaLineMarkerProvider", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/webflow/navigation/WebflowJavaLineMarkerProvider", "annotate"));
        }
        if (!(element instanceof PsiIdentifier)) {
            return;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)parent;
        ViewState viewState = WebflowJavaLineMarkerProvider.findViewStateForValidationMethod(module, method);
        if (viewState == null || !viewState.isValid()) {
            return;
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)((Icon)ObjectUtils.assertNotNull((Object)viewState.getPresentation().getIcon()))).setTooltipText(WebflowBundle.message("navigation.code.validation.method.to.view.state", new Object[0])).setTarget((Object)viewState.getXmlTag());
        holder.add((LineMarkerInfo)builder.createLineMarkerInfo(element));
    }

    @Nullable
    private static ViewState findViewStateForValidationMethod(Module module, PsiMethod method) {
        if (!WebflowJavaLineMarkerProvider.isValidationMethod(method)) {
            return null;
        }
        PsiClass modelClass = WebflowJavaLineMarkerProvider.findModelClass(method);
        if (modelClass == null) {
            return null;
        }
        String viewStateIdFromMethodName = StringUtil.decapitalize((String)StringUtil.substringAfter((String)method.getName(), (String)VALIDATE_METHOD_PREFIX));
        List<WebflowModel> webflowModels = WebflowDomModelManager.getInstance(module.getProject()).getAllModels(module);
        for (WebflowModel model : webflowModels) {
            for (ViewState state : model.getFlow().getViewStates()) {
                if (!Comparing.equal((String)state.getId().getStringValue(), (String)viewStateIdFromMethodName) || !modelClass.equals(state.getModelClass())) continue;
                if (modelClass.equals(method.getContainingClass())) {
                    return state;
                }
                String validatorBeanName = state.getModel().getStringValue() + VALIDATOR_CLASS_SUFFIX;
                for (SpringModel springModel : SpringManager.getInstance((Project)method.getProject()).getAllModels(module)) {
                    SpringBeanPointer springBeanPointer = SpringModelSearchers.findBean((CommonSpringModel)springModel, (String)validatorBeanName);
                    if (springBeanPointer == null) continue;
                    return state;
                }
            }
        }
        return null;
    }

    @Nullable
    private static PsiClass findModelClass(PsiMethod method) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() == 1) {
            return containingClass;
        }
        PsiParameter modelParameter = parameterList.getParameters()[0];
        PsiType type = modelParameter.getType();
        if (type instanceof PsiClassType) {
            return ((PsiClassType)type).resolve();
        }
        return null;
    }

    private static boolean isValidationMethod(PsiMethod method) {
        if (!method.hasModifierProperty("public")) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        if (!PsiType.VOID.equals((Object)method.getReturnType())) {
            return false;
        }
        String methodName = method.getName();
        if (!StringUtil.startsWith((CharSequence)methodName, (CharSequence)VALIDATE_METHOD_PREFIX)) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        int parametersCount = parameterList.getParametersCount();
        if (parametersCount == 0 || parametersCount > 2) {
            return false;
        }
        PsiParameter toCheck = parameterList.getParameters()[parametersCount - 1];
        PsiType psiType = toCheck.getType();
        return psiType instanceof PsiClassType && psiType.getCanonicalText().equals("org.springframework.binding.validation.ValidationContext");
    }
}

