/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.facet;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.javaee.model.xml.web.ServletMapping;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.CommonParamValue;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.struts.StrutsManager;
import com.intellij.struts.StrutsModel;
import com.intellij.struts.dom.Controller;
import com.intellij.struts.dom.MessageResources;
import com.intellij.struts.dom.PlugIn;
import com.intellij.struts.dom.SetProperty;
import com.intellij.struts.dom.StrutsConfig;
import com.intellij.struts.facet.StrutsSupportModel;
import com.intellij.struts.facet.ui.StrutsVersion;
import com.intellij.struts.util.FormatUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.xml.DomUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddStrutsSupportUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.struts.facet.AddStrutsSupportUtil");
    @NonNls
    public static final String STRUTS_CONFIG_FILE_NAME = "struts-config.xml";
    @NonNls
    private static final String TILES_REQUEST_PROCESSOR = "org.apache.struts.tiles.TilesRequestProcessor";
    @NonNls
    private static final String TILES_PLUGIN = "org.apache.struts.tiles.TilesPlugin";
    @NonNls
    private static final String VALIDATOR_PLUGIN = "org.apache.struts.validator.ValidatorPlugIn";
    @NonNls
    private static final String DEFAULT_STRUTS_MAPPING = "*.do";
    @NonNls
    private static final String WEB_INF = "WEB-INF";
    @NonNls
    private static final String ACTION_SERVLET_NAME = "action";
    @NonNls
    private static final String STRUTS_CONFIG_LOCATION = "/WEB-INF/struts-config.xml";
    @NonNls
    private static final String CONFIG_PARAM = "config";
    @NonNls
    private static final String VERSION_PROPERTY = "version";
    @NonNls
    private static final String SUBVERSION_PARAMETER = "subversion";
    @NonNls
    private static final String DEFINITIONS_CONFIG_PROPERTY = "definitions-config";
    @NonNls
    private static final String TILES_DEFS_XML = "/WEB-INF/tiles-defs.xml";
    @NonNls
    private static final String PATHNAMES_PROPERTY = "pathnames";
    @NonNls
    private static final String VALIDATION_XML = ",/WEB-INF/validation.xml";
    @NonNls
    private static final String DOTTED = "dotted";

    private AddStrutsSupportUtil() {
    }

    private static PsiFile[] getStrutsFiles(@NotNull WebFacet webFacet) {
        Set files;
        List strutsModels;
        PsiFile psiFile;
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/struts/facet/AddStrutsSupportUtil", "getStrutsFiles"));
        }
        ArrayList<Object> result = new ArrayList<Object>();
        ConfigFile deploymentDescriptor = webFacet.getWebXmlDescriptor();
        if (deploymentDescriptor != null && (psiFile = deploymentDescriptor.getPsiFile()) != null) {
            result.add(psiFile);
        }
        if (!(strutsModels = StrutsManager.getInstance().getAllStrutsModels(webFacet.getModule())).isEmpty() && !(files = ((StrutsModel)strutsModels.get(0)).getConfigFiles()).isEmpty()) {
            result.add(files.iterator().next());
        }
        return PsiUtilCore.toPsiFileArray(result);
    }

    public static boolean addSupport(WebFacet webFacet, boolean hasValidatorSupport, boolean hasTilesSupport, boolean isStruts13x) throws Exception {
        PsiDirectory directory;
        PsiFile configFile;
        VirtualFile webinf;
        Module module = webFacet.getModule();
        Project project = module.getProject();
        WebApp app = webFacet.getRoot();
        if (app == null) {
            return false;
        }
        String configFilesList = AddStrutsSupportUtil.patchWebXml(module, app);
        if (configFilesList == null) {
            return false;
        }
        String[] configs = configFilesList.split(",");
        WebDirectoryUtil util = WebDirectoryUtil.getWebDirectoryUtil((Project)project);
        VirtualFile file = util.findVirtualFileByPath(configs[0].trim(), webFacet);
        if (file == null) {
            webinf = util.findVirtualFileByPath("/WEB-INF", webFacet);
            if (webinf == null) {
                webinf = AddStrutsSupportUtil.getOrCreateWebInf(webFacet);
            }
            configFile = AddStrutsSupportUtil.createConfigFile(project, webinf, isStruts13x);
        } else {
            webinf = file.getParent();
            configFile = PsiManager.getInstance((Project)project).findFile(file);
        }
        if (configFile == null) {
            return false;
        }
        StrutsConfig config = StrutsManager.getInstance().getStrutsConfig(configFile);
        if (config == null) {
            return false;
        }
        StrutsSupportModel support = StrutsSupportModel.checkStrutsSupport(webFacet);
        if (webinf != null && (directory = PsiManager.getInstance((Project)project).findDirectory(webinf)) != null) {
            if (!support.isTiles() && hasTilesSupport) {
                AddStrutsSupportUtil.addTilesSupport(directory, config);
            }
            if (!support.isValidation() && hasValidatorSupport) {
                AddStrutsSupportUtil.addValidationSupport(config, directory, webFacet.getModule(), isStruts13x);
            }
        }
        AddStrutsSupportUtil.deleteUnusedPlugins(config, hasValidatorSupport, hasTilesSupport);
        return true;
    }

    @Nullable
    private static PsiFile createConfigFile(Project project, VirtualFile webinf, boolean isStruts13x) throws Exception {
        PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(webinf);
        if (directory == null) {
            return null;
        }
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getJ2eeTemplate(STRUTS_CONFIG_FILE_NAME);
        Properties properties = FileTemplateManager.getInstance((Project)project).getDefaultProperties();
        properties.setProperty(VERSION_PROPERTY, "1");
        properties.setProperty(SUBVERSION_PARAMETER, isStruts13x ? "3" : "2");
        return (PsiFile)FileTemplateUtil.createFromTemplate((FileTemplate)fileTemplate, (String)STRUTS_CONFIG_FILE_NAME, (Properties)properties, (PsiDirectory)directory);
    }

    @Nullable
    private static VirtualFile getOrCreateWebInf(WebFacet webFacet) throws IOException {
        WebDirectoryUtil util = WebDirectoryUtil.getWebDirectoryUtil((Project)webFacet.getModule().getProject());
        VirtualFile webinf = util.findVirtualFileByPath("/WEB-INF", webFacet);
        if (webinf == null) {
            VirtualFile webXml = webFacet.getWebXmlDescriptor().getVirtualFile();
            if (webXml == null) {
                return null;
            }
            VirtualFile parent = webXml.getParent();
            if (parent != null && parent.getName().equals(WEB_INF)) {
                webFacet.addWebRoot(parent, "/WEB-INF");
                webinf = parent;
            } else {
                WebRoot root;
                List webRoots = webFacet.getWebRoots();
                if (webRoots.isEmpty()) {
                    VirtualFile[] roots = ModuleRootManager.getInstance((Module)webFacet.getModule()).getContentRoots();
                    if (roots.length == 0) {
                        throw new IllegalStateException("The module has no content roots");
                    }
                    VirtualFile resources = roots[0].createChildDirectory(AddStrutsSupportUtil.class, "resources");
                    root = webFacet.addWebRoot(resources, "/");
                } else {
                    root = (WebRoot)webRoots.get(0);
                }
                VirtualFile file = root.getFile();
                if (file != null) {
                    webinf = file.createChildDirectory(AddStrutsSupportUtil.class, WEB_INF);
                }
            }
        }
        return webinf;
    }

    @Nullable
    private static String patchWebXml(@NotNull Module module, @NotNull WebApp app) {
        String configFile;
        CommonParamValue configParam;
        Integer loadOnStartup;
        Servlet servlet;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/struts/facet/AddStrutsSupportUtil", "patchWebXml"));
        }
        if (app == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "app", "com/intellij/struts/facet/AddStrutsSupportUtil", "patchWebXml"));
        }
        StrutsModel strutsModel = null;
        List strutsModels = StrutsManager.getInstance().getAllStrutsModels(module);
        if (!strutsModels.isEmpty()) {
            strutsModel = (StrutsModel)strutsModels.get(0);
        }
        if (strutsModel != null && !(strutsModel.getActionServlet() instanceof Servlet)) {
            return null;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(app.getContainingFile())) {
            return null;
        }
        Servlet servlet2 = servlet = strutsModel == null ? null : (Servlet)strutsModel.getActionServlet();
        if (servlet == null) {
            servlet = app.addServlet();
            servlet.getServletName().setValue((Object)ACTION_SERVLET_NAME);
            servlet.getServletClass().setStringValue("org.apache.struts.action.ActionServlet");
        }
        if ((loadOnStartup = (Integer)servlet.getLoadOnStartup().getValue()) == null) {
            servlet.getLoadOnStartup().setStringValue("2");
        }
        if (strutsModel == null) {
            ServletMapping mapping = app.addServletMapping();
            mapping.getServletName().setValue((Object)servlet);
            mapping.addUrlPattern().setValue((Object)DEFAULT_STRUTS_MAPPING);
        }
        if ((configParam = (CommonParamValue)DomUtil.findByName((Collection)servlet.getInitParams(), (String)CONFIG_PARAM)) == null) {
            configParam = servlet.addInitParam();
            configParam.getParamName().setValue((Object)CONFIG_PARAM);
        }
        if ((configFile = (String)configParam.getParamValue().getValue()) == null || configFile.trim().length() == 0) {
            configParam.getParamValue().setValue((Object)STRUTS_CONFIG_LOCATION);
            configFile = STRUTS_CONFIG_LOCATION;
        }
        return configFile;
    }

    private static void addValidationSupport(StrutsConfig root, @NotNull PsiDirectory webinf, Module module, boolean isStruts13x) throws Exception {
        if (webinf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webinf", "com/intellij/struts/facet/AddStrutsSupportUtil", "addValidationSupport"));
        }
        AddStrutsSupportUtil.addValidationPlugin(root, isStruts13x);
        PsiFile validationXml = webinf.findFile("validation.xml");
        if (validationXml == null) {
            if (isStruts13x) {
                AddStrutsSupportUtil.createValidationXml("1_3_0", webinf);
            } else {
                AddStrutsSupportUtil.copyValidatorRulesAndCreateValidation(webinf);
            }
        }
        AddStrutsSupportUtil.addMessageResource(module, root);
    }

    private static void addTilesSupport(@NotNull PsiDirectory webinf, @NotNull StrutsConfig root) throws Exception {
        if (webinf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webinf", "com/intellij/struts/facet/AddStrutsSupportUtil", "addTilesSupport"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/struts/facet/AddStrutsSupportUtil", "addTilesSupport"));
        }
        Project project = root.getManager().getProject();
        PsiManager manager = PsiManager.getInstance((Project)project);
        Controller controller = root.getController();
        controller.ensureXmlElementExists();
        PsiClass processorClass = (PsiClass)controller.getProcessorClass().getValue();
        boolean requestProcessorConfigured = false;
        if (processorClass != null) {
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            PsiClass tilesClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(TILES_REQUEST_PROCESSOR, scope);
            boolean bl = requestProcessorConfigured = tilesClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)processorClass, (PsiClass)tilesClass, (boolean)true);
        }
        if (!requestProcessorConfigured) {
            controller.getProcessorClass().setStringValue(TILES_REQUEST_PROCESSOR);
        }
        PlugIn plugin = root.addPlugIn();
        plugin.getClassName().setStringValue(TILES_PLUGIN);
        SetProperty prop = plugin.addSetProperty();
        prop.getProperty().setStringValue(DEFINITIONS_CONFIG_PROPERTY);
        prop.getValue().setStringValue(TILES_DEFS_XML);
        PsiFile tilesDefs = webinf.findFile("tiles-defs.xml");
        if (tilesDefs == null) {
            FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)webinf.getProject()).getJ2eeTemplate("tiles-defs.xml");
            FileTemplateUtil.createFromTemplate((FileTemplate)fileTemplate, (String)"tiles-defs.xml", null, (PsiDirectory)webinf);
        }
    }

    private static void addValidationPlugin(StrutsConfig root, boolean isStruts13x) {
        PlugIn plugin = root.addPlugIn();
        plugin.getClassName().setStringValue(VALIDATOR_PLUGIN);
        SetProperty prop = plugin.addSetProperty();
        prop.getProperty().setStringValue(PATHNAMES_PROPERTY);
        String rules = isStruts13x ? "/org/apache/struts/validator/validator-rules.xml" : "/WEB-INF/validator-rules.xml";
        prop.getValue().setStringValue(rules + VALIDATION_XML);
    }

    private static void copyValidatorRulesAndCreateValidation(@NotNull PsiDirectory webinf) throws Exception {
        String uri;
        String v;
        XmlProlog prolog;
        XmlDocument document;
        if (webinf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webinf", "com/intellij/struts/facet/AddStrutsSupportUtil", "copyValidatorRulesAndCreateValidation"));
        }
        PsiFile rulesXml = webinf.findFile("validator-rules.xml");
        if (rulesXml == null) {
            FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)webinf.getProject()).getJ2eeTemplate("validator-rules.xml");
            rulesXml = (PsiFile)FileTemplateUtil.createFromTemplate((FileTemplate)fileTemplate, (String)"validator-rules.xml", null, (PsiDirectory)webinf);
        }
        if (rulesXml instanceof XmlFile && (document = ((XmlFile)rulesXml).getDocument()) != null && (prolog = document.getProlog()) != null && prolog.getDoctype() != null && (v = FormatUtil.getVersion(uri = prolog.getDoctype().getDtdUri())) != null) {
            AddStrutsSupportUtil.createValidationXml(v, webinf);
        }
    }

    private static void addMessageResource(Module module, StrutsConfig config) throws Exception {
        PsiDirectory directory;
        Project project = module.getProject();
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
        if (roots.length > 0 && (directory = PsiManager.getInstance((Project)project).findDirectory(roots[0])) != null) {
            String newParam = "MessageResources";
            for (MessageResources res : config.getMessageResources()) {
                String param = (String)res.getParameter().getValue();
                if (param == null || !param.equals(newParam)) continue;
                newParam = "ValidatorResources";
                break;
            }
            String name = newParam;
            int i = 1;
            while (directory.findFile(name + ".properties") != null) {
                name = newParam + i++;
            }
            FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getJ2eeTemplate("MessageResources.properties");
            FileTemplateUtil.createFromTemplate((FileTemplate)fileTemplate, (String)(name + ".properties"), null, (PsiDirectory)directory);
            MessageResources res = config.addMessageResources();
            res.getParameter().setValue((Object)name);
        }
    }

    private static void deleteUnusedPlugins(StrutsConfig root, boolean hasValidatorSupport, boolean hasTilesSupport) {
        for (PlugIn plugin : root.getPlugIns()) {
            String className = plugin.getClassName().getStringValue();
            if (className == null) continue;
            if (className.equals(VALIDATOR_PLUGIN)) {
                if (hasValidatorSupport) continue;
                plugin.undefine();
                continue;
            }
            if (!className.equals(TILES_PLUGIN) || hasTilesSupport) continue;
            plugin.undefine();
        }
    }

    private static void createValidationXml(String v, @NotNull PsiDirectory directory) throws Exception {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/struts/facet/AddStrutsSupportUtil", "createValidationXml"));
        }
        String dotted = FormatUtil.replace(v, '_', '.');
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)directory.getProject()).getJ2eeTemplate("validation.xml");
        Properties properties = FileTemplateManager.getInstance((Project)directory.getProject()).getDefaultProperties();
        properties.setProperty(VERSION_PROPERTY, v);
        properties.setProperty(DOTTED, dotted);
        FileTemplateUtil.createFromTemplate((FileTemplate)fileTemplate, (String)"validation.xml", (Properties)properties, (PsiDirectory)directory);
    }

    public static void addSupportInWriteCommandAction(final WebFacet webFacet, final boolean hasValidatorSupport, final boolean hasTilesSupport, final StrutsVersion version) {
        Project project = webFacet.getModule().getProject();
        DumbService.getInstance((Project)project).runWhenSmart(() -> new WriteCommandAction.Simple(project, AddStrutsSupportUtil.getStrutsFiles(webFacet)){

            protected void run() throws Throwable {
                try {
                    AddStrutsSupportUtil.addSupport(webFacet, hasValidatorSupport, hasTilesSupport, version == StrutsVersion.Struts1_3_8);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }.execute());
    }
}

