/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.inspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.visibility.EntryPointWithVisibilityLevel;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class JUnitEntryPoint
extends EntryPointWithVisibilityLevel {
    public boolean ADD_JUNIT_TO_ENTRIES = true;

    @NotNull
    public String getDisplayName() {
        if ("JUnit test cases" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit2/inspection/JUnitEntryPoint", "getDisplayName"));
        }
        return "JUnit test cases";
    }

    public boolean isEntryPoint(@NotNull RefElement refElement, @NotNull PsiElement psiElement) {
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "com/intellij/execution/junit2/inspection/JUnitEntryPoint", "isEntryPoint"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/execution/junit2/inspection/JUnitEntryPoint", "isEntryPoint"));
        }
        return this.isEntryPoint(psiElement);
    }

    public boolean isEntryPoint(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/execution/junit2/inspection/JUnitEntryPoint", "isEntryPoint"));
        }
        if (psiElement instanceof PsiClass) {
            PsiClass aClass = (PsiClass)psiElement;
            if (JUnitUtil.isTestClass((PsiClass)aClass, (boolean)false, (boolean)true)) {
                boolean isJUnit5 = JUnitUtil.isJUnit5((PsiElement)aClass);
                if (!PsiClassUtil.isRunnableClass((PsiClass)aClass, (!isJUnit5 ? 1 : 0) != 0, (boolean)true)) {
                    PsiClass topLevelClass = (PsiClass)PsiTreeUtil.getTopmostParentOfType((PsiElement)aClass, PsiClass.class);
                    if (topLevelClass != null && PsiClassUtil.isRunnableClass((PsiClass)topLevelClass, (!isJUnit5 ? 1 : 0) != 0, (boolean)true)) {
                        return true;
                    }
                    CommonProcessors.FindProcessor<PsiClass> findProcessor = new CommonProcessors.FindProcessor<PsiClass>(){

                        protected boolean accept(PsiClass psiClass) {
                            return !psiClass.hasModifierProperty("abstract");
                        }
                    };
                    return !ClassInheritorsSearch.search((PsiClass)aClass).forEach((Processor)findProcessor) && findProcessor.isFound();
                }
                return true;
            }
        } else if (psiElement instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)psiElement;
            if (method.isConstructor() && method.getParameterList().getParametersCount() == 0) {
                return JUnitUtil.isTestClass((PsiClass)method.getContainingClass());
            }
            if (JUnitUtil.isTestMethodOrConfig((PsiMethod)method)) {
                return true;
            }
        } else if (psiElement instanceof PsiField) {
            return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiField)psiElement), (String)"org.junit.runners.Parameterized.Parameter", (boolean)false);
        }
        return false;
    }

    public int getMinVisibilityLevel(PsiMember member) {
        PsiClass container = null;
        if (member instanceof PsiClass) {
            container = (PsiClass)member;
        } else if (member instanceof PsiMethod) {
            container = member.getContainingClass();
        }
        if (container != null && JUnitUtil.isJUnit5TestClass((PsiClass)container, (boolean)false)) {
            return 2;
        }
        return -1;
    }

    public String getTitle() {
        return "Suggest package-private visibility level for junit 5 tests";
    }

    public String getId() {
        return "junit";
    }

    public boolean isSelected() {
        return this.ADD_JUNIT_TO_ENTRIES;
    }

    public void setSelected(boolean selected) {
        this.ADD_JUNIT_TO_ENTRIES = selected;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (!this.ADD_JUNIT_TO_ENTRIES) {
            DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
        }
    }

    public String[] getIgnoreAnnotations() {
        return new String[]{"org.junit.Rule", "org.junit.ClassRule", "org.junit.experimental.theories.DataPoint", "org.junit.experimental.theories.DataPoints"};
    }
}

