/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.console3.remote;

import com.intellij.hibernate.console3.remote.HibernateFacadeImpl;
import com.intellij.hibernate.console3.remote.RemoteSessionImpl;
import com.intellij.hibernate.remote.RemoteSession;
import com.intellij.hibernate.remote.impl.BaseRemoteSessionFactory;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Collections;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.query.HQLQueryPlan;
import org.hibernate.hql.QueryTranslator;

public class RemoteSessionFactoryImpl
extends BaseRemoteSessionFactory {
    protected RemoteSessionFactoryImpl(SessionFactory delegate) {
        super(delegate);
    }

    public static RemoteSessionFactoryImpl wrap(SessionFactory delegate) {
        return new RemoteSessionFactoryImpl(delegate);
    }

    public RemoteSession openSession() throws RemoteException {
        try {
            return (RemoteSession)this.export((Remote)RemoteSessionImpl.wrap((Session)this.getDelegate().openSession()));
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public RemoteSession getCurrentSession() throws RemoteException {
        try {
            return (RemoteSession)this.export((Remote)RemoteSessionImpl.wrap((Session)this.getDelegate().getCurrentSession()));
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    protected String generateSqlInner(String query) {
        HQLQueryPlan plan = new HQLQueryPlan(query, false, Collections.emptyMap(), (SessionFactoryImplementor)this.getDelegate());
        StringBuilder sb = new StringBuilder();
        for (QueryTranslator translator : plan.getTranslators()) {
            for (Object o : translator.collectSqlStrings()) {
                if (!(o instanceof String)) continue;
                String formattedSql = HibernateFacadeImpl.ourFormatter.formatSQL((String)o);
                sb.append(formattedSql);
            }
        }
        return sb.toString();
    }
}

