/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.clientBundle.css;

import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssPropertyValue;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorFactory2;
import com.intellij.psi.css.impl.util.table.AbstractCssPropertyDescriptor;
import com.intellij.psi.css.impl.util.table.CssPropertyValueImpl;
import com.intellij.psi.css.impl.util.table.CssTableValue;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtPropertyDescriptor
extends AbstractCssPropertyDescriptor
implements CssPropertyDescriptor {
    @NotNull
    private final String myPropertyName;
    @NotNull
    private final CssPropertyValueImpl myValue;
    @NotNull
    private static final CssValueDescriptor OUR_VALUE_DESCRIPTOR = CssElementDescriptorFactory2.getInstance().createAnyValueDescriptor(1, 1, null);

    public GwtPropertyDescriptor(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/gwt/clientBundle/css/GwtPropertyDescriptor", "<init>"));
        }
        this.myPropertyName = propertyName;
        this.myValue = new GwtCssPropertyValue();
    }

    @NotNull
    public CssPropertyValue getValue() {
        CssPropertyValueImpl cssPropertyValueImpl = this.myValue;
        if (cssPropertyValueImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/css/GwtPropertyDescriptor", "getValue"));
        }
        return cssPropertyValueImpl;
    }

    public boolean isShorthandValue() {
        return false;
    }

    @NotNull
    public String getPropertyName() {
        String string = this.myPropertyName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/css/GwtPropertyDescriptor", "getPropertyName"));
        }
        return string;
    }

    public boolean getInherited() {
        return false;
    }

    @NotNull
    public CssValueDescriptor getValueDescriptor() {
        CssValueDescriptor cssValueDescriptor = OUR_VALUE_DESCRIPTOR;
        if (cssValueDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/css/GwtPropertyDescriptor", "getValueDescriptor"));
        }
        return cssValueDescriptor;
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Css.Property;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GwtPropertyDescriptor)) {
            return false;
        }
        GwtPropertyDescriptor that = (GwtPropertyDescriptor)((Object)o);
        if (!this.myPropertyName.equals(that.myPropertyName)) {
            return false;
        }
        return this.myValue.equals(that.myValue);
    }

    public int hashCode() {
        int result = this.myPropertyName.hashCode();
        result = 31 * result + this.myValue.hashCode();
        return result;
    }

    private static class GwtCssPropertyValue
    extends CssPropertyValueImpl {
        public GwtCssPropertyValue() {
            super(CssTableValue.Type.OR);
        }

        public boolean isValueBelongs(@Nullable PsiElement element) {
            return true;
        }
    }
}

