/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.facet.GwtFacetType;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.sdk.GwtSdk;
import com.intellij.gwt.sdk.GwtSdkManager;
import com.intellij.gwt.sdk.GwtSdkUtil;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.gwt.sdk.impl.GwtVersionImpl;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtFacet
extends Facet<GwtFacetConfiguration> {
    public GwtFacet(@NotNull FacetType facetType, @NotNull Module module, String name, @NotNull GwtFacetConfiguration configuration) {
        if (facetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetType", "com/intellij/gwt/facet/GwtFacet", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/gwt/facet/GwtFacet", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/gwt/facet/GwtFacet", "<init>"));
        }
        super(facetType, module, name, (FacetConfiguration)configuration, null);
    }

    @Nullable
    public static GwtFacet getInstance(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/gwt/facet/GwtFacet", "getInstance"));
        }
        return (GwtFacet)FacetManager.getInstance((Module)module).getFacetByType(GwtFacetType.ID);
    }

    @Nullable
    public static GwtFacet findFacetByPsiElement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        return GwtFacet.findFacetBySourceFile(element.getProject(), containingFile.getOriginalFile().getVirtualFile());
    }

    @Nullable
    public static GwtFacet findFacetBySourceFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/facet/GwtFacet", "findFacetBySourceFile"));
        }
        if (file == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null || module.isDisposed()) {
            return null;
        }
        return GwtFacet.getInstance(module);
    }

    public static boolean isInModuleWithGwtFacet(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/facet/GwtFacet", "isInModuleWithGwtFacet"));
        }
        return GwtFacet.findFacetBySourceFile(project, file) != null;
    }

    @Nullable
    public WebFacet getWebFacet() {
        String webFacetName = ((GwtFacetConfiguration)this.getConfiguration()).getWebFacetName();
        return webFacetName != null ? (WebFacet)FacetManager.getInstance((Module)this.getModule()).findFacet(WebFacet.ID, webFacetName) : null;
    }

    @NotNull
    public GwtVersion getSdkVersion() {
        GwtVersion gwtVersion = ((GwtFacetConfiguration)this.getConfiguration()).getSdk().getVersion();
        if (gwtVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/facet/GwtFacet", "getSdkVersion"));
        }
        return gwtVersion;
    }

    public void initFacet() {
        GwtFacetConfiguration configuration = (GwtFacetConfiguration)this.getConfiguration();
        GwtSdkManager.getInstance().registerGwtSdk(configuration.getSdk());
    }

    public static GwtFacet createNewFacet(@NotNull Module module, GwtSdk sdk) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/gwt/facet/GwtFacet", "createNewFacet"));
        }
        FacetManager facetManager = FacetManager.getInstance((Module)module);
        ModifiableFacetModel model = facetManager.createModifiableModel();
        GwtFacet facet = (GwtFacet)model.getFacetByType(GwtFacetType.ID);
        if (facet != null) {
            return facet;
        }
        GwtFacetType type = GwtFacetType.getInstance();
        GwtFacetConfiguration configuration = (GwtFacetConfiguration)ProjectFacetManager.getInstance((Project)module.getProject()).createDefaultConfiguration((FacetType)type);
        facet = (GwtFacet)facetManager.createFacet((FacetType)type, type.getDefaultFacetName(), (FacetConfiguration)configuration, null);
        model.addFacet((Facet)facet);
        ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        GwtFacet.setupGwtSdkAndLibraries(configuration, rootModel, sdk);
        WriteAction.run(() -> {
            model.commit();
            rootModel.commit();
        });
        return facet;
    }

    public static void setupGwtSdkAndLibraries(GwtFacetConfiguration configuration, ModifiableRootModel rootModel, @Nullable GwtSdk gwtSdk) {
        GwtFacet.setupGwtSdkAndLibraries(configuration, rootModel, gwtSdk, LibrariesContainerFactory.createContainer((Project)rootModel.getProject()));
    }

    public static void setupGwtSdkAndLibraries(GwtFacetConfiguration configuration, ModifiableRootModel rootModel, @Nullable GwtSdk gwtSdk, @NotNull LibrariesContainer container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/gwt/facet/GwtFacet", "setupGwtSdkAndLibraries"));
        }
        if (gwtSdk == null || !gwtSdk.isValid()) {
            ProjectFacetManager facetManager = ProjectFacetManager.getInstance((Project)rootModel.getProject());
            gwtSdk = facetManager.getFacets(GwtFacetType.ID).stream().map(Facet::getConfiguration).map(GwtFacetConfiguration::getSdk).filter(GwtSdk::isValid).max(Comparator.comparing(sdk -> (GwtVersionImpl)sdk.getVersion())).orElseGet(GwtSdkManager.getInstance()::suggestGwtSdk);
        }
        if (gwtSdk != null) {
            Library library;
            configuration.setGwtSdkUrlAndType(gwtSdk.getHomeDirectoryUrl());
            GwtSdkManager.getInstance().moveToTop(gwtSdk);
            VirtualFile userJar = gwtSdk.getUserJar();
            if (userJar != null && OrderEntryUtil.findLibraryOrderEntry((ModuleRootModel)rootModel, (Library)(library = GwtSdkUtil.findOrCreateGwtUserLibrary(container, userJar))) == null) {
                rootModel.addLibraryEntry(library);
            }
        }
    }

    @NotNull
    public static GwtVersion getGwtVersion(@Nullable GwtFacet gwtFacet) {
        GwtVersion gwtVersion = gwtFacet != null ? gwtFacet.getSdkVersion() : GwtVersionImpl.getDefaultVersion();
        if (gwtVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/facet/GwtFacet", "getGwtVersion"));
        }
        return gwtVersion;
    }

    @NotNull
    public static GwtVersion getGwtVersion(@Nullable Module module) {
        GwtFacet facet = module != null ? GwtFacet.getInstance(module) : null;
        GwtVersion gwtVersion = GwtFacet.getGwtVersion(facet);
        if (gwtVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/facet/GwtFacet", "getGwtVersion"));
        }
        return gwtVersion;
    }

    @Nullable
    public static GwtFacet getInstance(GwtModule gwtModule) {
        Module module = gwtModule.getModule();
        return module != null ? GwtFacet.getInstance(module) : null;
    }
}

