/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.gradle;

import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.run.GwtRunConfiguration;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.task.ExecuteRunConfigurationTask;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.build.GradleExecutionEnvironmentProvider;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GwtGradleExecutionEnvironmentProvider
implements GradleExecutionEnvironmentProvider {
    public boolean isApplicable(ExecuteRunConfigurationTask task) {
        return task.getRunProfile() instanceof GwtRunConfiguration;
    }

    public ExecutionEnvironment createExecutionEnvironment(Project project, ExecuteRunConfigurationTask task, Executor executor) {
        if (!this.isApplicable(task)) {
            return null;
        }
        GwtRunConfiguration gwtRunConfiguration = (GwtRunConfiguration)task.getRunProfile();
        Module module = gwtRunConfiguration.getModule();
        if (module == null) {
            return null;
        }
        GwtFacet gwtFacet = GwtFacet.getInstance(module);
        if (gwtFacet == null) {
            return null;
        }
        String gradleProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
        if (gradleProjectPath == null) {
            return null;
        }
        ExternalProject externalProject = ExternalProjectDataCache.getInstance((Project)project).getRootExternalProject(GradleConstants.SYSTEM_ID, new File(gradleProjectPath));
        if (externalProject == null) {
            return null;
        }
        Map tasks = externalProject.getTasks();
        if (!(tasks.containsKey("gwtDev") && tasks.containsKey("gwtSuperDev") && tasks.containsKey("warTemplate"))) {
            return null;
        }
        ExternalSystemTaskExecutionSettings taskSettings = new ExternalSystemTaskExecutionSettings();
        taskSettings.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
        taskSettings.setExternalProjectPath(ExternalSystemApiUtil.getExternalProjectPath((Module)module));
        GwtRunConfiguration.GwtRunConfigurationState gwtRunConfigurationState = gwtRunConfiguration.getState();
        String taskName = gwtRunConfigurationState.USE_SUPER_DEV_MODE ? "gwtDev" : "gwtSuperDev";
        taskSettings.setTaskNames(Collections.singletonList(taskName));
        String executorId = executor == null ? DefaultRunExecutor.EXECUTOR_ID : executor.getId();
        ExecutionEnvironment environment = ExternalSystemUtil.createExecutionEnvironment((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (ExternalSystemTaskExecutionSettings)taskSettings, (String)executorId);
        if (environment == null) {
            return null;
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = environment.getRunnerAndConfigurationSettings();
        if (runnerAndConfigurationSettings == null) {
            return null;
        }
        ExternalSystemRunConfiguration runnerSettings = (ExternalSystemRunConfiguration)runnerAndConfigurationSettings.getConfiguration();
        String gradlePath = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        if (!StringUtil.startsWithChar((CharSequence)gradlePath, (char)':')) {
            gradlePath = ":";
        } else if (!gradlePath.equals(":")) {
            gradlePath = gradlePath.substring(0, gradlePath.lastIndexOf(58));
        }
        HashMap gwtParameters = ContainerUtil.newHashMap();
        HashMap gwtCompilerParameters = ContainerUtil.newHashMap();
        HashMap gwtDevParameters = ContainerUtil.newHashMap();
        HashMap gwtSuperDevParameters = ContainerUtil.newHashMap();
        HashMap warTemplateParameters = ContainerUtil.newHashMap();
        List<String> modules = gwtRunConfigurationState.getGwtModules();
        if (modules != null) {
            StringBuilder result = new StringBuilder("'");
            StringUtil.join(modules, (String)"', '", (StringBuilder)result);
            result.append("'");
            gwtParameters.put("modules", result.toString());
        }
        GwtFacetConfiguration gwtFacetConfiguration = (GwtFacetConfiguration)gwtFacet.getConfiguration();
        gwtParameters.put("maxHeapSize", GwtGradleExecutionEnvironmentProvider.escapeString(gwtFacetConfiguration.getCompilerMaxHeapSize() + "M"));
        gwtParameters.put("minHeapSize", null);
        gwtCompilerParameters.put("style", GwtGradleExecutionEnvironmentProvider.escapeString(gwtFacetConfiguration.getOutputStyle().getId()));
        gwtParameters.put("sourceLevel", GwtGradleExecutionEnvironmentProvider.escapeString(gwtFacetConfiguration.getClientLanguageLevel().getCompilerComplianceDefaultOption()));
        String gwtRunConfigurationProgramParameters = gwtRunConfiguration.getProgramParameters();
        if (gwtRunConfigurationProgramParameters != null) {
            Iterator<String> iterator = ParametersListUtil.parse((String)gwtRunConfigurationProgramParameters).iterator();
            while (iterator.hasNext()) {
                String arg = (String)iterator.next();
                if (arg.equals("-war")) {
                    String destinationDir = GwtGradleExecutionEnvironmentProvider.nextValue(iterator);
                    if (destinationDir == null) continue;
                    String value = "file(" + GwtGradleExecutionEnvironmentProvider.escapeString(destinationDir) + ")";
                    warTemplateParameters.put("destinationDir", value);
                    gwtParameters.put("devWar", value);
                    continue;
                }
                if (arg.equals("-workDir")) {
                    String workDir = GwtGradleExecutionEnvironmentProvider.nextValue(iterator);
                    if (workDir == null) continue;
                    gwtParameters.put("workDir", "file(" + GwtGradleExecutionEnvironmentProvider.escapeString(workDir) + ")");
                    continue;
                }
                if (arg.equals("-gen")) {
                    String genDir = GwtGradleExecutionEnvironmentProvider.nextValue(iterator);
                    if (genDir == null) continue;
                    gwtParameters.put("genDir", "file(" + GwtGradleExecutionEnvironmentProvider.escapeString(genDir) + ")");
                    continue;
                }
                if (arg.equals("-extra")) {
                    String extraDir = GwtGradleExecutionEnvironmentProvider.nextValue(iterator);
                    if (extraDir == null) continue;
                    gwtParameters.put("extraDir", "file(" + GwtGradleExecutionEnvironmentProvider.escapeString(extraDir) + ")");
                    continue;
                }
                if (arg.equals("-incremental")) {
                    gwtParameters.put("incremental", "true");
                    continue;
                }
                if (arg.equals("-XjsInteropMode")) {
                    String jsInteropMode = GwtGradleExecutionEnvironmentProvider.nextValue(iterator);
                    if (jsInteropMode == null) continue;
                    gwtParameters.put("jsInteropMode", GwtGradleExecutionEnvironmentProvider.escapeString(jsInteropMode));
                    continue;
                }
                if (arg.equals("-logLevel")) {
                    String logLevel = GwtGradleExecutionEnvironmentProvider.nextValue(iterator);
                    if (logLevel == null) continue;
                    gwtParameters.put("logLevel", GwtGradleExecutionEnvironmentProvider.escapeString(logLevel));
                    continue;
                }
                if (arg.equals("-sourceLevel")) {
                    String sourceLevel = GwtGradleExecutionEnvironmentProvider.nextValue(iterator);
                    if (sourceLevel == null) continue;
                    gwtParameters.put("sourceLevel", GwtGradleExecutionEnvironmentProvider.escapeString(sourceLevel));
                    continue;
                }
                if (!arg.equals("-noserver") && !arg.equals("-nostartServer")) continue;
                gwtDevParameters.put("noserver", "true");
            }
        }
        gwtDevParameters.put("superDevMode", Boolean.toString(gwtRunConfigurationState.USE_SUPER_DEV_MODE));
        String gwtParametersString = GwtGradleExecutionEnvironmentProvider.mapToString(gwtParameters);
        String gwtCompilerParametersString = GwtGradleExecutionEnvironmentProvider.mapToString(gwtCompilerParameters);
        String warTemplateParametersString = GwtGradleExecutionEnvironmentProvider.mapToString(warTemplateParameters);
        String gwtDevParametersString = GwtGradleExecutionEnvironmentProvider.mapToString(gwtDevParameters);
        String gwtSuperDevParametersString = GwtGradleExecutionEnvironmentProvider.mapToString(gwtSuperDevParameters);
        String initScript = "projectsEvaluated {\n  def project = rootProject.findProject('" + gradlePath + "')\n  if (project) {\n    compileGwt {\n" + gwtCompilerParametersString + "    }\n    gwtDev {\n" + gwtDevParametersString + "    }\n    gwtSuperDev {\n" + gwtSuperDevParametersString + "    }\n    gwt {\n" + gwtParametersString + "    }\n    warTemplate {\n" + warTemplateParametersString + "    }\n  }\n}\n";
        runnerSettings.putUserData(GradleTaskManager.INIT_SCRIPT_KEY, (Object)initScript);
        return environment;
    }

    @NotNull
    private static String mapToString(Map<String, String> gwtCompilerParameters) {
        StringBuilder gwtCompilerParametersString = new StringBuilder();
        for (Map.Entry<String, String> entry : gwtCompilerParameters.entrySet()) {
            gwtCompilerParametersString.append("        ").append(entry.getKey()).append(" = ").append(entry.getValue()).append('\n');
        }
        String string = gwtCompilerParametersString.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/gradle/GwtGradleExecutionEnvironmentProvider", "mapToString"));
        }
        return string;
    }

    @Nullable
    private static String nextValue(@NotNull Iterator<String> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/gwt/gradle/GwtGradleExecutionEnvironmentProvider", "nextValue"));
        }
        return iterator.hasNext() ? iterator.next() : null;
    }

    @NotNull
    private static String escapeString(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/gwt/gradle/GwtGradleExecutionEnvironmentProvider", "escapeString"));
        }
        String string2 = "'" + StringUtil.escapeStringCharacters((String)string) + "'";
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/gradle/GwtGradleExecutionEnvironmentProvider", "escapeString"));
        }
        return string2;
    }
}

