/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ObjectIntHashMap;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import com.jetbrains.javascript.debugger.FileUrlMapperSourceResolver;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntProcedure;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GwtFileUrlMapper
extends FileUrlMapper {
    private static final int DEFAULT_PORT_NUMBER = 9876;
    private static final Key<Integer> PORT_KEY = Key.create((String)"gwtCodeServerPort");
    private static final String PATH_PREFIX = "/sourcemaps/";

    GwtFileUrlMapper() {
    }

    @NotNull
    public List<Url> getUrls(@NotNull VirtualFile file, @NotNull Project project, @Nullable String currentAuthority) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/run/GwtFileUrlMapper", "getUrls"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/run/GwtFileUrlMapper", "getUrls"));
        }
        if (file.getFileType() != JavaFileType.INSTANCE) {
            List<Url> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/run/GwtFileUrlMapper", "getUrls"));
            }
            return list;
        }
        THashSet ports = new THashSet();
        ports.add(String.valueOf(9876));
        for (ProcessHandler processHandler : ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            Integer port = (Integer)PORT_KEY.get((UserDataHolder)processHandler);
            if (port == null) continue;
            ports.add(String.valueOf(port));
        }
        List<Url> list = GwtFileUrlMapper.doCreateUrl(file, project, (Collection<String>)ports);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/run/GwtFileUrlMapper", "getUrls"));
        }
        return list;
    }

    @NotNull
    private static List<Url> doCreateUrl(@NotNull VirtualFile file, @NotNull Project project, Collection<String> ports) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/run/GwtFileUrlMapper", "doCreateUrl"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/run/GwtFileUrlMapper", "doCreateUrl"));
        }
        List urls = (List)DumbService.getInstance((Project)project).tryRunReadActionInSmartMode(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/run/GwtFileUrlMapper", "lambda$doCreateUrl$0"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/run/GwtFileUrlMapper", "lambda$doCreateUrl$0"));
            }
            GwtModulesManager gwtModulesManager = GwtModulesManager.getInstance(project);
            VirtualFile sourceRoot = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(file);
            if (sourceRoot == null || sourceRoot.getFileSystem() == StandardFileSystems.jar()) {
                return Collections.emptyList();
            }
            List<GwtModule> gwtModules = gwtModulesManager.findGwtModulesByClientSourceFile(file);
            if (gwtModules.isEmpty()) {
                return Collections.emptyList();
            }
            String relativeUrlPath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)sourceRoot, (char)'/');
            if (relativeUrlPath == null) {
                return Collections.emptyList();
            }
            Url[] result = new Url[gwtModules.size() * ports.size()];
            for (int i = 0; i < gwtModules.size(); ++i) {
                String path = PATH_PREFIX + gwtModules.get(i).getOutputName() + '/' + relativeUrlPath;
                for (String port : ports) {
                    result[i] = Urls.newHttpUrl((String)("localhost:" + port), (String)path);
                }
            }
            return Arrays.asList(result);
        }, "GWT file mapping is not possible during index update");
        List list = urls == null ? Collections.emptyList() : urls;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/run/GwtFileUrlMapper", "doCreateUrl"));
        }
        return list;
    }

    @Nullable
    public FileUrlMapperSourceResolver createSourceResolver(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/run/GwtFileUrlMapper", "createSourceResolver"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/run/GwtFileUrlMapper", "createSourceResolver"));
        }
        if (file.getFileType() != JavaFileType.INSTANCE) {
            return null;
        }
        return (FileUrlMapperSourceResolver)DumbService.getInstance((Project)project).tryRunReadActionInSmartMode(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/run/GwtFileUrlMapper", "lambda$createSourceResolver$1"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/run/GwtFileUrlMapper", "lambda$createSourceResolver$1"));
            }
            VirtualFile sourceRoot = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(file);
            if (sourceRoot == null) {
                return null;
            }
            GwtModulesManager gwtModulesManager = GwtModulesManager.getInstance(project);
            String relativePath = gwtModulesManager.isUnderGwtModule(file) ? VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)sourceRoot, (char)'/') : null;
            return relativePath == null ? null : new MySourceResolver(relativePath);
        }, "GWT file mapping is not possible during index update");
    }

    @Nullable
    private static PsiClass findClass(@NotNull Url url, @NotNull Project project) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/gwt/run/GwtFileUrlMapper", "findClass"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/run/GwtFileUrlMapper", "findClass"));
        }
        String path = url.getPath();
        if (!path.startsWith(PATH_PREFIX) || !path.endsWith(".java")) {
            return null;
        }
        int index = path.indexOf(47, PATH_PREFIX.length() + 1);
        if (index < 0 || path.length() < index + 2 + ".java".length()) {
            return null;
        }
        String moduleName = path.substring(PATH_PREFIX.length(), index);
        String className = path.substring(index + 1, path.length() - ".java".length()).replace('/', '.');
        return (PsiClass)DumbService.getInstance((Project)project).tryRunReadActionInSmartMode(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/run/GwtFileUrlMapper", "lambda$findClass$2"));
            }
            GwtModulesManager gwtModulesManager = GwtModulesManager.getInstance(project);
            for (GwtModule gwtModule : gwtModulesManager.findGwtModulesByOutputName(moduleName, GlobalSearchScope.projectScope((Project)project))) {
                Module module = gwtModule.getModule();
                if (module == null) continue;
                PsiClass[] psiClasses = JavaPsiFacade.getInstance((Project)project).findClasses(className, module.getModuleWithLibrariesScope());
                if (psiClasses.length == 1) {
                    return psiClasses[0];
                }
                if (psiClasses.length <= 1) continue;
                for (PsiClass psiClass : psiClasses) {
                    if (!psiClass.canNavigateToSource() || psiClass.getNavigationElement().getContainingFile().getFileType() != JavaFileType.INSTANCE) continue;
                    return psiClass;
                }
                Arrays.sort(psiClasses, new Comparator<PsiClass>(){

                    private int getWeight(@NotNull PsiClass psiClass) {
                        if (psiClass == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/gwt/run/GwtFileUrlMapper$1", "getWeight"));
                        }
                        if (psiClass.canNavigateToSource()) {
                            return 2;
                        }
                        return psiClass.canNavigate() ? 1 : 0;
                    }

                    @Override
                    public int compare(@NotNull PsiClass c1, @NotNull PsiClass c2) {
                        if (c1 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c1", "com/intellij/gwt/run/GwtFileUrlMapper$1", "compare"));
                        }
                        if (c2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c2", "com/intellij/gwt/run/GwtFileUrlMapper$1", "compare"));
                        }
                        return this.getWeight(c1) - this.getWeight(c2);
                    }
                });
                return psiClasses[psiClasses.length - 1];
            }
            return null;
        }, "GWT file mapping is not possible during index update");
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull Url url, @NotNull Project project, @Nullable Url requestor) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/gwt/run/GwtFileUrlMapper", "getNavigatable"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/run/GwtFileUrlMapper", "getNavigatable"));
        }
        return GwtFileUrlMapper.findClass(url, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VirtualFile getFile(@NotNull Url url, @NotNull Project project, @Nullable Url requestor) {
        PsiFile psiFile;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/gwt/run/GwtFileUrlMapper", "getFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/run/GwtFileUrlMapper", "getFile"));
        }
        PsiClass psiClass = GwtFileUrlMapper.findClass(url, project);
        if (psiClass == null) {
            return null;
        }
        AccessToken token = ReadAction.start();
        try {
            psiFile = psiClass.getNavigationElement().getContainingFile();
            if (psiFile == null) {
                psiFile = psiClass.getContainingFile();
            }
        }
        finally {
            token.finish();
        }
        return psiFile == null ? null : psiFile.getVirtualFile();
    }

    private static class MySourceResolver
    implements FileUrlMapperSourceResolver {
        private final String relativeUrlPath;

        public MySourceResolver(@NotNull String relativeUrlPath) {
            if (relativeUrlPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeUrlPath", "com/intellij/gwt/run/GwtFileUrlMapper$MySourceResolver", "<init>"));
            }
            this.relativeUrlPath = relativeUrlPath;
        }

        public int resolve(@NotNull ObjectIntHashMap<Url> map, @NotNull Project project) {
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/gwt/run/GwtFileUrlMapper$MySourceResolver", "resolve"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/run/GwtFileUrlMapper$MySourceResolver", "resolve"));
            }
            final AtomicInteger result = new AtomicInteger(-1);
            map.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<Url>(){

                public boolean execute(Url url, int index) {
                    int postfixLength;
                    String path = url.getPath();
                    int pathLength = path.length();
                    if (pathLength > (postfixLength = relativeUrlPath.length()) && path.charAt(pathLength - postfixLength - 1) == '/' && path.endsWith(relativeUrlPath)) {
                        result.set(index);
                        return false;
                    }
                    return true;
                }
            });
            return result.get();
        }
    }
}

