/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder.mapping;

import com.intellij.gwt.uiBinder.mapping.UiTemplateInterfaceJamElement;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UiBinderMappingService {
    public static UiBinderMappingService getInstance(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingService", "getInstance"));
        }
        return (UiBinderMappingService)ModuleServiceManager.getService((Module)module, UiBinderMappingService.class);
    }

    @NotNull
    public abstract List<PsiClass> getBoundClasses(@NotNull PsiFile var1);

    @NotNull
    public abstract List<XmlFile> getUiXmlFiles(@NotNull PsiClass var1);

    @Nullable
    public abstract XmlFile getUiXmlFile(@NotNull PsiClass var1);

    public abstract boolean isUiRendererComponent(@NotNull PsiClass var1);

    @NotNull
    public static List<PsiClass> getBoundClassesForFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingService", "getBoundClassesForFile"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        List<PsiClass> list = module != null ? UiBinderMappingService.getInstance(module).getBoundClasses(file) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingService", "getBoundClassesForFile"));
        }
        return list;
    }

    @NotNull
    public static List<XmlFile> getUiXmlFilesForClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingService", "getUiXmlFilesForClass"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        List<XmlFile> list = module != null ? UiBinderMappingService.getInstance(module).getUiXmlFiles(psiClass) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingService", "getUiXmlFilesForClass"));
        }
        return list;
    }

    @Nullable
    public static String deduceTemplateFileUrl(@NotNull PsiClass binderClass) {
        if (binderClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binderClass", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingService", "deduceTemplateFileUrl"));
        }
        UiTemplateInterfaceJamElement element = UiTemplateInterfaceJamElement.getElement(binderClass);
        XmlFile xmlFile = element == null ? UiBinderMappingService.getDefaultTemplateFile(binderClass) : UiBinderMappingService.getAnnotationTemplateFile(element.getUiTemplateValue(), binderClass);
        VirtualFile virtualFile = xmlFile == null ? null : xmlFile.getVirtualFile();
        return virtualFile == null ? null : virtualFile.getUrl();
    }

    @Nullable
    public static XmlFile getDefaultTemplateFile(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingService", "getDefaultTemplateFile"));
        }
        PsiClass containingClass = aClass.getContainingClass();
        if (containingClass != null) {
            aClass = containingClass;
        }
        Project project = aClass.getProject();
        String packageName = JavaHierarchyUtil.getPackageName((PsiClass)aClass);
        if (packageName == null) {
            return null;
        }
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)project).findPackage(packageName);
        if (psiPackage == null) {
            return null;
        }
        String fileName = aClass.getName() + ".ui.xml";
        return UiBinderMappingService.findTemplateXmlFile(psiPackage, fileName, aClass.getResolveScope());
    }

    @Nullable
    private static XmlFile getAnnotationTemplateFile(@Nullable String uiTemplateValue, @NotNull PsiClass binderClass) {
        String fileName;
        String packageName;
        if (binderClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binderClass", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingService", "getAnnotationTemplateFile"));
        }
        if (uiTemplateValue == null) {
            return null;
        }
        if (!uiTemplateValue.endsWith(".ui.xml")) {
            return null;
        }
        String unsuffixed = StringUtil.trimEnd((String)uiTemplateValue, (String)".ui.xml");
        if (unsuffixed.contains(".")) {
            packageName = StringUtil.getPackageName((String)unsuffixed);
            fileName = StringUtil.getShortName((String)unsuffixed);
        } else {
            String templateName = JavaHierarchyUtil.getPackageName((PsiClass)binderClass) + "." + unsuffixed.replace('/', '.');
            packageName = StringUtil.getPackageName((String)templateName);
            fileName = StringUtil.getShortName((String)templateName);
        }
        fileName = fileName.replace('$', '.');
        Project project = binderClass.getProject();
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)project).findPackage(packageName);
        if (psiPackage == null) {
            return null;
        }
        return UiBinderMappingService.findTemplateXmlFile(psiPackage, fileName, binderClass.getResolveScope());
    }

    @Nullable
    private static XmlFile findTemplateXmlFile(@NotNull PsiPackage psiPackage, @NotNull String fileName, @NotNull GlobalSearchScope searchScope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingService", "findTemplateXmlFile"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingService", "findTemplateXmlFile"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingService", "findTemplateXmlFile"));
        }
        if (!fileName.endsWith(".ui.xml")) {
            fileName = fileName + ".ui.xml";
        }
        for (PsiDirectory psiDirectory : psiPackage.getDirectories(searchScope)) {
            PsiFile xmlFile = psiDirectory.findFile(fileName);
            if (!(xmlFile instanceof XmlFile)) continue;
            return (XmlFile)xmlFile;
        }
        return null;
    }
}

