/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.convertcontentstoattribute;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.sixrr.xrp.base.XRPBaseRefactoringProcessor;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.convertcontentstoattribute.ConvertContentsToAttribute;
import com.sixrr.xrp.convertcontentstoattribute.ConvertContentsToAttributeUsageViewDescriptor;
import com.sixrr.xrp.psi.TagSearchVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ConvertContentsToAttributeProcessor
extends XRPBaseRefactoringProcessor {
    private final XmlTag tag;
    private final String attributeName;
    private final Context context;
    private final boolean trim;

    ConvertContentsToAttributeProcessor(XmlTag tag, String attributeName, Context context, boolean trim) {
        super(tag.getProject());
        this.tag = tag;
        this.attributeName = attributeName;
        this.context = context;
        this.trim = trim;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/sixrr/xrp/convertcontentstoattribute/ConvertContentsToAttributeProcessor", "createUsageViewDescriptor"));
        }
        ConvertContentsToAttributeUsageViewDescriptor convertContentsToAttributeUsageViewDescriptor = new ConvertContentsToAttributeUsageViewDescriptor(this.tag, usageInfos);
        if (convertContentsToAttributeUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/convertcontentstoattribute/ConvertContentsToAttributeProcessor", "createUsageViewDescriptor"));
        }
        return convertContentsToAttributeUsageViewDescriptor;
    }

    @Override
    public void findUsages(@NotNull List<XRPUsageInfo> usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/sixrr/xrp/convertcontentstoattribute/ConvertContentsToAttributeProcessor", "findUsages"));
        }
        String tagName = this.tag.getName();
        TagSearchVisitor visitor = new TagSearchVisitor(tagName);
        for (XmlFile file : this.context) {
            file.accept((PsiElementVisitor)visitor);
        }
        List<XmlTag> tagsFound = visitor.getTags();
        for (XmlTag xmlTag : tagsFound) {
            usages.add(new ConvertContentsToAttribute(xmlTag, this.attributeName, this.trim));
        }
    }

    protected String getCommandName() {
        return "Convert contents of tag " + this.tag.getName() + " to attribute " + this.attributeName;
    }
}

