/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.module;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.HashSet;
import com.intellij.util.descriptors.ConfigFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.build.PluginBuildConfiguration;
import org.jetbrains.idea.devkit.build.PluginBuildUtil;
import org.jetbrains.idea.devkit.module.PluginDescriptorConstants;
import org.jetbrains.idea.devkit.module.PluginModuleBuilder;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class PluginModuleType
extends ModuleType<PluginModuleBuilder> {
    @NonNls
    private static final String ID = "PLUGIN_MODULE";

    public PluginModuleType() {
        super(ID);
    }

    public static PluginModuleType getInstance() {
        return (PluginModuleType)ModuleTypeManager.getInstance().findByID(ID);
    }

    public static boolean isOfType(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/devkit/module/PluginModuleType", "isOfType"));
        }
        return PluginModuleType.get((Module)module) instanceof PluginModuleType;
    }

    @NotNull
    public PluginModuleBuilder createModuleBuilder() {
        PluginModuleBuilder pluginModuleBuilder = new PluginModuleBuilder();
        if (pluginModuleBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/module/PluginModuleType", "createModuleBuilder"));
        }
        return pluginModuleBuilder;
    }

    @NotNull
    public String getName() {
        String string = DevKitBundle.message("module.title", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/module/PluginModuleType", "getName"));
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = DevKitBundle.message("module.description", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/module/PluginModuleType", "getDescription"));
        }
        return string;
    }

    public Icon getNodeIcon(boolean isOpened) {
        return AllIcons.Nodes.Plugin;
    }

    @Nullable
    public static XmlFile getPluginXml(Module module) {
        if (module == null) {
            return null;
        }
        if (!PluginModuleType.isOfType(module)) {
            for (ContentEntry entry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
                for (SourceFolder folder : entry.getSourceFolders(JavaModuleSourceRootTypes.PRODUCTION)) {
                    PsiFile psiFile;
                    String packagePrefix;
                    String prefixPath;
                    String relativePath;
                    VirtualFile pluginXmlVF;
                    VirtualFile file = folder.getFile();
                    if (file == null || (pluginXmlVF = file.findFileByRelativePath(relativePath = (prefixPath = (packagePrefix = folder.getPackagePrefix()).isEmpty() ? "" : packagePrefix.replace('.', '/') + '/') + PluginDescriptorConstants.PLUGIN_XML_PATH)) == null || !((psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(pluginXmlVF)) instanceof XmlFile)) continue;
                    return (XmlFile)psiFile;
                }
            }
            return null;
        }
        PluginBuildConfiguration buildConfiguration = PluginBuildConfiguration.getInstance(module);
        if (buildConfiguration == null) {
            return null;
        }
        ConfigFile configFile = buildConfiguration.getPluginXmlConfigFile();
        return configFile != null ? configFile.getXmlFile() : null;
    }

    public static boolean isPluginModuleOrDependency(@Nullable Module module) {
        if (module == null) {
            return false;
        }
        if (PluginModuleType.isOfType(module)) {
            return true;
        }
        return PluginModuleType.getCandidateModules(module).size() > 0;
    }

    public static List<Module> getCandidateModules(Module module) {
        Module[] modules = ModuleManager.getInstance((Project)module.getProject()).getModules();
        ArrayList<Module> candidates = new ArrayList<Module>(modules.length);
        HashSet deps = new HashSet(modules.length);
        for (Module m : modules) {
            if (PluginModuleType.get((Module)m) != PluginModuleType.getInstance()) continue;
            deps.clear();
            PluginBuildUtil.getDependencies(m, (Set<Module>)deps);
            if (!deps.contains(module) || PluginModuleType.getPluginXml(m) == null) continue;
            candidates.add(m);
        }
        return candidates;
    }

    public boolean isValidSdk(@NotNull Module module, Sdk projectSdk) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/devkit/module/PluginModuleType", "isValidSdk"));
        }
        return JavaModuleType.isValidJavaSdk((Module)module);
    }
}

