/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.facet.AddFacesSupportUtil;
import com.intellij.jsf.resources.FacesBundle;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFacesConfigAction
extends CreateElementActionBase {
    @NonNls
    public static final String DEFAUL_WEB_ROOT_NAME = "WEB-INF";

    public CreateFacesConfigAction() {
        super(FacesBundle.message("create.faces.congig.xml", new Object[0]), FacesBundle.message("create.faces.congig.xml", new Object[0]), AllIcons.FileTypes.FacesConfig);
    }

    @NotNull
    protected PsiElement[] invokeDialog(Project project, PsiDirectory directory) {
        CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, CreateFacesConfigAction.getDirectory(directory));
        Messages.showInputDialog((Project)project, (String)FacesBundle.message("prompt.enter.new.faces.config.name", new Object[0]), (String)FacesBundle.message("create.faces.congig.xml", new Object[0]), (Icon)Messages.getQuestionIcon(), (String)"faces-config.xml", (InputValidator)validator);
        PsiElement[] psiElementArray = validator.getCreatedElements();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/actions/CreateFacesConfigAction", "invokeDialog"));
        }
        return psiElementArray;
    }

    private static PsiDirectory getDirectory(PsiDirectory oldDirectory) {
        PsiDirectory psiDirectory = null;
        Module module = CreateFacesConfigAction.getModule(oldDirectory);
        if (module != null && !WebUtil.isInsideWebRoots((VirtualFile)oldDirectory.getVirtualFile(), (Project)module.getProject())) {
            for (WebFacet webFacet : WebFacet.getInstances((Module)module)) {
                VirtualFile webRootDirectory = CreateFacesConfigAction.getDefaultWebRootDirectory(webFacet);
                if (webRootDirectory == null) continue;
                psiDirectory = PsiManager.getInstance((Project)module.getProject()).findDirectory(webRootDirectory);
                break;
            }
        }
        return psiDirectory == null ? oldDirectory : psiDirectory;
    }

    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        PsiFile psiFile = directory.createFile(CreateFacesConfigAction.getName(newName));
        Document document = PsiDocumentManager.getInstance((Project)directory.getProject()).getDocument(psiFile);
        String text = JsfCommonUtils.getFacesConfigTemplateTextForModule(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile));
        document.setText((CharSequence)text);
        WebFacet webFacet = WebUtil.getWebFacet((PsiElement)psiFile);
        if (webFacet != null) {
            AddFacesSupportUtil.write2WebXml(webFacet, psiFile.getVirtualFile());
        }
        PsiDocumentManager.getInstance((Project)psiFile.getProject()).commitAllDocuments();
        PsiElement[] psiElementArray = new PsiElement[]{psiFile};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/actions/CreateFacesConfigAction", "create"));
        }
        return psiElementArray;
    }

    @Nullable
    private static Module getModule(PsiDirectory directory) {
        return ProjectRootManagerEx.getInstanceEx((Project)directory.getProject()).getFileIndex().getModuleForFile(directory.getVirtualFile());
    }

    protected String getErrorTitle() {
        return FacesBundle.message("cannot.create.faces.congig.xml", new Object[0]);
    }

    protected String getCommandName() {
        return FacesBundle.message("create.faces.congig.xml", new Object[0]);
    }

    protected String getActionName(PsiDirectory directory, String newName) {
        return FacesBundle.message("create.faces.congig.xml", new Object[0]);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (presentation.isEnabled()) {
            DataContext context = e.getDataContext();
            Module module = (Module)LangDataKeys.MODULE.getData(context);
            IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(context);
            if (module != null && view != null) {
                Collection facets = WebFacet.getInstances((Module)module);
                for (WebFacet webFacet : facets) {
                    if (CreateFacesConfigAction.getDefaultWebRootDirectory(webFacet) == null) continue;
                    return;
                }
                for (PsiDirectory dir : view.getDirectories()) {
                    if (!WebUtil.isInsideWebRoots((VirtualFile)dir.getVirtualFile(), (Project)module.getProject())) continue;
                    return;
                }
            }
            presentation.setEnabled(false);
            presentation.setVisible(false);
        }
    }

    @Nullable
    private static VirtualFile getDefaultWebRootDirectory(@NotNull WebFacet webFacet) {
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/jsf/actions/CreateFacesConfigAction", "getDefaultWebRootDirectory"));
        }
        List list = webFacet.getWebRoots();
        for (WebRoot webRoot : list) {
            if (!webRoot.getURI().equals("/WEB-INF")) continue;
            return webRoot.getFile();
        }
        if (!list.isEmpty()) {
            return ((WebRoot)list.get(0)).getFile();
        }
        return null;
    }

    private static String getName(String oldName) {
        LanguageFileType fileType = StdFileTypes.XML;
        if (FileTypeManager.getInstance().getFileTypeByFileName(oldName) == fileType) {
            return oldName;
        }
        return oldName + "." + fileType.getDefaultExtension();
    }
}

