/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFileReference
extends FileReference
implements JSModuleBaseReference {
    public static final String[] IMPLICIT_EXTENSIONS = new String[]{".coffee", ".d.ts", ".d.tsx", ".ts", ".tsx", ".jsx", ".es6", ".js.flow", ".js"};
    private final String[] myImplicitExtensions;

    public JSFileReference(String text, int offset, TextRange textRange, @NotNull FileReferenceSet fileReferenceSet) {
        if (fileReferenceSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileReferenceSet", "com/intellij/javascript/JSFileReference", "<init>"));
        }
        this(text, offset, textRange, fileReferenceSet, IMPLICIT_EXTENSIONS);
    }

    public JSFileReference(String text, int offset, TextRange textRange, @NotNull FileReferenceSet fileReferenceSet, String[] implicitExtensions) {
        if (fileReferenceSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileReferenceSet", "com/intellij/javascript/JSFileReference", "<init>"));
        }
        super(fileReferenceSet, textRange, offset, text);
        this.myImplicitExtensions = JSFileReference.withCurrentFileExtension(implicitExtensions, fileReferenceSet.getElement());
    }

    protected void innerResolveInContext(@NotNull String referenceText, @NotNull PsiFileSystemItem context, Collection<ResolveResult> results, boolean caseSensitive) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/intellij/javascript/JSFileReference", "innerResolveInContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSFileReference", "innerResolveInContext"));
        }
        if (!this.isLast()) {
            this.simpleInnerResolveInContext(referenceText, context, results, caseSensitive);
            return;
        }
        if (this.isAcceptableEmptyReference(referenceText)) {
            if (this.isAllowFolders()) {
                this.simpleInnerResolveInContext(referenceText, context, results, caseSensitive);
            }
            return;
        }
        int size = results.size();
        for (String extension : this.getImplicitExtensions()) {
            if (referenceText.endsWith(extension)) continue;
            this.simpleInnerResolveInContext(referenceText + extension, context, results, caseSensitive);
            if (size != results.size()) {
                this.filterImplicitElementsResolveInContext(referenceText, context, results, caseSensitive);
            }
            if (this.shouldStopImplicitExtensionProcessing(size != results.size(), extension)) break;
        }
        if (size == results.size()) {
            this.simpleInnerResolveInContext(referenceText, context, results, caseSensitive);
            Iterator<ResolveResult> iterator = results.iterator();
            while (iterator.hasNext() && size > 0) {
                iterator.next();
                --size;
            }
            this.processDirectoriesFromCurrentIterator(iterator, results);
        }
    }

    protected boolean shouldStopImplicitExtensionProcessing(boolean sizeWasChanged, String currentExtension) {
        return sizeWasChanged;
    }

    protected boolean isAcceptableEmptyReference(@NotNull String referenceText) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/intellij/javascript/JSFileReference", "isAcceptableEmptyReference"));
        }
        return referenceText.isEmpty() && !this.getFileReferenceSet().isEndingSlashNotAllowed();
    }

    protected final void simpleInnerResolveInContext(@NotNull String referenceText, @NotNull PsiFileSystemItem context, Collection<ResolveResult> results, boolean caseSensitive) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/intellij/javascript/JSFileReference", "simpleInnerResolveInContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSFileReference", "simpleInnerResolveInContext"));
        }
        super.innerResolveInContext(referenceText, context, results, caseSensitive);
    }

    protected void filterImplicitElementsResolveInContext(String text, PsiFileSystemItem context, Collection<ResolveResult> results, boolean sensitive) {
    }

    protected String[] getImplicitExtensions() {
        return this.myImplicitExtensions;
    }

    protected void processDirectoriesFromCurrentIterator(Iterator<ResolveResult> iterator, Collection<ResolveResult> results) {
        if (!this.isAllowFolders()) {
            while (iterator.hasNext()) {
                ResolveResult result = iterator.next();
                PsiElement element = result.getElement();
                if (!(element instanceof PsiFileSystemItem) || !((PsiFileSystemItem)element).isDirectory()) continue;
                iterator.remove();
            }
        }
    }

    protected boolean isAllowFolders() {
        return false;
    }

    @NotNull
    public String getFileNameToCreate() {
        VirtualFile vFile;
        PsiFile psiFile;
        String text = this.getText();
        if (!StringUtil.containsChar((String)text, (char)'.') && this.isLast() && (psiFile = this.getElement().getContainingFile()) != null && (vFile = psiFile.getVirtualFile()) != null) {
            String string = text + "." + vFile.getExtension();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSFileReference", "getFileNameToCreate"));
            }
            return string;
        }
        String string = super.getFileNameToCreate();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSFileReference", "getFileNameToCreate"));
        }
        return string;
    }

    protected PsiElement rename(String newName) throws IncorrectOperationException {
        if (!this.isLast()) {
            newName = this.fixRelativePath(newName);
            return super.rename(newName);
        }
        newName = this.fixExtension(newName);
        newName = this.fixRelativePath(newName);
        return super.rename(newName);
    }

    private String fixRelativePath(String newName) {
        FileReference reference;
        String refText;
        if (!this.getFileReferenceSet().isAbsolutePathReference() && (".".equals(refText = (reference = this.getFileReferenceSet().getReference(0)).getText()) || refText != null && refText.startsWith("..")) && !newName.startsWith("..")) {
            newName = "./" + newName;
        }
        return newName;
    }

    protected String fixExtension(String newName) {
        return this.fixExtension(newName, this.getText());
    }

    protected String fixExtension(String newName, String oldRefText) {
        String[] extensions = this.getSortedByLengthImplicitExtensions();
        String newImplicitExtension = JSFileReference.findExtension(newName, extensions);
        String textImplicitExtension = JSFileReference.findExtension(oldRefText, extensions);
        if (newImplicitExtension != null && textImplicitExtension == null || oldRefText.indexOf(46) == -1) {
            int indexNameWithoutExtension;
            int n = indexNameWithoutExtension = newImplicitExtension != null ? newName.length() - newImplicitExtension.length() : newName.lastIndexOf(46);
            if (indexNameWithoutExtension != -1) {
                int lastIndexOfSeparator = newImplicitExtension != null ? -1 : newName.lastIndexOf(47);
                newName = indexNameWithoutExtension > lastIndexOfSeparator ? newName.substring(0, indexNameWithoutExtension) : newName;
            }
        }
        return newName;
    }

    @NotNull
    protected String[] getSortedByLengthImplicitExtensions() {
        String[] extensions = this.getImplicitExtensions();
        Arrays.sort(extensions, Comparator.comparing(String::length).reversed());
        if (extensions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSFileReference", "getSortedByLengthImplicitExtensions"));
        }
        return extensions;
    }

    protected PsiElement fixRefText(String name) {
        return super.fixRefText(this.fixExtension(name));
    }

    public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
        String path;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/JSFileReference", "bindToElement"));
        }
        if (!this.isRelativeCommonPath() && JSFileReference.checkReferencedFileFromNodeModules(element)) {
            return this.getElement();
        }
        if ((!this.isRelativeCommonPath() || absolute) && (path = JSFileReference.getPathFromDefaultContext(this.getFileReferenceSet(), element, absolute)) != null) {
            return this.rename(path);
        }
        return super.bindToElement(element, absolute);
    }

    protected static String getPathFromDefaultContext(@NotNull FileReferenceSet referenceSet, @NotNull PsiElement element, boolean absolute) {
        Collection filteredContexts;
        VirtualFile dstVFile;
        String path;
        if (referenceSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceSet", "com/intellij/javascript/JSFileReference", "getPathFromDefaultContext"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/JSFileReference", "getPathFromDefaultContext"));
        }
        Collection<PsiFileSystemItem> defaultContexts = JSFileReference.getDefaultResolveContextsForBind(referenceSet, element);
        if (defaultContexts.size() > 0 && (path = JSFileReferencesUtil.getShortestPathInContexts(dstVFile = element instanceof PsiFileSystemItem ? ((PsiFileSystemItem)element).getVirtualFile() : null, filteredContexts = (Collection)defaultContexts.stream().map(el -> el.getVirtualFile()).collect(Collectors.toList()), true)) != null) {
            return absolute && referenceSet.absoluteUrlNeedsStartSlash() && !path.startsWith("/") ? "/" + path : path;
        }
        return null;
    }

    @NotNull
    protected static Collection<PsiFileSystemItem> getDefaultResolveContextsForBind(@NotNull FileReferenceSet referenceSet, @NotNull PsiElement element) {
        if (referenceSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceSet", "com/intellij/javascript/JSFileReference", "getDefaultResolveContextsForBind"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/JSFileReference", "getDefaultResolveContextsForBind"));
        }
        Collection allDefaultContexts = referenceSet.getDefaultContexts();
        FileReference firstRef = referenceSet.getReference(0);
        PsiFileSystemItem resolvedFirstRef = firstRef.resolve();
        if (resolvedFirstRef != null && resolvedFirstRef != element) {
            PsiFileSystemItem contextDir = resolvedFirstRef.getParent();
            List list = allDefaultContexts.contains(contextDir) ? ContainerUtil.createMaybeSingletonList((Object)contextDir) : ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSFileReference", "getDefaultResolveContextsForBind"));
            }
            return list;
        }
        LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet((Iterable)allDefaultContexts);
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSFileReference", "getDefaultResolveContextsForBind"));
        }
        return linkedHashSet;
    }

    private boolean isRelativeCommonPath() {
        String path = this.getFileReferenceSet().getPathString();
        return path.startsWith(".");
    }

    private static boolean checkReferencedFileFromNodeModules(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/JSFileReference", "checkReferencedFileFromNodeModules"));
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        return file != null && JSLibraryUtil.hasDirectoryInPath(file, "node_modules", null);
    }

    @Contract(value="null, _ -> null")
    public static String findExtension(@Nullable String fileName, String[] extensions) {
        if (fileName == null) {
            return null;
        }
        for (String extension : extensions) {
            if (!StringUtil.endsWithIgnoreCase((String)fileName, (String)extension)) continue;
            return extension;
        }
        return null;
    }

    @Contract(value="!null,_ -> !null")
    public static String getFileNameWithoutExtension(@Nullable String fileName, String[] extensions) {
        if (fileName == null) {
            return null;
        }
        String extension = JSFileReference.findExtension(fileName, extensions);
        return extension != null ? fileName.substring(0, fileName.length() - extension.length()) : FileUtilRt.getNameWithoutExtension((String)fileName);
    }

    @Contract(value="null -> null")
    public static String findImplicitExtension(@Nullable String fileName) {
        return JSFileReference.findExtension(fileName, IMPLICIT_EXTENSIONS);
    }

    public static String[] withCurrentFileExtension(String[] implicitExtensions, PsiElement element) {
        String extension = FileUtilRt.getExtension((String)element.getContainingFile().getName());
        return !StringUtil.isEmpty((String)extension) && !ArrayUtil.contains((Object)implicitExtensions, (Object[])new Serializable[]{extension}) ? (String[])ArrayUtil.append((Object[])implicitExtensions, (Object)("." + extension)) : implicitExtensions;
    }
}

