/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class NodeModulesLibraryDirectory {
    private static final Logger LOG = Logger.getInstance(NodeModulesLibraryDirectory.class);
    private static final Set<String> EXCLUDED_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"test", "tests", "spec", "specs", "node_modules"});
    private static final String TYPESCRIPT_DEPENDENCY = "typescript";
    private final Project myProject;
    private final VirtualFile myNodeModulesDir;
    private final String myLibraryName;
    private final AtomicInteger myLibraryCalcCount;
    private volatile SyntheticLibrary myLibrary;

    public NodeModulesLibraryDirectory(@NotNull Project project, @NotNull VirtualFile nodeModulesDir, @NotNull String libraryName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory", "<init>"));
        }
        if (nodeModulesDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModulesDir", "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory", "<init>"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory", "<init>"));
        }
        this.myLibraryCalcCount = new AtomicInteger(0);
        this.myProject = project;
        this.myNodeModulesDir = nodeModulesDir;
        this.myLibraryName = libraryName;
    }

    @NotNull
    public VirtualFile getNodeModulesDir() {
        VirtualFile virtualFile = this.myNodeModulesDir;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory", "getNodeModulesDir"));
        }
        return virtualFile;
    }

    public boolean isForApplicationSourceCode() {
        return NodeModulesDirectoryManager.isForApplicationSourceCode(this.myNodeModulesDir);
    }

    @NotNull
    public String getLibraryName() {
        String string = this.myLibraryName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory", "getLibraryName"));
        }
        return string;
    }

    public void invalidateRoots() {
        this.myLibrary = null;
        this.myLibraryCalcCount.set(0);
    }

    @NotNull
    public SyntheticLibrary getLibrary() {
        SyntheticLibrary library = this.myLibrary;
        if (library == null) {
            this.myLibrary = library = this.createLibrary();
        }
        SyntheticLibrary syntheticLibrary = library;
        if (syntheticLibrary == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory", "getLibrary"));
        }
        return syntheticLibrary;
    }

    @NotNull
    private SyntheticLibrary createLibrary() {
        int calcCount = this.myLibraryCalcCount.incrementAndGet();
        if (calcCount > 1) {
            LOG.warn("Concurrent node_modules roots calculation: " + calcCount);
        }
        SyntheticLibrary syntheticLibrary = this.doCreateLibrary();
        if (syntheticLibrary == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory", "createLibrary"));
        }
        return syntheticLibrary;
    }

    @NotNull
    private SyntheticLibrary doCreateLibrary() {
        if (!this.myNodeModulesDir.isValid()) {
            LOG.warn("Invalid " + this.myNodeModulesDir.getPath());
            SyntheticLibrary syntheticLibrary = SyntheticLibrary.newImmutableLibrary(Collections.emptySet());
            if (syntheticLibrary == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory", "doCreateLibrary"));
            }
            return syntheticLibrary;
        }
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        HashSet<VirtualFile> excludedRoots = new HashSet<VirtualFile>();
        VirtualFile packageJson = NodeModuleUtil.findPackageJsonByNodeModules(this.myNodeModulesDir);
        if (packageJson != null && packageJson.isValid()) {
            PackageJsonData data = (PackageJsonData)ProjectLocator.computeWithPreferredProject((VirtualFile)packageJson, (Project)this.myProject, () -> PackageJsonUtil.getOrCreateData(packageJson));
            Set<String> dependencies = data.getAllDependencies();
            for (String dependency : dependencies) {
                VirtualFile dir;
                if (!NodeModulesLibraryDirectory.isDependencyIndexed(data, dependency) || (dir = this.myNodeModulesDir.findFileByRelativePath(dependency)) == null || !dir.isValid() || !dir.isDirectory()) continue;
                roots.add(dir);
                this.collectExcludedRoots(dir, excludedRoots);
            }
            VirtualFile types = this.myNodeModulesDir.findChild("@types");
            if (types != null && types.isValid() && types.isDirectory()) {
                roots.add(types);
            }
            NodeModulesDirectoryManager.getInstance(this.myProject).setProvidedPackageJsonRoots(packageJson, data);
        } else {
            VirtualFile[] children;
            for (VirtualFile child : children = (VirtualFile[])ObjectUtils.notNull((Object)this.myNodeModulesDir.getChildren(), (Object)VirtualFile.EMPTY_ARRAY)) {
                String name = child.getName();
                if (name.startsWith(".") || name.startsWith("_")) continue;
                roots.add(child);
                this.collectExcludedRoots(child, excludedRoots);
            }
        }
        SyntheticLibrary syntheticLibrary = SyntheticLibrary.newImmutableLibrary(roots, excludedRoots, null);
        if (syntheticLibrary == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory", "doCreateLibrary"));
        }
        return syntheticLibrary;
    }

    private static boolean isDependencyIndexed(@NotNull PackageJsonData data, @NotNull String dependencyName) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory", "isDependencyIndexed"));
        }
        if (dependencyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyName", "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory", "isDependencyIndexed"));
        }
        if (TYPESCRIPT_DEPENDENCY.equals(dependencyName)) {
            return data.isDependencyOfAnyTypeExcludeDev(dependencyName);
        }
        return data.isDependencyOfAnyType(dependencyName);
    }

    private void collectExcludedRoots(@NotNull VirtualFile dependency, @NotNull Set<VirtualFile> excludedRoots) {
        VirtualFile[] children;
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory", "collectExcludedRoots"));
        }
        if (excludedRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedRoots", "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory", "collectExcludedRoots"));
        }
        for (VirtualFile child : children = (VirtualFile[])ObjectUtils.notNull((Object)dependency.getChildren(), (Object)VirtualFile.EMPTY_ARRAY)) {
            String name = child.getName();
            if (!StringUtil.startsWith((CharSequence)name, (CharSequence)".") && !EXCLUDED_NAMES.contains(name)) continue;
            excludedRoots.add(child);
        }
        this.collectExcludedAdditionalMainFiles(dependency, excludedRoots);
    }

    private void collectExcludedAdditionalMainFiles(@NotNull VirtualFile dependency, @NotNull Set<VirtualFile> excludedRoots) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory", "collectExcludedAdditionalMainFiles"));
        }
        if (excludedRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedRoots", "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory", "collectExcludedAdditionalMainFiles"));
        }
        VirtualFile dependencyPackageJson = PackageJsonUtil.findChildPackageJsonFile(dependency);
        if (dependencyPackageJson == null) {
            return;
        }
        PackageJsonData data = (PackageJsonData)ProjectLocator.computeWithPreferredProject((VirtualFile)dependencyPackageJson, (Project)this.myProject, () -> PackageJsonUtil.getOrCreateData(dependencyPackageJson));
        Collection<String> additionalMainPaths = data.getAdditionalMains();
        if (additionalMainPaths.isEmpty()) {
            return;
        }
        String preferableMainFile = data.getJsNextMain();
        if (preferableMainFile == null) {
            preferableMainFile = data.getMain();
        }
        if (preferableMainFile == null) {
            return;
        }
        VirtualFile defaultFile = NodeModuleSearchUtil.findMainModuleByPath(dependency, preferableMainFile);
        if (defaultFile == null) {
            return;
        }
        ArrayList modules = ContainerUtil.newArrayListWithCapacity((int)(additionalMainPaths.size() + 1));
        String main = data.getMain();
        if (main != null) {
            modules.add(main);
        }
        modules.addAll(additionalMainPaths);
        for (String mainToExclude : modules) {
            VirtualFile candidateFile;
            if (preferableMainFile.equals(mainToExclude) || StringUtil.isEmptyOrSpaces((String)mainToExclude) || (candidateFile = NodeModuleSearchUtil.findMainModuleByPath(dependency, mainToExclude)) == null || defaultFile.equals(candidateFile) || candidateFile.isDirectory()) continue;
            excludedRoots.add(candidateFile);
        }
    }
}

