/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.google.common.collect.ConcurrentHashMultiset;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonDependenciesExternalUpdateManager {
    private final Project myProject;
    private final AtomicInteger myRunningExternalUpdateCount;
    private final ConcurrentHashMultiset<String> myRunningNamedExternalUpdates;

    public PackageJsonDependenciesExternalUpdateManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/packageJson/PackageJsonDependenciesExternalUpdateManager", "<init>"));
        }
        this.myRunningExternalUpdateCount = new AtomicInteger(0);
        this.myRunningNamedExternalUpdates = ConcurrentHashMultiset.create();
        this.myProject = project;
    }

    @NotNull
    public static PackageJsonDependenciesExternalUpdateManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/packageJson/PackageJsonDependenciesExternalUpdateManager", "getInstance"));
        }
        PackageJsonDependenciesExternalUpdateManager packageJsonDependenciesExternalUpdateManager = (PackageJsonDependenciesExternalUpdateManager)ServiceManager.getService((Project)project, PackageJsonDependenciesExternalUpdateManager.class);
        if (packageJsonDependenciesExternalUpdateManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/packageJson/PackageJsonDependenciesExternalUpdateManager", "getInstance"));
        }
        return packageJsonDependenciesExternalUpdateManager;
    }

    @NotNull
    public Runnable externalUpdateStarted(@Nullable String taskName) {
        this.myRunningExternalUpdateCount.incrementAndGet();
        if (taskName != null) {
            this.myRunningNamedExternalUpdates.add((Object)taskName);
        }
        Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.myProject);
        AtomicBoolean doneExecuted = new AtomicBoolean(false);
        Runnable done = () -> {
            if (doneExecuted.compareAndSet(false, true)) {
                this.myRunningExternalUpdateCount.decrementAndGet();
                if (taskName != null) {
                    this.myRunningNamedExternalUpdates.remove((Object)taskName);
                }
                Disposer.dispose((Disposable)alarm);
            }
        };
        alarm.addRequest(done, TimeUnit.MINUTES.toMillis(5L));
        Runnable runnable = done;
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/packageJson/PackageJsonDependenciesExternalUpdateManager", "externalUpdateStarted"));
        }
        return runnable;
    }

    public boolean isExternalUpdateRunning() {
        return this.myRunningExternalUpdateCount.get() > 0;
    }

    public boolean isExternalUpdateRunning(@NotNull String taskName) {
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/intellij/javascript/nodejs/packageJson/PackageJsonDependenciesExternalUpdateManager", "isExternalUpdateRunning"));
        }
        return this.myRunningNamedExternalUpdates.contains((Object)taskName);
    }
}

