/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.HelperFilesLocator;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.packageJson.PackageVersionRangeMatchRequest;
import com.intellij.javascript.nodejs.packageJson.PackageVersionRangeMatchResponse;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class PackageVersionRangeMatcher {
    private static final Logger LOG = Logger.getInstance(PackageVersionRangeMatcher.class);
    private static final long TOTAL_WAIT_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    private static volatile File WORKING_DIRECTORY;

    private PackageVersionRangeMatcher() {
    }

    @NotNull
    private static File getWorkingDirectory() throws IOException {
        File workingDirectory = WORKING_DIRECTORY;
        if (workingDirectory == null || !workingDirectory.isDirectory()) {
            WORKING_DIRECTORY = workingDirectory = FileUtil.createTempDirectory((String)"intellij-package-json-version-range-check", null, (boolean)true);
        }
        File file = workingDirectory;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/packageJson/PackageVersionRangeMatcher", "getWorkingDirectory"));
        }
        return file;
    }

    public static boolean match(@NotNull NodeJsLocalInterpreter interpreter, @NotNull List<PackageVersionRangeMatchRequest> requests) {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/packageJson/PackageVersionRangeMatcher", "match"));
        }
        if (requests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requests", "com/intellij/javascript/nodejs/packageJson/PackageVersionRangeMatcher", "match"));
        }
        try {
            return PackageVersionRangeMatcher.doMatch(interpreter, requests);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    private static boolean doMatch(@NotNull NodeJsLocalInterpreter interpreter, @NotNull List<PackageVersionRangeMatchRequest> requests) throws IOException, ExecutionException {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/packageJson/PackageVersionRangeMatcher", "doMatch"));
        }
        if (requests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requests", "com/intellij/javascript/nodejs/packageJson/PackageVersionRangeMatcher", "doMatch"));
        }
        GeneralCommandLine commandLine = PackageVersionRangeMatcher.createCommandLine(interpreter, requests);
        long startNano = System.nanoTime();
        CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
        ProcessOutput output = processHandler.runProcess((int)TOTAL_WAIT_TIMEOUT_MILLIS, true);
        if (output.isTimeout()) {
            throw new ExecutionException("'" + commandLine.getCommandLineString() + "' command run is timed out (>" + TOTAL_WAIT_TIMEOUT_MILLIS + " ms)");
        }
        if (output.getExitCode() != 0) {
            LOG.warn("Failed to run " + NodeCommandLineUtil.formatErrorMessage(commandLine, output));
            return false;
        }
        List<PackageVersionRangeMatchResponse> result = PackageVersionRangeMatcher.parse(output.getStdout());
        PackageVersionRangeMatcher.validateResponses(requests, result);
        List notMatched = ContainerUtil.filter(result, response -> !response.isMatched() && !response.hasErrors());
        LOG.info("Matching " + requests.size() + " done in " + TimeoutUtil.getDurationMillis((long)startNano) + " ms, not matched: " + ContainerUtil.map((Collection)notMatched, PackageVersionRangeMatchResponse::getRequest));
        return notMatched.isEmpty();
    }

    private static void validateResponses(@NotNull List<PackageVersionRangeMatchRequest> requests, @NotNull List<PackageVersionRangeMatchResponse> responses) throws ExecutionException {
        if (requests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requests", "com/intellij/javascript/nodejs/packageJson/PackageVersionRangeMatcher", "validateResponses"));
        }
        if (responses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "responses", "com/intellij/javascript/nodejs/packageJson/PackageVersionRangeMatcher", "validateResponses"));
        }
        HashSet<PackageVersionRangeMatchRequest> original = new HashSet<PackageVersionRangeMatchRequest>(requests);
        List processed = ContainerUtil.map(responses, response -> response.getRequest());
        HashSet processedSet = new HashSet(processed);
        if (!original.equals(processedSet)) {
            throw new ExecutionException("Responses do not match requests: requests: " + requests + ", responses: " + processed);
        }
    }

    @NotNull
    private static GeneralCommandLine createCommandLine(@NotNull NodeJsLocalInterpreter interpreter, @NotNull List<PackageVersionRangeMatchRequest> requests) throws IOException, ExecutionException {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/packageJson/PackageVersionRangeMatcher", "createCommandLine"));
        }
        if (requests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requests", "com/intellij/javascript/nodejs/packageJson/PackageVersionRangeMatcher", "createCommandLine"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        commandLine.setWorkDirectory(PackageVersionRangeMatcher.getWorkingDirectory());
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        commandLine.addParameter(HelperFilesLocator.resolvePathForExecution("package-version-range-matcher/bin/batch-matcher"));
        for (PackageVersionRangeMatchRequest request : requests) {
            commandLine.addParameter("--package");
            commandLine.addParameter(request.getPackageName());
            commandLine.addParameter(request.getVersionRange());
            commandLine.addParameter(request.getVersion());
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/packageJson/PackageVersionRangeMatcher", "createCommandLine"));
        }
        return generalCommandLine;
    }

    @NotNull
    private static List<PackageVersionRangeMatchResponse> parse(@NotNull String content) throws ExecutionException {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/javascript/nodejs/packageJson/PackageVersionRangeMatcher", "parse"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        JsonArray array = JsonUtil.parseJsonArray((String)content);
        for (JsonElement element : array) {
            JsonObject obj = element.getAsJsonObject();
            String packageName = JsonUtil.getChildAsString((JsonObject)obj, (String)"packageName");
            String versionRange = JsonUtil.getChildAsString((JsonObject)obj, (String)"versionRange");
            String version = JsonUtil.getChildAsString((JsonObject)obj, (String)"version");
            Boolean matched = JsonUtil.getChildAsBooleanObj((JsonObject)obj, (String)"matched");
            boolean invalidVersion = JsonUtil.getChildAsBoolean((JsonObject)obj, (String)"invalidVersion", (boolean)false);
            boolean invalidVersionRange = JsonUtil.getChildAsBoolean((JsonObject)obj, (String)"invalidVersionRange", (boolean)false);
            if (invalidVersion || invalidVersionRange) {
                matched = false;
            }
            if (packageName == null || versionRange == null || version == null || matched == null) {
                throw new ExecutionException("packageName: " + packageName + ", versionRange: " + versionRange + ", version: " + version + ", matched: " + matched);
            }
            result.add(new PackageVersionRangeMatchResponse(new PackageVersionRangeMatchRequest(packageName, versionRange, version), matched, invalidVersion, invalidVersionRange));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/packageJson/PackageVersionRangeMatcher", "parse"));
        }
        return arrayList;
    }
}

