/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterPackage {
    public static final String INTERPRETER = "node.js.path.for.package.";
    public static final String PACKAGE = "node.js.selected.package.";
    private static final String PACKAGE_DETECTED = "node.js.detected.package.";
    public static final Key<String> TEST_DEFAULT_NPM_PACKAGE = Key.create((String)"JavaScript.Npm.Default.Npm.Package");
    @NotNull
    private final PropertiesComponent myPropertiesComponent;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myPackageName;
    @NotNull
    private NodeJsInterpreterRef myInterpreter;
    @NotNull
    private String myPackagePath;
    @NotNull
    private final String myInterpreterKey;
    @NotNull
    private final String myPackageKey;

    public JSLinterPackage(@NotNull Project project, @NotNull String packageName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/util/JSLinterPackage", "<init>"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/nodejs/util/JSLinterPackage", "<init>"));
        }
        this.myInterpreter = NodeJsInterpreterRef.createProjectRef();
        this.myPackagePath = "";
        this.myProject = project;
        this.myPackageName = packageName;
        this.myPropertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        this.myInterpreterKey = INTERPRETER + this.myPackageName;
        this.myPackageKey = PACKAGE + this.myPackageName;
    }

    public void force(@Nullable NodeJsInterpreterRef interpreter, @Nullable String packagePath) {
        if (interpreter != null) {
            this.myPropertiesComponent.setValue(this.myInterpreterKey, interpreter.getReferenceName());
            this.myInterpreter = interpreter;
        }
        if (packagePath != null) {
            this.myPropertiesComponent.setValue(this.myPackageKey, packagePath);
            this.myPackagePath = packagePath;
        }
    }

    public void readOrDetect() {
        this.myInterpreter = this.loadInterpreterRef();
        this.myPackagePath = this.detectPackage();
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreter() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreter;
        if (nodeJsInterpreterRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/JSLinterPackage", "getInterpreter"));
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public String getPackagePath() {
        String string = this.myPackagePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/JSLinterPackage", "getPackagePath"));
        }
        return string;
    }

    @NotNull
    private String detectPackage() {
        String packagePath = this.myPropertiesComponent.getValue(this.myPackageKey, "");
        boolean detected = this.myPropertiesComponent.getBoolean(PACKAGE_DETECTED + this.myPackageName);
        if (StringUtil.isEmptyOrSpaces((String)packagePath) || !this.myProject.isDefault() && !detected) {
            NodePackage pkg = this.findDefaultPackage();
            if (pkg != null) {
                packagePath = pkg.getSystemDependentPath();
                if (!this.isLocal(pkg)) {
                    packagePath = this.localPackageIfInDependencies(packagePath);
                }
            } else {
                packagePath = this.localPackageIfInDependencies(packagePath);
            }
            if (!this.myProject.isDefault()) {
                this.myPropertiesComponent.setValue(PACKAGE_DETECTED + this.myPackageName, true);
            }
        }
        this.myPropertiesComponent.setValue(this.myPackageKey, packagePath);
        String string = packagePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/JSLinterPackage", "detectPackage"));
        }
        return string;
    }

    @Nullable
    private NodePackage findDefaultPackage() {
        String testPath;
        NodePackage pkg = ApplicationManager.getApplication().isUnitTestMode() && (testPath = (String)this.myProject.getUserData(TEST_DEFAULT_NPM_PACKAGE)) != null ? (StringUtil.isEmptyOrSpaces((String)testPath) ? null : new NodePackage(testPath)) : NodePackage.findDefaultPackage(this.myProject, this.myPackageName, this.myInterpreter.resolve(this.myProject));
        return pkg;
    }

    @NotNull
    private String localPackageIfInDependencies(@NotNull String packagePath) {
        if (packagePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePath", "com/intellij/javascript/nodejs/util/JSLinterPackage", "localPackageIfInDependencies"));
        }
        if (this.myProject.isDefault() || this.myProject.getBasePath() == null) {
            String string = packagePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/JSLinterPackage", "localPackageIfInDependencies"));
            }
            return string;
        }
        PackageJsonData data = PackageJsonUtil.getTopLevelPackageJsonData(this.myProject);
        if (data != null && data.getAllDependencies().contains(this.myPackageName)) {
            String basePath = FileUtil.toSystemDependentName((String)this.myProject.getBasePath());
            packagePath = (basePath.endsWith(File.separator) ? basePath : basePath + File.separator) + "node_modules" + File.separator + this.myPackageName;
        }
        String string = packagePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/JSLinterPackage", "localPackageIfInDependencies"));
        }
        return string;
    }

    private boolean isLocal(@NotNull NodePackage nodePackage) {
        if (nodePackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePackage", "com/intellij/javascript/nodejs/util/JSLinterPackage", "isLocal"));
        }
        if (this.myProject.isDefault()) {
            return false;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile packageVf = lfs.findFileByPathIfCached(nodePackage.getSystemIndependentPath());
        if (packageVf == null) {
            packageVf = lfs.refreshAndFindFileByIoFile(new File(nodePackage.getSystemDependentPath()));
        }
        if (packageVf == null) {
            return false;
        }
        return packageVf.getParent() != null && "node_modules".equals(packageVf.getParent().getName()) && VfsUtilCore.isAncestor((VirtualFile)this.myProject.getBaseDir(), (VirtualFile)packageVf, (boolean)true);
    }

    @NotNull
    private NodeJsInterpreterRef loadInterpreterRef() {
        String interpreterRefName = this.myPropertiesComponent.getValue(this.myInterpreterKey);
        if (interpreterRefName != null) {
            NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.create(interpreterRefName);
            if (nodeJsInterpreterRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/JSLinterPackage", "loadInterpreterRef"));
            }
            return nodeJsInterpreterRef;
        }
        NodeJsInterpreterRef ref = NodeJsInterpreterRef.createProjectRef();
        this.myPropertiesComponent.setValue(this.myInterpreterKey, ref.getReferenceName());
        NodeJsInterpreterRef nodeJsInterpreterRef = ref;
        if (nodeJsInterpreterRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/JSLinterPackage", "loadInterpreterRef"));
        }
        return nodeJsInterpreterRef;
    }
}

