/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.linter.stylelint;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.Language;
import com.intellij.lang.css.linter.stylelint.StylelintPackage;
import com.intellij.lang.css.linter.stylelint.StylelintResultParser;
import com.intellij.lang.css.linter.stylelint.StylelintSessionData;
import com.intellij.lang.css.linter.stylelint.StylelintState;
import com.intellij.lang.css.linter.stylelint.StylelintUtil;
import com.intellij.lang.css.linter.stylelint.config.StylelintConfigFileChangeTracker;
import com.intellij.lang.css.linter.stylelint.config.StylelintUnsavedConfigFileManager;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterNpmPackageDoesNotExistsException;
import com.intellij.lang.javascript.linter.JsqtViewProcessOutputAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TimeoutUtil;
import com.intellij.webcore.util.ProcessOutputCatcher;
import icons.JavaScriptLanguageIcons;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StylelintExternalRunner {
    private static final Logger LOG = Logger.getInstance(StylelintExternalRunner.class);
    private static final String FORMAT_PARAMETER = "-f";
    private static final String JSON_FORMAT = "json";
    private static final String SYNTAX = "--syntax";
    private static final String STDIN_FILENAME = "--stdin-filename";
    private static final String DEFAULT_ERROR_PREFIX = "Error: ";
    private final boolean myIsOnTheFly;

    public StylelintExternalRunner(boolean isOnTheFly) {
        this.myIsOnTheFly = isOnTheFly;
    }

    public JSLinterAnnotationResult<StylelintState> execute(JSLinterInput<StylelintState> input) {
        VirtualFile fileToLint = input.getVirtualFile();
        if (!fileToLint.isValid() || fileToLint.getParent() == null) {
            return null;
        }
        try {
            boolean canRun;
            StylelintState state = input.getState();
            NodeJsInterpreter interpreter = state.getInterpreterRef().resolve(input.getProject());
            NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.castAndValidate(interpreter);
            StylelintPackage stylelintPackage = StylelintPackage.fromNodePackage(input.getProject(), state.getStylelintPackage(), this.myIsOnTheFly);
            Project project = input.getProject();
            if (project.isDisposed()) {
                return null;
            }
            VirtualFile workingDirectory = (VirtualFile)ReadAction.compute(() -> StylelintUtil.findWorkingDirectory(fileToLint));
            if (workingDirectory == null) {
                return null;
            }
            if (this.myIsOnTheFly) {
                ((StylelintConfigFileChangeTracker)ServiceManager.getService((Project)project, StylelintConfigFileChangeTracker.class)).startIfNeeded();
            }
            boolean bl = canRun = !this.myIsOnTheFly || (Boolean)ReadAction.compute(() -> {
                if (project.isDisposed()) {
                    return false;
                }
                Collection<VirtualFile> configs = StylelintUtil.getPossibleConfigs(workingDirectory, true);
                return ((StylelintUnsavedConfigFileManager)ServiceManager.getService((Project)project, StylelintUnsavedConfigFileManager.class)).requestSaveIfNeeded(configs);
            }) != false;
            if (!canRun) {
                LOG.debug("Stylelint postponed because of unsaved configs");
                return null;
            }
            StylelintSessionData sessionData = new StylelintSessionData(localInterpreter, stylelintPackage, workingDirectory, fileToLint, input.getFileContent(), StylelintExternalRunner.suggestSyntax(input.getPsiFile()));
            return StylelintExternalRunner.stylelint(input, sessionData);
        }
        catch (JSLinterNpmPackageDoesNotExistsException e) {
            return JSLinterAnnotationResult.create(input, e.getAnnotation(), null);
        }
        catch (ExecutionException | IOException e) {
            return StylelintExternalRunner.createFileLevelWarning(e.getMessage(), input);
        }
    }

    @Nullable
    private static String suggestSyntax(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "suggestSyntax"));
        }
        if (file instanceof StylesheetFile) {
            Language language = file.getLanguage();
            String languageId = language.getID();
            if ("LESS".equals(languageId)) {
                return "less";
            }
            if ("SCSS".equals(languageId)) {
                return "scss";
            }
        }
        return null;
    }

    private static JSLinterAnnotationResult<StylelintState> stylelint(@NotNull JSLinterInput<StylelintState> input, @NotNull StylelintSessionData sessionData) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "stylelint"));
        }
        if (sessionData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionData", "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "stylelint"));
        }
        long startNanoTime = System.nanoTime();
        JSLinterAnnotationResult<StylelintState> result = StylelintExternalRunner.runProcess(input, sessionData);
        StylelintExternalRunner.logEnd(startNanoTime, result.getErrors().size());
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static JSLinterAnnotationResult<StylelintState> runProcess(@NotNull JSLinterInput<StylelintState> input, @NotNull StylelintSessionData sessionData) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", new Object[]{"input", "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "runProcess"}));
        }
        if (sessionData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", new Object[]{"sessionData", "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "runProcess"}));
        }
        commandLine = StylelintExternalRunner.createCommandLine(sessionData);
        StylelintExternalRunner.logStart(sessionData, commandLine);
        processHandler = new KillableColoredProcessHandler(commandLine, false);
        try {
            StylelintExternalRunner.writeFileContentToStdin(processHandler, sessionData, commandLine.getCharset());
            ** GOTO lbl-1000
        }
        catch (IOException e) {
            StylelintExternalRunner.LOG.warn((Throwable)e);
            output = StylelintExternalRunner.captureOutput((BaseOSProcessHandler)processHandler);
            output.appendStderr("\n" + e.getMessage() + "\n");
            v0 = StylelintExternalRunner.createFileLevelWarning(e.getMessage(), input, commandLine, (ProcessHandler)processHandler, output);
            if (v0 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "runProcess"}));
            }
            return v0;
        }
        {
            block19: {
                block18: {
                    catch (ExecutionException e) {
                        v1 = StylelintExternalRunner.createFileLevelWarning(e.getMessage(), input);
                        if (v1 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "runProcess"}));
                        }
                        return v1;
                    }
lbl-1000:
                    // 1 sources

                    {
                        output = StylelintExternalRunner.captureOutput((BaseOSProcessHandler)processHandler);
                        stderr = output.getStderr();
                        if (StringUtil.isEmptyOrSpaces((String)stderr)) break block18;
                        v2 = StylelintExternalRunner.createFileLevelWarning(stderr, input, commandLine, (ProcessHandler)processHandler, output);
                    }
                    if (v2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "runProcess"}));
                    }
                    return v2;
                }
                stylelintResultParser = new StylelintResultParser();
                stdout = output.getStdout();
                errors = stylelintResultParser.parse(stdout);
                if (errors != null) break block19;
                v3 = StylelintExternalRunner.createFileLevelWarning(stdout, input, commandLine, (ProcessHandler)processHandler, output);
                if (v3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "runProcess"}));
                }
                return v3;
            }
            try {
                v4 = JSLinterAnnotationResult.createLinterResult(input, errors, null);
            }
            catch (Exception e) {}
            {
                v5 = StylelintExternalRunner.createFileLevelWarning(e.getMessage(), input, commandLine, (ProcessHandler)processHandler, output);
            }
            if (v5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "runProcess"}));
            }
            return v5;
            if (v4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "runProcess"}));
            }
            return v4;
        }
    }

    private static void writeFileContentToStdin(@NotNull KillableColoredProcessHandler processHandler, @NotNull StylelintSessionData sessionData, @NotNull Charset charset) throws IOException {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "writeFileContentToStdin"));
        }
        if (sessionData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionData", "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "writeFileContentToStdin"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "writeFileContentToStdin"));
        }
        String content = sessionData.getFileToLintContent();
        try (OutputStream stdin = (OutputStream)ObjectUtils.assertNotNull((Object)processHandler.getProcessInput());){
            stdin.write(content.getBytes(charset));
            stdin.flush();
        }
    }

    @NotNull
    private static GeneralCommandLine createCommandLine(@NotNull StylelintSessionData sessionData) {
        String relativePath;
        if (sessionData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionData", "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "createCommandLine"));
        }
        String stylelintAbsolutePath = sessionData.getStylelintPackage().getCli().getPath();
        File workDirectory = ApplicationManager.getApplication().isUnitTestMode() ? new File(FileUtil.getTempDirectory()) : VfsUtilCore.virtualToIoFile((VirtualFile)sessionData.getWorkingDir());
        GeneralCommandLine commandLine = new GeneralCommandLine().withCharset(StandardCharsets.UTF_8).withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withWorkDirectory(workDirectory).withExePath(sessionData.getInterpreter().getInterpreterSystemDependentPath()).withParameters(new String[]{stylelintAbsolutePath, FORMAT_PARAMETER, JSON_FORMAT});
        if (sessionData.getSyntax() != null) {
            commandLine.withParameters(new String[]{SYNTAX, sessionData.getSyntax()});
        }
        if ((relativePath = FileUtil.getRelativePath((String)workDirectory.getAbsolutePath(), (String)sessionData.getFileToLint().getPath(), (char)File.separatorChar)) != null) {
            commandLine.withParameters(new String[]{STDIN_FILENAME, relativePath});
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "createCommandLine"));
        }
        return generalCommandLine;
    }

    @NotNull
    private static ProcessOutput captureOutput(@NotNull BaseOSProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "captureOutput"));
        }
        ProcessOutputCatcher catcher = new ProcessOutputCatcher(processHandler);
        catcher.startNotify();
        catcher.run();
        ProcessOutput processOutput = catcher.getOutput();
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "captureOutput"));
        }
        return processOutput;
    }

    @NotNull
    private static JSLinterAnnotationResult<StylelintState> createFileLevelWarning(@NotNull String message, @NotNull JSLinterInput<StylelintState> input) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "createFileLevelWarning"));
        }
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "createFileLevelWarning"));
        }
        JSLinterAnnotationResult<StylelintState> jSLinterAnnotationResult = JSLinterAnnotationResult.create(input, new JSLinterFileLevelAnnotation(StringUtil.decapitalize((String)message)), null);
        if (jSLinterAnnotationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "createFileLevelWarning"));
        }
        return jSLinterAnnotationResult;
    }

    @NotNull
    private static JSLinterAnnotationResult<StylelintState> createFileLevelWarning(@NotNull String message, @NotNull JSLinterInput<StylelintState> input, @NotNull GeneralCommandLine commandLine, @NotNull ProcessHandler processHandler, @NotNull ProcessOutput output) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "createFileLevelWarning"));
        }
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "createFileLevelWarning"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "createFileLevelWarning"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "createFileLevelWarning"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "createFileLevelWarning"));
        }
        JsqtViewProcessOutputAction detailsAction = new JsqtViewProcessOutputAction("Failed to lint " + input.getVirtualFile().getPath(), JavaScriptLanguageIcons.FileTypes.Stylelint, commandLine, processHandler, output);
        String errorMessage = StringUtil.splitByLines((String)message)[0];
        errorMessage = StringUtil.trimStart((String)errorMessage, (String)DEFAULT_ERROR_PREFIX);
        errorMessage = StringUtil.decapitalize((String)errorMessage);
        JSLinterAnnotationResult<StylelintState> jSLinterAnnotationResult = JSLinterAnnotationResult.create(input, new JSLinterFileLevelAnnotation(errorMessage, detailsAction).withIcon(JavaScriptLanguageIcons.FileTypes.Stylelint), null);
        if (jSLinterAnnotationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "createFileLevelWarning"));
        }
        return jSLinterAnnotationResult;
    }

    private static void logStart(@NotNull StylelintSessionData sessionData, @NotNull GeneralCommandLine commandLine) {
        if (sessionData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionData", "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "logStart"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner", "logStart"));
        }
        String stylelintVersion = sessionData.getStylelintPackage().getVersionStr();
        String fileToLintPath = sessionData.getFileToLint().getPath();
        LOG.info(String.format("Running stylelint@%s at %s$ %s", stylelintVersion, fileToLintPath, commandLine.getCommandLineString()));
    }

    private static void logEnd(long startTime, int resultSize) {
        long durationMillis = TimeoutUtil.getDurationMillis((long)startTime);
        LOG.info(String.format(CssBundle.message((String)"css.stylelint.message.prefix", (Object[])new Object[0]) + " done in %d ms, found %d problems", durationMillis, resultSize));
    }
}

